/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.DisplayPageFormContainerSubmissionResult;
import com.liferay.headless.admin.site.dto.v1_0.EmbeddedMessageFormContainerSubmissionResult;
import com.liferay.headless.admin.site.dto.v1_0.FormContainerClassSubtypeReference;
import com.liferay.headless.admin.site.dto.v1_0.FormContainerConfig;
import com.liferay.headless.admin.site.dto.v1_0.FormContainerContextReference;
import com.liferay.headless.admin.site.dto.v1_0.FormContainerPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FormContainerReference;
import com.liferay.headless.admin.site.dto.v1_0.FragmentInlineValue;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.LocalizationConfig;
import com.liferay.headless.admin.site.dto.v1_0.SitePageFormContainerSubmissionResult;
import com.liferay.headless.admin.site.dto.v1_0.StayInPageFormContainerSubmissionResult;
import com.liferay.headless.admin.site.dto.v1_0.SuccessFormContainerSubmissionResult;
import com.liferay.headless.admin.site.dto.v1_0.SuccessNotificationMessage;
import com.liferay.headless.admin.site.dto.v1_0.URLFormContainerSubmissionResult;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentViewportUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.LocalizedValueUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.util.structure.FormStyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.FormStyledLayoutStructureItem"}, service={DTOConverter.class})
public class FormContainerPageElementDefinitionDTOConverter
implements DTOConverter<FormStyledLayoutStructureItem, FormContainerPageElementDefinition> {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;

    public String getContentType() {
        return FormContainerPageElementDefinition.class.getSimpleName();
    }

    public FormContainerPageElementDefinition toDTO(DTOConverterContext dtoConverterContext, FormStyledLayoutStructureItem formStyledLayoutStructureItem) throws Exception {
        Long companyId = (Long)dtoConverterContext.getAttribute("companyId");
        Long scopeGroupId = (Long)dtoConverterContext.getAttribute("scopeGroupId");
        if (companyId == null || scopeGroupId == null) {
            throw new UnsupportedOperationException();
        }
        FormContainerPageElementDefinition formContainerPageElementDefinition = new FormContainerPageElementDefinition();
        formContainerPageElementDefinition.setCssClasses(() -> {
            if (SetUtil.isEmpty((Set)formStyledLayoutStructureItem.getCssClasses())) {
                return null;
            }
            return ArrayUtil.toStringArray((Collection)formStyledLayoutStructureItem.getCssClasses());
        });
        formContainerPageElementDefinition.setCustomCSS(() -> {
            String customCSS = formStyledLayoutStructureItem.getCustomCSS();
            if (Validator.isNotNull((String)customCSS)) {
                return customCSS;
            }
            return null;
        });
        formContainerPageElementDefinition.setFormContainerConfig(() -> this._toFormContainerConfig(companyId, formStyledLayoutStructureItem, scopeGroupId));
        formContainerPageElementDefinition.setFragmentViewports(() -> FragmentViewportUtil.toFragmentViewports(formStyledLayoutStructureItem.getItemConfigJSONObject()));
        formContainerPageElementDefinition.setIndexed(() -> ((FormStyledLayoutStructureItem)formStyledLayoutStructureItem).isIndexed());
        formContainerPageElementDefinition.setLayout(() -> LayoutUtil.toLayout(formStyledLayoutStructureItem.getItemConfigJSONObject()));
        formContainerPageElementDefinition.setName(() -> ((FormStyledLayoutStructureItem)formStyledLayoutStructureItem).getName());
        return formContainerPageElementDefinition;
    }

    private FormContainerConfig _toFormContainerConfig(final long companyId, final FormStyledLayoutStructureItem formStyledLayoutStructureItem, final long scopeGroupId) {
        if (formStyledLayoutStructureItem.getFormConfig() != 1 && formStyledLayoutStructureItem.getFormConfig() != 2) {
            return null;
        }
        return new FormContainerConfig(){
            {
                this.setFormContainerReference(() -> FormContainerPageElementDefinitionDTOConverter.this._toFormContainerReference(formStyledLayoutStructureItem));
                this.setFormContainerType(() -> {
                    if (Objects.equals(formStyledLayoutStructureItem.getFormType(), "simple")) {
                        return FormContainerConfig.FormContainerType.SIMPLE;
                    }
                    return FormContainerConfig.FormContainerType.MULTISTEP;
                });
                this.setLocalizationConfig(() -> FormContainerPageElementDefinitionDTOConverter.this._toLocalizationConfig(formStyledLayoutStructureItem));
                this.setNumberOfSteps(() -> ((FormStyledLayoutStructureItem)formStyledLayoutStructureItem).getNumberOfSteps());
                this.setSuccessFormContainerSubmissionResult(() -> FormContainerPageElementDefinitionDTOConverter.this._toSuccessFormContainerSubmissionResult(companyId, formStyledLayoutStructureItem.getSuccessMessageJSONObject(), scopeGroupId));
            }
        };
    }

    private FormContainerReference _toFormContainerReference(FormStyledLayoutStructureItem formStyledLayoutStructureItem) {
        if (formStyledLayoutStructureItem.getFormConfig() == 2) {
            FormContainerClassSubtypeReference formContainerClassSubtypeReference = new FormContainerClassSubtypeReference();
            formContainerClassSubtypeReference.setClassName(() -> ((FormStyledLayoutStructureItem)formStyledLayoutStructureItem).getClassName());
            return formContainerClassSubtypeReference;
        }
        FormContainerContextReference formContainerContextReference = new FormContainerContextReference();
        formContainerContextReference.setContextSource(() -> FormContainerContextReference.ContextSource.DISPLAY_PAGE_ITEM);
        return formContainerContextReference;
    }

    private FragmentInlineValue _toFragmentInlineValue(JSONObject jsonObject) {
        if (JSONUtil.isEmpty((JSONObject)jsonObject)) {
            return null;
        }
        FragmentInlineValue fragmentInlineValue = new FragmentInlineValue();
        fragmentInlineValue.setValue_i18n(() -> LocalizedValueUtil.toLocalizedValues(jsonObject));
        return fragmentInlineValue;
    }

    private ItemExternalReference _toLayoutItemExternalReference(long companyId, JSONObject layoutJSONObject, long scopeGroupId) {
        if (JSONUtil.isEmpty((JSONObject)layoutJSONObject)) {
            return null;
        }
        Layout layout = this._layoutLocalService.fetchLayout(layoutJSONObject.getLong("groupId"), layoutJSONObject.getBoolean("privateLayout"), layoutJSONObject.getLong("layoutId"));
        String externalReferenceCode = layout != null ? layout.getExternalReferenceCode() : layoutJSONObject.getString("externalReferenceCode");
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        ItemExternalReference itemExternalReference = new ItemExternalReference();
        itemExternalReference.setClassName(Layout.class::getName);
        itemExternalReference.setExternalReferenceCode(() -> externalReferenceCode);
        itemExternalReference.setScope(() -> {
            if (layout != null) {
                return ItemScopeUtil.getItemScope(layout.getGroupId(), scopeGroupId);
            }
            return ItemScopeUtil.getItemScope(companyId, layoutJSONObject.getString("scopeExternalReferenceCode"), scopeGroupId);
        });
        return itemExternalReference;
    }

    private ItemExternalReference _toLayoutPageTemplateEntryItemExternalReference(long companyId, String displayPage, JSONObject jsonObject, long scopeGroupId) {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry((long)GetterUtil.getInteger((String)StringUtil.removeSubstring((String)displayPage, (String)(LayoutPageTemplateEntry.class.getSimpleName() + "_"))));
        String layoutPageTemplateEntryExternalReferenceCode = layoutPageTemplateEntry != null ? layoutPageTemplateEntry.getExternalReferenceCode() : jsonObject.getString("layoutPageTemplateEntryExternalReferenceCode");
        ItemExternalReference itemExternalReference = new ItemExternalReference();
        itemExternalReference.setClassName(LayoutPageTemplateEntry.class::getName);
        itemExternalReference.setExternalReferenceCode(() -> layoutPageTemplateEntryExternalReferenceCode);
        itemExternalReference.setScope(() -> {
            if (layoutPageTemplateEntry != null) {
                return ItemScopeUtil.getItemScope(layoutPageTemplateEntry.getGroupId(), scopeGroupId);
            }
            return ItemScopeUtil.getItemScope(companyId, jsonObject.getString("layoutPageTemplateEntryScopeExternalReferenceCode"), scopeGroupId);
        });
        return itemExternalReference;
    }

    private LocalizationConfig _toLocalizationConfig(FormStyledLayoutStructureItem formStyledLayoutStructureItem) {
        final JSONObject jsonObject = formStyledLayoutStructureItem.getLocalizationConfigJSONObject();
        if (JSONUtil.isEmpty((JSONObject)jsonObject)) {
            return null;
        }
        return new LocalizationConfig(){
            {
                this.setUnlocalizedFieldsMessageFragmentInlineValue(() -> FormContainerPageElementDefinitionDTOConverter.this._toFragmentInlineValue(jsonObject.getJSONObject("unlocalizedFieldsMessage")));
                this.setUnlocalizedFieldsState(() -> {
                    String unlocalizedFieldsState = jsonObject.getString("unlocalizedFieldsState");
                    if (StringUtil.equals((String)"read-only", (String)unlocalizedFieldsState)) {
                        return LocalizationConfig.UnlocalizedFieldsState.READ_ONLY;
                    }
                    return LocalizationConfig.UnlocalizedFieldsState.DISABLED;
                });
            }
        };
    }

    private SuccessFormContainerSubmissionResult _toSuccessFormContainerSubmissionResult(long companyId, JSONObject jsonObject, long scopeGroupId) {
        if (JSONUtil.isEmpty((JSONObject)jsonObject)) {
            return null;
        }
        String type = jsonObject.getString("type");
        if (Validator.isNull((String)type)) {
            return null;
        }
        if (StringUtil.equals((String)type, (String)"displayPage")) {
            DisplayPageFormContainerSubmissionResult displayPageFormContainerSubmissionResult = new DisplayPageFormContainerSubmissionResult();
            String displayPage = jsonObject.getString("displayPage");
            if (StringUtil.startsWith((String)displayPage, (String)(LayoutPageTemplateEntry.class.getSimpleName() + "_"))) {
                displayPageFormContainerSubmissionResult.setItemExternalReference(() -> this._toLayoutPageTemplateEntryItemExternalReference(companyId, displayPage, jsonObject, scopeGroupId));
            } else {
                displayPageFormContainerSubmissionResult.setDefaultDisplayPage(() -> Boolean.TRUE);
            }
            displayPageFormContainerSubmissionResult.setSuccessNotificationMessage(() -> this._toSuccessNotificationMessage(jsonObject));
            return displayPageFormContainerSubmissionResult;
        }
        if (StringUtil.equals((String)type, (String)"embedded")) {
            EmbeddedMessageFormContainerSubmissionResult embeddedMessageFormContainerSubmissionResult = new EmbeddedMessageFormContainerSubmissionResult();
            embeddedMessageFormContainerSubmissionResult.setMessage(() -> this._toFragmentInlineValue(jsonObject.getJSONObject("message")));
            embeddedMessageFormContainerSubmissionResult.setSuccessNotificationMessage(() -> this._toSuccessNotificationMessage(jsonObject));
            return embeddedMessageFormContainerSubmissionResult;
        }
        if (StringUtil.equals((String)type, (String)"none")) {
            StayInPageFormContainerSubmissionResult stayInPageFormContainerSubmissionResult = new StayInPageFormContainerSubmissionResult();
            stayInPageFormContainerSubmissionResult.setSuccessNotificationMessage(() -> this._toSuccessNotificationMessage(jsonObject));
            return stayInPageFormContainerSubmissionResult;
        }
        if (StringUtil.equals((String)type, (String)"page")) {
            SitePageFormContainerSubmissionResult sitePageFormContainerSubmissionResult = new SitePageFormContainerSubmissionResult();
            sitePageFormContainerSubmissionResult.setItemExternalReference(() -> this._toLayoutItemExternalReference(companyId, jsonObject.getJSONObject("layout"), scopeGroupId));
            sitePageFormContainerSubmissionResult.setSuccessNotificationMessage(() -> this._toSuccessNotificationMessage(jsonObject));
            return sitePageFormContainerSubmissionResult;
        }
        if (StringUtil.equals((String)type, (String)"url")) {
            URLFormContainerSubmissionResult urlFormContainerSubmissionResult = new URLFormContainerSubmissionResult();
            urlFormContainerSubmissionResult.setUrl(() -> this._toFragmentInlineValue(jsonObject.getJSONObject("url")));
            return urlFormContainerSubmissionResult;
        }
        return null;
    }

    private SuccessNotificationMessage _toSuccessNotificationMessage(JSONObject jsonObject) {
        if (!jsonObject.has("notificationText") && !jsonObject.has("showNotification")) {
            return null;
        }
        SuccessNotificationMessage successNotificationMessage = new SuccessNotificationMessage();
        successNotificationMessage.setMessage(() -> this._toFragmentInlineValue(jsonObject.getJSONObject("notificationText")));
        successNotificationMessage.setShowNotification(() -> GetterUtil.getBoolean((Object)jsonObject.getBoolean("showNotification")));
        return successNotificationMessage;
    }
}

