/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.WidgetInstance;
import com.liferay.headless.admin.site.dto.v1_0.WidgetInstancePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPermission;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentViewportUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.LayoutStructureItemImporter;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.context.LayoutStructureItemImporterContext;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutStructureUtil;
import com.liferay.layout.importer.PortletPermissionsImporter;
import com.liferay.layout.importer.PortletPreferencesPortletConfigurationImporter;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class WidgetInstanceLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    private static final ServiceTracker<FragmentEntryProcessorRegistry, FragmentEntryProcessorRegistry> _fragmentEntryProcessorRegistryServiceTracker = ServiceTrackerFactory.open((Bundle)FrameworkUtil.getBundle(WidgetInstanceLayoutStructureItemImporter.class), FragmentEntryProcessorRegistry.class);
    private static final ServiceTracker<PortletPermissionsImporter, PortletPermissionsImporter> _portletPermissionsImporterServiceTracker = ServiceTrackerFactory.open((Bundle)FrameworkUtil.getBundle(WidgetInstanceLayoutStructureItemImporter.class), PortletPermissionsImporter.class);
    private static final ServiceTracker<PortletPreferencesPortletConfigurationImporter, PortletPreferencesPortletConfigurationImporter> _portletPreferencesPortletConfigurationImporterServiceTracker = ServiceTrackerFactory.open((Bundle)FrameworkUtil.getBundle(WidgetInstanceLayoutStructureItemImporter.class), PortletPreferencesPortletConfigurationImporter.class);

    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement) throws Exception {
        WidgetInstancePageElementDefinition widgetInstancePageElementDefinition = (WidgetInstancePageElementDefinition)pageElement.getPageElementDefinition();
        if (widgetInstancePageElementDefinition == null) {
            return null;
        }
        WidgetInstance widgetInstance = widgetInstancePageElementDefinition.getWidgetInstance();
        if (widgetInstance == null) {
            throw new UnsupportedOperationException();
        }
        Layout layout = layoutStructureItemImporterContext.getLayout();
        String portletId = PortletIdCodec.encode((String)widgetInstance.getWidgetName(), (String)widgetInstance.getWidgetInstanceId());
        this._importPortletPreferences(layout, portletId, widgetInstance.getWidgetConfig());
        this._importPortletPermissions(layout, portletId, widgetInstance.getWidgetName(), widgetInstance.getWidgetPermissions());
        FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.fetchFragmentEntryLinkByExternalReferenceCode((String)widgetInstancePageElementDefinition.getWidgetInstanceExternalReferenceCode(), (long)layoutStructureItemImporterContext.getGroupId());
        fragmentEntryLink = fragmentEntryLink == null ? this._addFragmentEntryLink(widgetInstancePageElementDefinition.getDraftWidgetInstanceExternalReferenceCode(), widgetInstancePageElementDefinition.getWidgetInstanceExternalReferenceCode(), layoutStructureItemImporterContext, widgetInstance) : this._updateFragmentEntryLink(widgetInstancePageElementDefinition.getDraftWidgetInstanceExternalReferenceCode(), fragmentEntryLink, layoutStructureItemImporterContext, widgetInstance);
        FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructure.addFragmentStyledLayoutStructureItem(fragmentEntryLink.getFragmentEntryLinkId(), pageElement.getExternalReferenceCode(), LayoutStructureUtil.getParentExternalReferenceCode(pageElement, layoutStructure), pageElement.getPosition().intValue());
        fragmentStyledLayoutStructureItem.setCssClasses(this._getCssClasses(widgetInstancePageElementDefinition.getCssClasses()));
        fragmentStyledLayoutStructureItem.setCustomCSS(widgetInstancePageElementDefinition.getCustomCSS());
        fragmentStyledLayoutStructureItem.setFragmentEntryLinkId(fragmentEntryLink.getFragmentEntryLinkId());
        fragmentStyledLayoutStructureItem.setIndexed(GetterUtil.getBoolean((Object)widgetInstancePageElementDefinition.getIndexed()));
        fragmentStyledLayoutStructureItem.setName(widgetInstancePageElementDefinition.getName());
        JSONObject fragmentViewportsJSONObject = FragmentViewportUtil.toFragmentViewportsJSONObject(widgetInstancePageElementDefinition.getFragmentViewports());
        if (fragmentViewportsJSONObject != null) {
            fragmentStyledLayoutStructureItem.updateItemConfig(fragmentViewportsJSONObject);
        }
        return fragmentStyledLayoutStructureItem;
    }

    private FragmentEntryLink _addFragmentEntryLink(String draftWidgetInstanceExternalReferenceCode, String externalReferenceCode, LayoutStructureItemImporterContext layoutStructureItemImporterContext, WidgetInstance widgetInstance) throws Exception {
        Layout layout = layoutStructureItemImporterContext.getLayout();
        JSONObject editableValueJSONObject = this._getEditableValuesJSONObject(null, widgetInstance);
        return FragmentEntryLinkLocalServiceUtil.addFragmentEntryLink((String)externalReferenceCode, (long)layoutStructureItemImporterContext.getUserId(), (long)layoutStructureItemImporterContext.getGroupId(), (String)draftWidgetInstanceExternalReferenceCode, null, null, (long)layoutStructureItemImporterContext.getSegmentsExperienceId(), (long)layout.getPlid(), (String)"", (String)"", (String)"", (String)"", (String)editableValueJSONObject.toString(), (String)this._getNamespace(widgetInstance), (int)0, null, (int)4, (ServiceContext)new ServiceContext());
    }

    private LinkedHashSet<String> _getCssClasses(String[] cssClasses) {
        if (cssClasses == null) {
            return null;
        }
        return new LinkedHashSet<String>(Arrays.asList(cssClasses));
    }

    private JSONObject _getEditableValuesJSONObject(FragmentEntryLink fragmentEntryLink, WidgetInstance widgetInstance) {
        JSONObject editableValuesJSONObject = null;
        FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry = (FragmentEntryProcessorRegistry)_fragmentEntryProcessorRegistryServiceTracker.getService();
        editableValuesJSONObject = fragmentEntryLink != null ? fragmentEntryLink.getEditableValuesJSONObject() : (fragmentEntryProcessorRegistry != null ? fragmentEntryProcessorRegistry.getDefaultEditableValuesJSONObject("", null) : JSONFactoryUtil.createJSONObject());
        return editableValuesJSONObject.put("instanceId", () -> {
            String instanceId = this._getInstanceId(widgetInstance.getWidgetInstanceId(), widgetInstance.getWidgetName());
            if (Validator.isNull((String)instanceId)) {
                return null;
            }
            return instanceId;
        }).put("portletId", widgetInstance.getWidgetName());
    }

    private String _getInstanceId(String widgetInstanceId, String widgetName) {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)widgetName);
        if (portlet.isInstanceable()) {
            return widgetInstanceId;
        }
        return "";
    }

    private String _getNamespace(WidgetInstance widgetInstance) {
        String namespace = null;
        namespace = Validator.isNull((String)widgetInstance.getWidgetInstanceId()) ? StringUtil.randomId() : widgetInstance.getWidgetInstanceId();
        return namespace;
    }

    private List<Map<String, Object>> _getWidgetPermissionsMaps(WidgetPermission[] widgetPermissions) {
        if (ArrayUtil.isEmpty((Object[])widgetPermissions)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> widgetPermissionsMaps = new ArrayList<Map<String, Object>>();
        for (WidgetPermission widgetPermission : widgetPermissions) {
            widgetPermissionsMaps.add(HashMapBuilder.put((Object)"actionKeys", Arrays.asList(widgetPermission.getActionIds())).put((Object)"roleKey", (Object)widgetPermission.getRoleName()).build());
        }
        return widgetPermissionsMaps;
    }

    private void _importPortletPermissions(Layout layout, String portletId, String portletName, WidgetPermission[] widgetPermissions) throws Exception {
        PortletPermissionsImporter portletPermissionsImporter = (PortletPermissionsImporter)_portletPermissionsImporterServiceTracker.getService();
        if (portletPermissionsImporter == null) {
            return;
        }
        if (widgetPermissions != null && widgetPermissions.length == 0) {
            ResourcePermissionLocalServiceUtil.deleteResourcePermissions((long)layout.getCompanyId(), (String)portletName, (int)4, (String)PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId));
            return;
        }
        portletPermissionsImporter.importPortletPermissions(layout.getPlid(), portletId, Collections.emptySet(), this._getWidgetPermissionsMaps(widgetPermissions));
    }

    private void _importPortletPreferences(Layout layout, String portletId, Map<String, Object> widgetConfig) throws Exception {
        PortletPreferencesPortletConfigurationImporter portletPreferencesPortletConfigurationImporter = (PortletPreferencesPortletConfigurationImporter)_portletPreferencesPortletConfigurationImporterServiceTracker.getService();
        if (portletPreferencesPortletConfigurationImporter == null) {
            return;
        }
        portletPreferencesPortletConfigurationImporter.importPortletConfiguration(layout.getPlid(), portletId, widgetConfig);
    }

    private FragmentEntryLink _updateFragmentEntryLink(String draftWidgetInstanceExternalReferenceCode, FragmentEntryLink fragmentEntryLink, LayoutStructureItemImporterContext layoutStructureItemImporterContext, WidgetInstance widgetInstance) throws Exception {
        String widgetInstancePortletId;
        JSONObject editableValuesJSONObject = fragmentEntryLink.getEditableValuesJSONObject();
        String fragmentEntryLinkPortletId = PortletIdCodec.encode((String)editableValuesJSONObject.getString("portletId"), (String)editableValuesJSONObject.getString("instanceId"));
        if (!StringUtil.equals((String)fragmentEntryLinkPortletId, (String)(widgetInstancePortletId = PortletIdCodec.encode((String)widgetInstance.getWidgetName(), (String)widgetInstance.getWidgetInstanceId())))) {
            Layout layout = layoutStructureItemImporterContext.getLayout();
            PortletPreferencesLocalServiceUtil.deletePortletPreferences((long)0L, (int)3, (long)layout.getPlid(), (String)fragmentEntryLinkPortletId);
            ResourcePermissionLocalServiceUtil.deleteResourcePermissions((long)layout.getCompanyId(), (String)editableValuesJSONObject.getString("portletId"), (int)4, (String)PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)fragmentEntryLinkPortletId));
        }
        editableValuesJSONObject = this._getEditableValuesJSONObject(fragmentEntryLink, widgetInstance);
        fragmentEntryLink.setOriginalFragmentEntryLinkERC(draftWidgetInstanceExternalReferenceCode);
        fragmentEntryLink.setEditableValues(editableValuesJSONObject.toString());
        return FragmentEntryLinkLocalServiceUtil.updateFragmentEntryLink((FragmentEntryLink)fragmentEntryLink);
    }
}

