/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.util;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.OpenGraphSettings;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;

public class OpenGraphSettingsUtil {
    public static OpenGraphSettings getOpenGraphSettings(final DLAppService dlAppService, LayoutSEOEntryLocalService layoutSEOEntryLocalService, final Layout layout) {
        final LayoutSEOEntry layoutSEOEntry = layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        if (layoutSEOEntry == null) {
            return null;
        }
        return new OpenGraphSettings(){
            {
                this.setDescription_i18n(() -> LocalizedMapUtil.getI18nMap((Map)layoutSEOEntry.getOpenGraphDescriptionMap()));
                this.setImage(() -> {
                    long openGraphImageFileEntryId = layoutSEOEntry.getOpenGraphImageFileEntryId();
                    if (openGraphImageFileEntryId == 0L) {
                        return null;
                    }
                    final FileEntry fileEntry = dlAppService.getFileEntry(openGraphImageFileEntryId);
                    return new ItemExternalReference(){
                        {
                            this.setClassName(FileEntry.class::getName);
                            this.setExternalReferenceCode(() -> ((FileEntry)fileEntry).getExternalReferenceCode());
                            this.setScope(() -> ItemScopeUtil.getItemScope(fileEntry.getGroupId(), layout.getGroupId()));
                        }
                    };
                });
                this.setImageAlt_i18n(() -> LocalizedMapUtil.getI18nMap((Map)layoutSEOEntry.getOpenGraphImageAltMap()));
                this.setTitle_i18n(() -> LocalizedMapUtil.getI18nMap((Map)layoutSEOEntry.getOpenGraphTitleMap()));
            }
        };
    }
}

