/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.GeneralConfig;
import com.liferay.headless.admin.site.dto.v1_0.WidgetLookAndFeelConfig;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageWidgetInstance;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPermission;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.layout.exporter.PortletPermissionsExporter;
import com.liferay.layout.exporter.PortletPreferencesPortletConfigurationExporter;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import jakarta.portlet.PortletPreferences;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DTOConverter.class})
public class WidgetPageWidgetInstanceDTOConverter
implements DTOConverter<Layout, WidgetPageWidgetInstance> {
    private static final Collection<String> _excludePreferencesNames = ListUtil.fromArray((Object[])new String[]{"portletSetupUseCustomTitle", "portletSetupPortletDecoratorId", "portletSetupCss"});
    @Reference
    private PortletPermissionsExporter _portletPermissionsExporter;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;
    @Reference
    private PortletPreferencesPortletConfigurationExporter _portletPreferencesPortletConfigurationExporter;

    public String getContentType() {
        return WidgetPageWidgetInstance.class.getSimpleName();
    }

    public WidgetPageWidgetInstance toDTO(DTOConverterContext dtoConverterContext, final Layout layout) throws Exception {
        final String portletId = GetterUtil.getString((Object)dtoConverterContext.getAttribute("portletId"), null);
        if (portletId == null || !layout.isTypePortlet()) {
            return null;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        if (!layoutTypePortlet.hasPortletId(portletId)) {
            return null;
        }
        return new WidgetPageWidgetInstance(){
            {
                this.setExternalReferenceCode(() -> portletId);
                this.setParentSectionId(() -> LayoutUtil.getParentSectionId(layout, portletId));
                this.setPosition(() -> LayoutUtil.getPosition(layout, portletId));
                this.setWidgetConfig(() -> {
                    Map portletConfigurationMap = WidgetPageWidgetInstanceDTOConverter.this._portletPreferencesPortletConfigurationExporter.getPortletConfiguration(layout.getPlid(), portletId);
                    HashMap widgetConfig = new HashMap();
                    for (Map.Entry entry : portletConfigurationMap.entrySet()) {
                        String key = (String)entry.getKey();
                        if (_excludePreferencesNames.contains(key) || key.startsWith("portletSetupTitle_")) continue;
                        widgetConfig.put(key, entry.getValue());
                    }
                    if (MapUtil.isEmpty(widgetConfig)) {
                        return null;
                    }
                    return widgetConfig;
                });
                this.setWidgetInstanceId(() -> PortletIdCodec.decodeInstanceId((String)portletId));
                this.setWidgetLookAndFeelConfig(() -> WidgetPageWidgetInstanceDTOConverter.this._getWidgetLookAndFeelConfig(layout, portletId));
                this.setWidgetName(() -> PortletIdCodec.decodePortletName((String)portletId));
                this.setWidgetPermissions(() -> {
                    Map permissionsMap = WidgetPageWidgetInstanceDTOConverter.this._portletPermissionsExporter.getPortletPermissions(layout.getPlid(), portletId);
                    if (MapUtil.isEmpty((Map)permissionsMap)) {
                        return null;
                    }
                    return (WidgetPermission[])TransformUtil.transformToArray(permissionsMap.entrySet(), entry -> new WidgetPermission((Map.Entry)entry){
                        final /* synthetic */ Map.Entry val$entry;
                        {
                            this.val$entry = entry;
                            this.setActionIds(this.val$entry::getValue);
                            this.setRoleName(this.val$entry::getKey);
                        }
                    }, WidgetPermission.class);
                });
            }
        };
    }

    public WidgetPageWidgetInstance toDTO(Layout layout) {
        return null;
    }

    private Map<String, String> _getCustomTitleMap(long groupId, PortletPreferences portletPreferences) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
            String portletSetupTitle = portletPreferences.getValue("portletSetupTitle_" + LocaleUtil.toLanguageId((Locale)locale), null);
            if (!Validator.isNotNull((String)portletSetupTitle)) continue;
            map.put(locale, portletSetupTitle);
        }
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        return LocalizedMapUtil.getI18nMap(map);
    }

    private WidgetLookAndFeelConfig _getWidgetLookAndFeelConfig(final Layout layout, String portletId) {
        final PortletPreferences portletPreferences = this._portletPreferencesFactory.getStrictLayoutPortletSetup(layout, portletId);
        return new WidgetLookAndFeelConfig(){
            {
                this.setGeneralConfig(() -> new GeneralConfig(){
                    {
                        this.setApplicationDecorator(() -> {
                            String value = GetterUtil.getString((String)portletPreferences.getValue("portletSetupPortletDecoratorId", null), null);
                            if (value == null) {
                                return null;
                            }
                            return GeneralConfig.ApplicationDecorator.create((String)StringUtil.upperCaseFirstLetter((String)value));
                        });
                        this.setCustomTitle_i18n(() -> WidgetPageWidgetInstanceDTOConverter.this._getCustomTitleMap(layout.getGroupId(), portletPreferences));
                        this.setUseCustomTitle(() -> {
                            String value = portletPreferences.getValue("portletSetupUseCustomTitle", null);
                            if (value == null) {
                                return null;
                            }
                            return GetterUtil.getBoolean((Object)value);
                        });
                    }
                });
            }
        };
    }
}

