/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryLocalService;
import com.liferay.headless.admin.site.dto.v1_0.ClassNameReference;
import com.liferay.headless.admin.site.dto.v1_0.CollectionDisplayListStyle;
import com.liferay.headless.admin.site.dto.v1_0.CollectionDisplayPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.CollectionDisplayViewport;
import com.liferay.headless.admin.site.dto.v1_0.CollectionDisplayViewportDefinition;
import com.liferay.headless.admin.site.dto.v1_0.CollectionItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.CollectionReference;
import com.liferay.headless.admin.site.dto.v1_0.CollectionSettings;
import com.liferay.headless.admin.site.dto.v1_0.EmptyCollectionConfig;
import com.liferay.headless.admin.site.dto.v1_0.ListStyle;
import com.liferay.headless.admin.site.dto.v1_0.ListStyleDefinition;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.headless.admin.site.dto.v1_0.TemplateListStyle;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.CollectionDisplayListStyleUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ViewportIdUtil;
import com.liferay.item.selector.criteria.InfoListItemSelectorReturnType;
import com.liferay.layout.converter.AlignConverter;
import com.liferay.layout.converter.FlexWrapConverter;
import com.liferay.layout.converter.JustifyConverter;
import com.liferay.layout.converter.VerticalAlignmentConverter;
import com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem;
import com.liferay.layout.util.structure.collection.EmptyCollectionOptions;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem"}, service={DTOConverter.class})
public class CollectionDisplayPageElementDefinitionDTOConverter
implements DTOConverter<CollectionStyledLayoutStructureItem, CollectionDisplayPageElementDefinition> {
    private static final Map<String, CollectionDisplayPageElementDefinition.PaginationType> _internalToExternalValuesMap = HashMapBuilder.put((Object)"none", (Object)CollectionDisplayPageElementDefinition.PaginationType.NONE).put((Object)"numeric", (Object)CollectionDisplayPageElementDefinition.PaginationType.NUMERIC).put((Object)"simple", (Object)CollectionDisplayPageElementDefinition.PaginationType.SIMPLE).build();
    @Reference
    private AssetListEntryLocalService _assetListEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;

    public String getContentType() {
        return CollectionDisplayPageElementDefinition.class.getSimpleName();
    }

    public CollectionDisplayPageElementDefinition toDTO(DTOConverterContext dtoConverterContext, CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) throws Exception {
        Long companyId = (Long)dtoConverterContext.getAttribute("companyId");
        Long scopeGroupId = (Long)dtoConverterContext.getAttribute("scopeGroupId");
        if (companyId == null || scopeGroupId == null) {
            throw new UnsupportedOperationException();
        }
        CollectionDisplayPageElementDefinition collectionDisplayPageElementDefinition = new CollectionDisplayPageElementDefinition();
        collectionDisplayPageElementDefinition.setCollectionDisplayListStyle(() -> this._toCollectionDisplayListStyle(collectionStyledLayoutStructureItem));
        collectionDisplayPageElementDefinition.setCollectionDisplayViewports(() -> this._toCollectionDisplayViewports(collectionStyledLayoutStructureItem));
        collectionDisplayPageElementDefinition.setCollectionSettings(() -> this._toCollectionSettings(collectionStyledLayoutStructureItem, companyId, scopeGroupId));
        collectionDisplayPageElementDefinition.setDisplayAllItems(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).isDisplayAllItems());
        collectionDisplayPageElementDefinition.setDisplayAllPages(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).isDisplayAllPages());
        collectionDisplayPageElementDefinition.setEmptyCollectionConfig(() -> this._toEmptyCollectionOption(collectionStyledLayoutStructureItem));
        collectionDisplayPageElementDefinition.setHidden(() -> this._toHidden(collectionStyledLayoutStructureItem.getStylesJSONObject()));
        collectionDisplayPageElementDefinition.setName(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getName());
        collectionDisplayPageElementDefinition.setNumberOfItems(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getNumberOfItems());
        collectionDisplayPageElementDefinition.setNumberOfItemsPerPage(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getNumberOfItemsPerPage());
        collectionDisplayPageElementDefinition.setNumberOfPages(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getNumberOfPages());
        collectionDisplayPageElementDefinition.setPaginationType(() -> {
            String paginationType = collectionStyledLayoutStructureItem.getPaginationType();
            if (Validator.isNull((String)paginationType)) {
                return null;
            }
            if (StringUtil.equalsIgnoreCase((String)paginationType, (String)"regular")) {
                paginationType = "numeric";
            }
            return _internalToExternalValuesMap.get(paginationType);
        });
        return collectionDisplayPageElementDefinition;
    }

    private Scope _getItemScope(Long companyId, String itemExternalReferenceCode, long scopeGroupId) throws PortalException {
        if (Validator.isNull((String)itemExternalReferenceCode) || companyId == null) {
            return null;
        }
        final Group group = this._groupLocalService.getGroupByExternalReferenceCode(itemExternalReferenceCode, companyId.longValue());
        if (group == null || group.getGroupId() == scopeGroupId) {
            return null;
        }
        return new Scope(){
            {
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setType(() -> {
                    if (group.getType() == 5) {
                        return Scope.Type.ASSET_LIBRARY;
                    }
                    return Scope.Type.SITE;
                });
            }
        };
    }

    private Map<String, Object> _toCollectionConfig(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        JSONObject collectionJSONObject = collectionStyledLayoutStructureItem.getCollectionJSONObject();
        if (collectionJSONObject == null) {
            return null;
        }
        JSONObject configJSONObject = collectionJSONObject.getJSONObject("config");
        if (configJSONObject == null) {
            return null;
        }
        return (Map)this._jsonFactory.looseDeserialize(configJSONObject.toString());
    }

    private CollectionDisplayListStyle _toCollectionDisplayListStyle(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        if (Validator.isNull((String)collectionStyledLayoutStructureItem.getListStyle())) {
            return null;
        }
        String listStyle = CollectionDisplayListStyleUtil.toExternalValue(collectionStyledLayoutStructureItem.getListStyle());
        if (Validator.isNull((String)listStyle)) {
            return this._toTemplateListStyle(collectionStyledLayoutStructureItem);
        }
        return this._toListStyle(collectionStyledLayoutStructureItem);
    }

    private CollectionDisplayViewport _toCollectionDisplayViewport(CollectionDisplayViewport.Id collectionDisplayViewportId, Map<String, JSONObject> collectionDisplayViewportConfigurationJSONObjects) {
        String viewportId = ViewportIdUtil.toInternalValue(collectionDisplayViewportId.getValue());
        if (!collectionDisplayViewportConfigurationJSONObjects.containsKey(viewportId)) {
            return null;
        }
        JSONObject collectionDisplayViewportConfigurationJSONObject = collectionDisplayViewportConfigurationJSONObjects.get(viewportId);
        if (JSONUtil.isEmpty((JSONObject)collectionDisplayViewportConfigurationJSONObject)) {
            return null;
        }
        CollectionDisplayViewportDefinition collectionDisplayViewportDefinition = this._toCollectionDisplayViewportDefinition(collectionDisplayViewportConfigurationJSONObject);
        if (collectionDisplayViewportDefinition == null) {
            return null;
        }
        CollectionDisplayViewport collectionDisplayViewport = new CollectionDisplayViewport();
        collectionDisplayViewport.setCollectionDisplayViewportDefinition(() -> collectionDisplayViewportDefinition);
        collectionDisplayViewport.setId(() -> collectionDisplayViewportId);
        return collectionDisplayViewport;
    }

    private CollectionDisplayViewportDefinition _toCollectionDisplayViewportDefinition(JSONObject collectionDisplayViewportConfigurationJSONObject) {
        String align = collectionDisplayViewportConfigurationJSONObject.getString("align", null);
        String flexWrap = collectionDisplayViewportConfigurationJSONObject.getString("flexWrap", null);
        String numberOfColumns = collectionDisplayViewportConfigurationJSONObject.getString("numberOfColumns", null);
        if (align == null && flexWrap == null && numberOfColumns == null && JSONUtil.isEmpty((JSONObject)collectionDisplayViewportConfigurationJSONObject.getJSONObject("styles"))) {
            return null;
        }
        CollectionDisplayViewportDefinition collectionDisplayViewportDefinition = new CollectionDisplayViewportDefinition();
        collectionDisplayViewportDefinition.setAlign(() -> {
            if (Validator.isNull((String)align)) {
                return null;
            }
            return CollectionDisplayViewportDefinition.Align.create((String)AlignConverter.convertToExternalValue((String)align));
        });
        collectionDisplayViewportDefinition.setFlexWrap(() -> {
            if (Validator.isNull((String)flexWrap)) {
                return null;
            }
            return CollectionDisplayViewportDefinition.FlexWrap.create((String)FlexWrapConverter.convertToExternalValue((String)flexWrap));
        });
        collectionDisplayViewportDefinition.setHidden(() -> this._toHidden(collectionDisplayViewportConfigurationJSONObject.getJSONObject("styles")));
        collectionDisplayViewportDefinition.setJustify(() -> {
            String justify = collectionDisplayViewportConfigurationJSONObject.getString("justify", null);
            if (Validator.isNull((String)justify)) {
                return null;
            }
            return CollectionDisplayViewportDefinition.Justify.create((String)JustifyConverter.convertToExternalValue((String)justify));
        });
        collectionDisplayViewportDefinition.setNumberOfColumns(() -> {
            if (!collectionDisplayViewportConfigurationJSONObject.has("numberOfColumns")) {
                return null;
            }
            return collectionDisplayViewportConfigurationJSONObject.getInt("numberOfColumns");
        });
        return collectionDisplayViewportDefinition;
    }

    private CollectionDisplayViewport[] _toCollectionDisplayViewports(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        final Map collectionDisplayViewportConfigurationJSONObjects = collectionStyledLayoutStructureItem.getViewportConfigurationJSONObjects();
        if (MapUtil.isEmpty((Map)collectionDisplayViewportConfigurationJSONObjects)) {
            return null;
        }
        ArrayList<CollectionDisplayViewport> collectionDisplayViewports = new ArrayList<CollectionDisplayViewport>(){
            {
                CollectionDisplayViewport collectionDisplayViewport = CollectionDisplayPageElementDefinitionDTOConverter.this._toCollectionDisplayViewport(CollectionDisplayViewport.Id.LANDSCAPE_MOBILE, collectionDisplayViewportConfigurationJSONObjects);
                if (collectionDisplayViewport != null) {
                    this.add(collectionDisplayViewport);
                }
                if ((collectionDisplayViewport = CollectionDisplayPageElementDefinitionDTOConverter.this._toCollectionDisplayViewport(CollectionDisplayViewport.Id.PORTRAIT_MOBILE, collectionDisplayViewportConfigurationJSONObjects)) != null) {
                    this.add(collectionDisplayViewport);
                }
                if ((collectionDisplayViewport = CollectionDisplayPageElementDefinitionDTOConverter.this._toCollectionDisplayViewport(CollectionDisplayViewport.Id.TABLET, collectionDisplayViewportConfigurationJSONObjects)) != null) {
                    this.add(collectionDisplayViewport);
                }
            }
        };
        return collectionDisplayViewports.toArray(new CollectionDisplayViewport[0]);
    }

    private CollectionItemExternalReference _toCollectionItemExternalReference(AssetListEntry assetListEntry, long companyId, JSONObject jsonObject, long scopeGroupId) {
        CollectionItemExternalReference collectionItemExternalReference = new CollectionItemExternalReference();
        if (assetListEntry != null) {
            collectionItemExternalReference.setExternalReferenceCode(() -> ((AssetListEntry)assetListEntry).getExternalReferenceCode());
            collectionItemExternalReference.setScope(() -> ItemScopeUtil.getItemScope(assetListEntry.getGroupId(), scopeGroupId));
            return collectionItemExternalReference;
        }
        String externalReferenceCode = jsonObject.getString("externalReferenceCode");
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        collectionItemExternalReference.setExternalReferenceCode(() -> externalReferenceCode);
        collectionItemExternalReference.setScope(() -> this._getItemScope(companyId, jsonObject.getString("scopeExternalReferenceCode"), scopeGroupId));
        return collectionItemExternalReference;
    }

    private CollectionReference _toCollectionReference(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem, long companyId, long scopeGroupId) {
        JSONObject jsonObject = collectionStyledLayoutStructureItem.getCollectionJSONObject();
        if (jsonObject == null) {
            return null;
        }
        String type = jsonObject.getString("type");
        if (Validator.isNull((String)type)) {
            return null;
        }
        if (Objects.equals(type, InfoListItemSelectorReturnType.class.getName())) {
            return this._toCollectionItemExternalReference(this._assetListEntryLocalService.fetchAssetListEntry(jsonObject.getLong("classPK")), companyId, jsonObject, scopeGroupId);
        }
        String key = jsonObject.getString("key", null);
        if (Validator.isNull((String)key)) {
            return null;
        }
        ClassNameReference classNameReference = new ClassNameReference();
        classNameReference.setClassName(() -> key);
        return classNameReference;
    }

    private CollectionSettings _toCollectionSettings(final CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem, final long companyId, final long scopeGroupId) {
        return new CollectionSettings(){
            {
                this.setCollectionConfig(() -> CollectionDisplayPageElementDefinitionDTOConverter.this._toCollectionConfig(collectionStyledLayoutStructureItem));
                this.setCollectionReference(() -> CollectionDisplayPageElementDefinitionDTOConverter.this._toCollectionReference(collectionStyledLayoutStructureItem, companyId, scopeGroupId));
            }
        };
    }

    private EmptyCollectionConfig _toEmptyCollectionOption(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        final EmptyCollectionOptions emptyCollectionOptions = collectionStyledLayoutStructureItem.getEmptyCollectionOptions();
        if (emptyCollectionOptions == null) {
            return null;
        }
        return new EmptyCollectionConfig(){
            {
                this.setDisplayMessage(() -> ((EmptyCollectionOptions)emptyCollectionOptions).isDisplayMessage());
                this.setMessage_i18n(() -> ((EmptyCollectionOptions)emptyCollectionOptions).getMessage());
            }
        };
    }

    private boolean _toHidden(JSONObject stylesJSONObject) {
        if (JSONUtil.isEmpty((JSONObject)stylesJSONObject)) {
            return false;
        }
        String display = stylesJSONObject.getString("display", null);
        return display != null && StringUtil.equals((String)display, (String)"none");
    }

    private ListStyle _toListStyle(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        ListStyle listStyle = new ListStyle();
        listStyle.setListStyleDefinition(() -> this._toListStyleDefinition(collectionStyledLayoutStructureItem));
        listStyle.setListStyleType(() -> ListStyle.ListStyleType.create((String)CollectionDisplayListStyleUtil.toExternalValue(collectionStyledLayoutStructureItem.getListStyle())));
        return listStyle;
    }

    private ListStyleDefinition _toListStyleDefinition(final CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        return new ListStyleDefinition(){
            {
                this.setAlign(() -> {
                    String align = collectionStyledLayoutStructureItem.getAlign();
                    if (Validator.isNull((String)align)) {
                        return null;
                    }
                    return ListStyleDefinition.Align.create((String)AlignConverter.convertToExternalValue((String)align));
                });
                this.setFlexWrap(() -> {
                    String flexWrap = collectionStyledLayoutStructureItem.getFlexWrap();
                    if (Validator.isNull((String)flexWrap)) {
                        return null;
                    }
                    return ListStyleDefinition.FlexWrap.create((String)FlexWrapConverter.convertToExternalValue((String)flexWrap));
                });
                this.setGutters(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).isGutters());
                this.setJustify(() -> {
                    String justify = collectionStyledLayoutStructureItem.getJustify();
                    if (Validator.isNull((String)justify)) {
                        return null;
                    }
                    return ListStyleDefinition.Justify.create((String)JustifyConverter.convertToExternalValue((String)justify));
                });
                this.setNumberOfColumns(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getNumberOfColumns());
                this.setVerticalAlignment(() -> {
                    String verticalAlignment = collectionStyledLayoutStructureItem.getVerticalAlignment();
                    if (Validator.isNull((String)verticalAlignment)) {
                        return null;
                    }
                    return ListStyleDefinition.VerticalAlignment.create((String)VerticalAlignmentConverter.convertToExternalValue((String)verticalAlignment));
                });
            }
        };
    }

    private TemplateListStyle _toTemplateListStyle(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        TemplateListStyle templateListStyle = new TemplateListStyle();
        templateListStyle.setListItemStyleClassName(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getListItemStyle());
        templateListStyle.setListStyleClassName(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getListStyle());
        templateListStyle.setTemplateKey(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getTemplateKey());
        return templateListStyle;
    }
}

