/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.friendly.url.model.FriendlyURLEntryLocalizationModel;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.friendly.url.util.comparator.FriendlyURLEntryLocalizationComparator;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.FriendlyUrlHistory;
import com.liferay.headless.admin.site.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPage;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseFriendlyUrlHistoryResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.resource.v1_0.FriendlyUrlHistoryResource;
import com.liferay.layout.friendly.url.LayoutFriendlyURLEntryHelper;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.layout.utility.page.service.LayoutUtilityPageEntryService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/friendly-url-history.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={FriendlyUrlHistoryResource.class})
public class FriendlyUrlHistoryResourceImpl
extends BaseFriendlyUrlHistoryResourceImpl {
    private final FriendlyURLEntryLocalizationComparator _friendlyURLEntryLocalizationComparator = FriendlyURLEntryLocalizationComparator.getInstance((boolean)false);
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutFriendlyURLEntryHelper _layoutFriendlyURLEntryHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private LayoutUtilityPageEntryService _layoutUtilityPageEntryService;

    @Override
    @NestedField(parentClass=DisplayPageTemplate.class, value="friendlyUrlHistory")
    public FriendlyUrlHistory getSiteDisplayPageTemplateFriendlyUrlHistory(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String displayPageTemplateExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(displayPageTemplateExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (layoutPageTemplateEntry.getType() != 1) {
            throw new UnsupportedOperationException();
        }
        return this._toFriendlyUrlHistory(this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid()));
    }

    @Override
    @NestedField(parentClass=SitePage.class, value="friendlyUrlHistory")
    public FriendlyUrlHistory getSiteSitePageFriendlyUrlHistory(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutLocalService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (layout.isDraftLayout() || layout.isTypeAssetDisplay() || layout.isTypeUtility()) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid());
        if (layoutPageTemplateEntry != null) {
            throw new UnsupportedOperationException();
        }
        return this._toFriendlyUrlHistory(layout);
    }

    @Override
    @NestedField(parentClass=UtilityPage.class, value="friendlyUrlHistory")
    public FriendlyUrlHistory getSiteUtilityPageFriendlyUrlHistory(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String utilityPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutUtilityPageEntry layoutUtilityPageEntry = this._layoutUtilityPageEntryService.getLayoutUtilityPageEntryByExternalReferenceCode(utilityPageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        return this._toFriendlyUrlHistory(this._layoutLocalService.getLayout(layoutUtilityPageEntry.getPlid()));
    }

    private JSONObject _getFriendlyUrlPathJSONObject(Layout layout) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (!LayoutUtil.isPublished(layout)) {
            return jsonObject;
        }
        long classNameId = this._layoutFriendlyURLEntryHelper.getClassNameId(layout.isPrivateLayout());
        for (String languageId : layout.getAvailableLanguageIds()) {
            JSONArray jsonArray = JSONUtil.toJSONArray((Collection)this._friendlyURLEntryLocalService.getFriendlyURLEntryLocalizations(layout.getGroupId(), classNameId, layout.getPlid(), languageId, -1, -1, (OrderByComparator)this._friendlyURLEntryLocalizationComparator), FriendlyURLEntryLocalizationModel::getUrlTitle);
            if (jsonArray.length() == 0) continue;
            jsonObject.put(LocaleUtil.toBCP47LanguageId((String)languageId), jsonArray);
        }
        return jsonObject;
    }

    private FriendlyUrlHistory _toFriendlyUrlHistory(final Layout layout) throws Exception {
        return new FriendlyUrlHistory(){
            {
                this.setFriendlyUrlPath_i18n(() -> FriendlyUrlHistoryResourceImpl.this._getFriendlyUrlPathJSONObject(layout));
            }
        };
    }
}

