/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.MasterPage;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.AssetUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ThumbnailUtil;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry"}, service={DTOConverter.class})
public class MasterPageDTOConverter
implements DTOConverter<LayoutPageTemplateEntry, MasterPage> {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return MasterPage.class.getSimpleName();
    }

    public MasterPage toDTO(DTOConverterContext dtoConverterContext, final LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        final Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        return new MasterPage(){
            {
                this.setCreator(() -> {
                    final User user = MasterPageDTOConverter.this._userLocalService.fetchUser(layoutPageTemplateEntry.getUserId());
                    if (user == null) {
                        return null;
                    }
                    return new Creator(){
                        {
                            this.setExternalReferenceCode(() -> ((User)user).getExternalReferenceCode());
                        }
                    };
                });
                this.setDateCreated(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getCreateDate());
                this.setDateModified(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setExternalReferenceCode(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getExternalReferenceCode());
                this.setKey(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getLayoutPageTemplateEntryKey());
                this.setKeywords(() -> AssetUtil.getKeywords(Layout.class.getName(), layoutPageTemplateEntry.getPlid()));
                this.setMarkedAsDefault(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).isDefaultTemplate());
                this.setName(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getName());
                this.setTaxonomyCategoryItemExternalReferences(() -> AssetUtil.getTaxonomyCategoryItemExternalReferences(Layout.class.getName(), layoutPageTemplateEntry.getPlid(), layoutPageTemplateEntry.getGroupId()));
                this.setThumbnail(() -> ThumbnailUtil.getPortletFileEntryItemExternalReference(layoutPageTemplateEntry.getPreviewFileEntryId()));
                this.setUuid(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getUuid());
            }
        };
    }
}

