/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.PageSettings;
import com.liferay.headless.admin.site.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSettings;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"dto.class.name=com.liferay.portal.kernel.model.Layout"}, service={DTOConverter.class})
public class SitePageDTOConverter
implements DTOConverter<Layout, SitePage> {
    public String getContentType() {
        return SitePage.class.getSimpleName();
    }

    public SitePage toDTO(DTOConverterContext dtoConverterContext, final Layout layout) throws Exception {
        return new SitePage(){
            {
                this.setAvailableLanguages(() -> LocaleUtil.toW3cLanguageIds((String[])layout.getAvailableLanguageIds()));
                this.setDateCreated(() -> ((Layout)layout).getCreateDate());
                this.setDateModified(() -> ((Layout)layout).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setExternalReferenceCode(() -> ((Layout)layout).getExternalReferenceCode());
                this.setFriendlyUrlPath_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getFriendlyURLMap()));
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getNameMap()));
                this.setPageSettings(() -> SitePageDTOConverter.this._toPageSettings(layout));
                this.setSiteExternalReferenceCode(() -> {
                    Group group = layout.getGroup();
                    return group.getExternalReferenceCode();
                });
                this.setType(() -> SitePageDTOConverter.this._toType(layout));
                this.setUuid(() -> ((Layout)layout).getUuid());
            }
        };
    }

    private PageSettings _toPageSettings(Layout layout) {
        WidgetPageSettings pageSettings = null;
        SitePage.Type type = this._toType(layout);
        if (type != SitePage.Type.WIDGET_PAGE) {
            return null;
        }
        pageSettings = this._toWidgetPageSettings(layout);
        pageSettings.setHiddenFromNavigation(() -> ((Layout)layout).isHidden());
        return pageSettings;
    }

    private SitePage.Type _toType(Layout layout) {
        String type = layout.getType();
        if (type == null || type.isEmpty()) {
            return null;
        }
        if (type.equals("portlet")) {
            return SitePage.Type.WIDGET_PAGE;
        }
        return null;
    }

    private WidgetPageSettings _toWidgetPageSettings(final Layout layout) {
        return new WidgetPageSettings(){
            {
                this.setLayoutTemplateId(() -> layout.getTypeSettingsProperty("layout-template-id"));
                this.setType(PageSettings.Type.WIDGET_PAGE_SETTINGS);
            }
        };
    }
}

