/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPage;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPageSEOSettings;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPageSettings;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseUtilityPageResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.FileEntryUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.resource.v1_0.UtilityPageResource;
import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.layout.utility.page.service.LayoutUtilityPageEntryService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/utility-page.properties"}, scope=ServiceScope.PROTOTYPE, service={UtilityPageResource.class})
public class UtilityPageResourceImpl
extends BaseUtilityPageResourceImpl {
    private static final Map<UtilityPage.Type, String> _externalToInternalValuesMap = HashMapBuilder.put((Object)UtilityPage.Type.COOKIE_POLICY, (Object)"COOKIE_POLICY").put((Object)UtilityPage.Type.CREATE_ACCOUNT, (Object)"CREATE_ACCOUNT").put((Object)UtilityPage.Type.ERROR, (Object)"STATUS").put((Object)UtilityPage.Type.ERROR_CODE404, (Object)"SC_NOT_FOUND").put((Object)UtilityPage.Type.ERROR_CODE500, (Object)"SC_INTERNAL_SERVER_ERROR").put((Object)UtilityPage.Type.FORGOT_PASSWORD, (Object)"FORGOT_PASSWORD").put((Object)UtilityPage.Type.LOGIN, (Object)"LOGIN").put((Object)UtilityPage.Type.TERMS_OF_USE, (Object)"TERMS_OF_USE").build();
    @Reference
    private CETManager _cetManager;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutUtilityPageEntryService _layoutUtilityPageEntryService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;
    @Reference
    private Portal _portal;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.UtilityPageDTOConverter)")
    private DTOConverter<LayoutUtilityPageEntry, UtilityPage> _utilityPageDTOConverter;

    @Override
    public void deleteSiteSiteByExternalReferenceCodeUtilityPage(String siteExternalReferenceCode, String utilityPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        this._layoutUtilityPageEntryService.deleteLayoutUtilityPageEntry(utilityPageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
    }

    @Override
    public UtilityPage getSiteSiteByExternalReferenceCodeUtilityPage(String siteExternalReferenceCode, String utilityPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return (UtilityPage)this._utilityPageDTOConverter.toDTO((Object)this._layoutUtilityPageEntryService.getLayoutUtilityPageEntryByExternalReferenceCode(utilityPageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode)));
    }

    @Override
    public Page<UtilityPage> getSiteSiteByExternalReferenceCodeUtilityPagesPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        return Page.of(this.transform(this._layoutUtilityPageEntryService.getLayoutUtilityPageEntries(groupId, pagination.getStartPosition(), pagination.getEndPosition(), null), layoutUtilityPageEntry -> (UtilityPage)this._utilityPageDTOConverter.toDTO(layoutUtilityPageEntry)), (Pagination)pagination, (long)this._layoutUtilityPageEntryService.getLayoutUtilityPageEntriesCount(groupId));
    }

    @Override
    public UtilityPage postSiteSiteByExternalReferenceCodeUtilityPage(String siteExternalReferenceCode, UtilityPage utilityPage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._addLayoutUtilityPageEntry(GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode), utilityPage);
    }

    @Override
    public ContentPageSpecification postSiteSiteByExternalReferenceCodeUtilityPagePageSpecification(String siteExternalReferenceCode, String utilityPageExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutUtilityPageEntry layoutUtilityPageEntry = this._layoutUtilityPageEntryService.getLayoutUtilityPageEntryByExternalReferenceCode(utilityPageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        return (ContentPageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.addDraftToLayout(this._cetManager, contentPageSpecification, this._layoutLocalService.getLayout(layoutUtilityPageEntry.getPlid()), ServiceContextUtil.createServiceContext(layoutUtilityPageEntry.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    @Override
    public UtilityPage putSiteSiteByExternalReferenceCodeUtilityPage(String siteExternalReferenceCode, String utilityPageExternalReferenceCode, UtilityPage utilityPage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutUtilityPageEntry layoutUtilityPageEntry = this._layoutUtilityPageEntryService.fetchLayoutUtilityPageEntryByExternalReferenceCode(utilityPageExternalReferenceCode, groupId);
        if (layoutUtilityPageEntry == null) {
            return this._addLayoutUtilityPageEntry(groupId, utilityPage);
        }
        this._validateUtilityPage(utilityPage);
        Layout layout = this._layoutLocalService.getLayout(layoutUtilityPageEntry.getPlid());
        Map titleMap = Collections.singletonMap(this._portal.getSiteDefaultLocale(groupId), utilityPage.getName());
        Map descriptionMap = Collections.emptyMap();
        UtilityPageSettings utilityPageSettings = utilityPage.getUtilityPageSettings();
        if (utilityPageSettings != null && utilityPageSettings.getSeoSettings() != null) {
            UtilityPageSEOSettings utilityPageSEOSettings = utilityPageSettings.getSeoSettings();
            titleMap = LocalizedMapUtil.getLocalizedMap((Map)utilityPageSEOSettings.getHtmlTitle_i18n());
            descriptionMap = LocalizedMapUtil.getLocalizedMap((Map)utilityPageSEOSettings.getDescription_i18n());
        }
        LayoutUtil.updateContentLayout(this._cetManager, layout, layout.getNameMap(), titleMap, descriptionMap, layout.getRobotsMap(), LocalizedMapUtil.getLocalizedMap((Map)utilityPage.getFriendlyUrlPath_i18n()), utilityPage.getPageSpecifications(), this._getServiceContext(groupId, utilityPage));
        if (GetterUtil.getBoolean((Object)utilityPage.getMarkedAsDefault()) && !layoutUtilityPageEntry.isDefaultLayoutUtilityPageEntry()) {
            layoutUtilityPageEntry = this._layoutUtilityPageEntryService.setDefaultLayoutUtilityPageEntry(layoutUtilityPageEntry.getLayoutUtilityPageEntryId());
        } else if (!GetterUtil.getBoolean((Object)utilityPage.getMarkedAsDefault()) && layoutUtilityPageEntry.isDefaultLayoutUtilityPageEntry()) {
            layoutUtilityPageEntry = this._layoutUtilityPageEntryService.unsetDefaultLayoutUtilityPageEntry(layoutUtilityPageEntry.getLayoutUtilityPageEntryId());
        }
        long previewFileEntryId = FileEntryUtil.getPreviewFileEntryId(groupId, utilityPage.getThumbnail());
        if (previewFileEntryId != layoutUtilityPageEntry.getPreviewFileEntryId()) {
            layoutUtilityPageEntry = this._layoutUtilityPageEntryService.updateLayoutUtilityPageEntry(layoutUtilityPageEntry.getLayoutUtilityPageEntryId(), previewFileEntryId);
        }
        return (UtilityPage)this._utilityPageDTOConverter.toDTO((Object)this._layoutUtilityPageEntryService.updateLayoutUtilityPageEntry(layoutUtilityPageEntry.getLayoutUtilityPageEntryId(), utilityPage.getName()));
    }

    @Override
    protected void preparePatch(UtilityPage utilityPage, UtilityPage existingUtilityPage) {
        if (utilityPage.getPageSpecifications() != null) {
            existingUtilityPage.setPageSpecifications(() -> ((UtilityPage)utilityPage).getPageSpecifications());
        }
        if (utilityPage.getThumbnail() != null) {
            existingUtilityPage.setThumbnail(() -> ((UtilityPage)utilityPage).getThumbnail());
        }
        if (utilityPage.getUtilityPageSettings() != null) {
            existingUtilityPage.setUtilityPageSettings(() -> ((UtilityPage)utilityPage).getUtilityPageSettings());
        }
    }

    private UtilityPage _addLayoutUtilityPageEntry(long groupId, UtilityPage utilityPage) throws Exception {
        ServiceContext serviceContext = this._getServiceContext(groupId, utilityPage);
        return (UtilityPage)this._utilityPageDTOConverter.toDTO((Object)this._layoutUtilityPageEntryService.addLayoutUtilityPageEntry(utilityPage.getExternalReferenceCode(), groupId, this._getLayoutPlid(groupId, utilityPage, serviceContext), FileEntryUtil.getPreviewFileEntryId(groupId, utilityPage.getThumbnail()), utilityPage.getMarkedAsDefault().booleanValue(), utilityPage.getName(), this._getType(utilityPage.getType()), 0L, serviceContext));
    }

    private long _getLayoutPlid(long groupId, UtilityPage utilityPage, ServiceContext serviceContext) throws Exception {
        Map nameMap;
        this._validateUtilityPage(utilityPage);
        Map titleMap = nameMap = Collections.singletonMap(this._portal.getSiteDefaultLocale(groupId), utilityPage.getName());
        Map descriptionMap = Collections.emptyMap();
        UtilityPageSettings utilityPageSettings = utilityPage.getUtilityPageSettings();
        if (utilityPageSettings != null && utilityPageSettings.getSeoSettings() != null) {
            UtilityPageSEOSettings utilityPageSEOSettings = utilityPageSettings.getSeoSettings();
            titleMap = LocalizedMapUtil.getLocalizedMap((Map)utilityPageSEOSettings.getHtmlTitle_i18n());
            descriptionMap = LocalizedMapUtil.getLocalizedMap((Map)utilityPageSEOSettings.getDescription_i18n());
        }
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        Layout layout = LayoutUtil.addContentLayout(this._cetManager, groupId, utilityPage.getPageSpecifications(), false, nameMap, titleMap, descriptionMap, null, "utility", null, true, true, LocalizedMapUtil.getLocalizedMap((Map)utilityPage.getFriendlyUrlPath_i18n()), 2, serviceContext);
        return layout.getPlid();
    }

    private ServiceContext _getServiceContext(long groupId, UtilityPage utilityPage) {
        ServiceContext serviceContext = ServiceContextUtil.createServiceContext(groupId, this.contextHttpServletRequest, this.contextUser.getUserId());
        serviceContext.setCreateDate(utilityPage.getDateCreated());
        serviceContext.setModifiedDate(utilityPage.getDateModified());
        serviceContext.setUuid(utilityPage.getUuid());
        return serviceContext;
    }

    private String _getType(UtilityPage.Type type) {
        if (_externalToInternalValuesMap.containsKey(type)) {
            return _externalToInternalValuesMap.get(type);
        }
        throw new UnsupportedOperationException();
    }

    private void _validateUtilityPage(UtilityPage utilityPage) {
        if (ArrayUtil.isEmpty((Object[])utilityPage.getPageSpecifications())) {
            return;
        }
        for (PageSpecification pageSpecification : utilityPage.getPageSpecifications()) {
            if (pageSpecification.getCustomFields() == null) continue;
            throw new UnsupportedOperationException();
        }
    }
}

