/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.util;

import com.liferay.client.extension.service.ClientExtensionEntryRelLocalServiceUtil;
import com.liferay.client.extension.type.CET;
import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.ClientExtension;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.FavIcon;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageExperience;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.headless.admin.site.dto.v1_0.Settings;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSpecification;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.SegmentsExperienceUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.custom.field.CustomField;
import com.liferay.portal.vulcan.custom.field.CustomFieldsUtil;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceServiceUtil;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryServiceUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class LayoutUtil {
    public static Layout addContentLayout(CETManager cetManager, long groupId, PageSpecification[] pageSpecifications, boolean privateLayout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> robotsMap, String type, UnicodeProperties typeSettingsUnicodeProperties, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, int status, ServiceContext serviceContext) throws Exception {
        if (typeSettingsUnicodeProperties == null) {
            typeSettingsUnicodeProperties = new UnicodeProperties();
        }
        if (pageSpecifications == null) {
            Layout layout = LayoutLocalServiceUtil.addLayout((String)GetterUtil.getString((Object)serviceContext.getAttribute("layoutExternalReferenceCode"), null), (long)serviceContext.getUserId(), (long)groupId, (boolean)privateLayout, (long)0L, (long)0L, (long)0L, nameMap, titleMap, descriptionMap, null, robotsMap, (String)type, (String)typeSettingsUnicodeProperties.toString(), (boolean)hidden, (boolean)system, friendlyURLMap, (long)0L, (ServiceContext)serviceContext);
            return LayoutLocalServiceUtil.updateStatus((long)serviceContext.getUserId(), (long)layout.getPlid(), (int)status, (ServiceContext)serviceContext);
        }
        if (pageSpecifications.length != 2) {
            throw new UnsupportedOperationException();
        }
        ContentPageSpecification draftContentPageSpecification = null;
        ContentPageSpecification publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[0];
        if (Validator.isNull((String)publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode())) {
            draftContentPageSpecification = publishedContentPageSpecification;
            publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        } else {
            draftContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        }
        if (Validator.isNull((String)publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode()) || !Objects.equals(draftContentPageSpecification.getExternalReferenceCode(), publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode())) {
            throw new UnsupportedOperationException();
        }
        Settings settings = publishedContentPageSpecification.getSettings();
        if (settings == null || Validator.isNull((Object)settings.getMasterPageItemExternalReference())) {
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-footer", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header-search", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:wrap-widget-page-content", Boolean.FALSE.toString());
        }
        long masterLayoutPlid = 0L;
        if (settings != null && settings.getMasterPageItemExternalReference() != null) {
            if (Objects.equals(3, serviceContext.getAttribute("layout.page.template.entry.type"))) {
                throw new UnsupportedOperationException();
            }
            ItemExternalReference itemExternalReference = settings.getMasterPageItemExternalReference();
            if (Validator.isNotNull((String)itemExternalReference.getExternalReferenceCode())) {
                if (itemExternalReference.getScope() != null) {
                    throw new UnsupportedOperationException();
                }
                Layout masterLayout = LayoutLocalServiceUtil.fetchLayoutByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)groupId);
                if (masterLayout == null) {
                    throw new UnsupportedOperationException();
                }
                masterLayoutPlid = masterLayout.getPlid();
            }
        }
        serviceContext.setAttribute("defaultSegmentsExperienceExternalReferenceCode", (Serializable)((Object)SegmentsExperienceUtil.getDefaultSegmentsExperienceExternalReferenceCode(publishedContentPageSpecification.getPageExperiences())));
        serviceContext.setAttribute("draftLayoutDefaultSegmentsExperienceExternalReferenceCode", (Serializable)((Object)SegmentsExperienceUtil.getDefaultSegmentsExperienceExternalReferenceCode(draftContentPageSpecification.getPageExperiences())));
        serviceContext.setAttribute("draftLayoutExternalReferenceCode", (Serializable)((Object)draftContentPageSpecification.getExternalReferenceCode()));
        Layout prototypeLayout = LayoutUtil.getLayoutPrototypeLayout(groupId, (PageSpecification)publishedContentPageSpecification, serviceContext);
        if (prototypeLayout != null) {
            serviceContext.setAttribute("layoutSetPrototypeLayoutERC", (Serializable)((Object)prototypeLayout.getExternalReferenceCode()));
            Layout draftPrototypeLayout = LayoutUtil.getLayoutPrototypeLayout(groupId, (PageSpecification)draftContentPageSpecification, serviceContext);
            if (draftPrototypeLayout != null) {
                serviceContext.setAttribute("draftLayoutLayoutSetPrototypeLayoutERC", (Serializable)((Object)draftPrototypeLayout.getExternalReferenceCode()));
            }
        }
        if (Objects.equals(publishedContentPageSpecification.getStatus(), PageSpecification.Status.APPROVED)) {
            serviceContext.setAttribute("published", (Serializable)((Object)Boolean.TRUE.toString()));
            typeSettingsUnicodeProperties.setProperty("published", Boolean.TRUE.toString());
        } else {
            serviceContext.setAttribute("published", (Serializable)((Object)Boolean.FALSE.toString()));
        }
        Layout layout = LayoutLocalServiceUtil.addLayout((String)publishedContentPageSpecification.getExternalReferenceCode(), (long)serviceContext.getUserId(), (long)groupId, (boolean)privateLayout, (long)0L, (long)0L, (long)0L, nameMap, titleMap, descriptionMap, null, robotsMap, (String)type, (String)typeSettingsUnicodeProperties.toString(), (boolean)hidden, (boolean)system, friendlyURLMap, (long)masterLayoutPlid, (ServiceContext)serviceContext);
        Layout draftLayout = layout.fetchDraftLayout();
        int draftLayoutStatus = 0;
        if (Objects.equals(draftContentPageSpecification.getStatus(), PageSpecification.Status.DRAFT)) {
            draftLayoutStatus = 2;
        }
        LayoutUtil.updateLayout(cetManager, draftContentPageSpecification, draftLayout, nameMap, titleMap, descriptionMap, draftLayout.getRobotsMap(), draftLayout.getFriendlyURLMap(), draftLayoutStatus, serviceContext);
        return LayoutUtil.updateLayout(cetManager, publishedContentPageSpecification, layout, nameMap, titleMap, descriptionMap, robotsMap, friendlyURLMap, status, serviceContext);
    }

    public static Layout addDraftToLayout(CETManager cetManager, ContentPageSpecification contentPageSpecification, Layout layout, ServiceContext serviceContext) throws Exception {
        if (Validator.isNotNull((Object)contentPageSpecification.getStatus()) && !Objects.equals(contentPageSpecification.getStatus(), PageSpecification.Status.DRAFT) || layout.isDraftLayout()) {
            throw new UnsupportedOperationException();
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (Validator.isNotNull((String)contentPageSpecification.getExternalReferenceCode()) && !Objects.equals(contentPageSpecification.getExternalReferenceCode(), draftLayout.getExternalReferenceCode()) || !Objects.equals(draftLayout.getStatus(), 0)) {
            throw new UnsupportedOperationException();
        }
        return LayoutUtil.updateLayout(cetManager, contentPageSpecification, draftLayout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), draftLayout.getRobotsMap(), draftLayout.getFriendlyURLMap(), 2, serviceContext);
    }

    public static Layout addPortletLayout(String externalReferenceCode, long groupId, long parentLayoutId, Map<Locale, String> nameMap, UnicodeProperties typeSettingsUnicodeProperties, boolean hiddenFromNavigation, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext, WidgetPageSpecification widgetPageSpecification) throws Exception {
        String typeSettings = null;
        if (typeSettingsUnicodeProperties != null) {
            typeSettings = typeSettingsUnicodeProperties.toString();
        }
        LayoutUtil._setExpandoBridgeAttributes((PageSpecification)widgetPageSpecification, serviceContext);
        return LayoutServiceUtil.addLayout((String)externalReferenceCode, (long)groupId, (boolean)false, (long)parentLayoutId, nameMap, null, null, null, null, (String)"portlet", (String)typeSettings, (boolean)hiddenFromNavigation, friendlyURLMap, (long)0L, (ServiceContext)serviceContext);
    }

    public static Layout getLayoutPrototypeLayout(long groupId, PageSpecification pageSpecification, ServiceContext serviceContext) throws Exception {
        ContentPageSpecification contentPageSpecification;
        if (Validator.isNull((String)pageSpecification.getSiteTemplatePageSpecificationExternalReferenceCode())) {
            return null;
        }
        boolean privateLayout = Boolean.FALSE;
        int layoutPageTemplateEntryType = GetterUtil.getInteger((Object)serviceContext.getAttribute("layout.page.template.entry.type"), (int)-1);
        if (Objects.equals(0, layoutPageTemplateEntryType) || Objects.equals(3, layoutPageTemplateEntryType) || Objects.equals(2, layoutPageTemplateEntryType)) {
            privateLayout = Boolean.TRUE;
        } else if (Objects.equals(PageSpecification.Type.CONTENT_PAGE_SPECIFICATION, pageSpecification.getType()) && Validator.isNull((String)(contentPageSpecification = (ContentPageSpecification)pageSpecification).getDraftContentPageSpecificationExternalReferenceCode())) {
            privateLayout = Boolean.TRUE;
        }
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        if (!layoutSet.isLayoutSetPrototypeLinkActive()) {
            return null;
        }
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSet.getLayoutSetPrototypeUuid(), (long)layoutSet.getCompanyId());
        return LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)pageSpecification.getSiteTemplatePageSpecificationExternalReferenceCode(), (long)layoutSetPrototype.getGroupId(), (boolean)privateLayout);
    }

    public static boolean isPublished(Layout layout) {
        if (!layout.isTypeAssetDisplay() && !layout.isTypeContent()) {
            return true;
        }
        if (layout.isDraftLayout()) {
            return GetterUtil.getBoolean((String)layout.getTypeSettingsProperty("published"));
        }
        Layout draftLayout = layout.fetchDraftLayout();
        return GetterUtil.getBoolean((String)draftLayout.getTypeSettingsProperty("published"));
    }

    public static Layout updateContentLayout(CETManager cetManager, Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> robotsMap, Map<Locale, String> friendlyURLMap, PageSpecification[] pageSpecifications, ServiceContext serviceContext) throws Exception {
        if (pageSpecifications == null) {
            return LayoutUtil._updateLayout(layout, nameMap, titleMap, descriptionMap, robotsMap, layout.getStyleBookEntryId(), layout.getFaviconFileEntryId(), layout.getMasterLayoutPlid(), friendlyURLMap, serviceContext);
        }
        if (pageSpecifications.length != 2) {
            throw new UnsupportedOperationException();
        }
        ContentPageSpecification draftContentPageSpecification = null;
        ContentPageSpecification publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[0];
        if (Objects.equals(layout.getExternalReferenceCode(), publishedContentPageSpecification.getExternalReferenceCode())) {
            draftContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        } else {
            draftContentPageSpecification = publishedContentPageSpecification;
            publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (!(Objects.equals(draftLayout.getExternalReferenceCode(), draftContentPageSpecification.getExternalReferenceCode()) && Objects.equals(layout.getExternalReferenceCode(), publishedContentPageSpecification.getExternalReferenceCode()) && Objects.equals(publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode(), draftContentPageSpecification.getExternalReferenceCode()))) {
            throw new UnsupportedOperationException();
        }
        int draftLayoutStatus = 0;
        if (Objects.equals(draftContentPageSpecification.getStatus(), PageSpecification.Status.DRAFT)) {
            draftLayoutStatus = 2;
        }
        int status = layout.getStatus();
        if (Objects.equals(publishedContentPageSpecification.getStatus(), PageSpecification.Status.APPROVED)) {
            serviceContext.setAttribute("published", (Serializable)((Object)Boolean.TRUE.toString()));
            status = 0;
        }
        LayoutUtil.updateLayout(cetManager, draftContentPageSpecification, draftLayout, nameMap, titleMap, descriptionMap, robotsMap, draftLayout.getFriendlyURLMap(), draftLayoutStatus, serviceContext);
        return LayoutUtil.updateLayout(cetManager, publishedContentPageSpecification, layout, nameMap, titleMap, descriptionMap, robotsMap, friendlyURLMap, status, serviceContext);
    }

    public static Layout updateContentLayout(CETManager cetManager, Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> robotsMap, Map<Locale, String> friendlyURLMap, PageSpecification[] pageSpecifications, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws Exception {
        layout = LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)typeSettingsUnicodeProperties.toString());
        return LayoutUtil.updateContentLayout(cetManager, layout, nameMap, titleMap, descriptionMap, robotsMap, friendlyURLMap, pageSpecifications, serviceContext);
    }

    public static Layout updateLayout(CETManager cetManager, ContentPageSpecification contentPageSpecification, Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> robotsMap, Map<Locale, String> friendlyURLMap, int status, ServiceContext serviceContext) throws Exception {
        LayoutUtil.updateLayout(cetManager, layout, nameMap, titleMap, descriptionMap, robotsMap, friendlyURLMap, (PageSpecification)contentPageSpecification, serviceContext);
        LayoutUtil._updatePageExperiences(layout, contentPageSpecification.getPageExperiences(), serviceContext);
        return LayoutLocalServiceUtil.updateStatus((long)serviceContext.getUserId(), (long)layout.getPlid(), (int)status, (ServiceContext)serviceContext);
    }

    public static Layout updateLayout(CETManager cetManager, Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> robotsMap, Map<Locale, String> friendlyURLMap, PageSpecification pageSpecification, ServiceContext serviceContext) throws Exception {
        Settings settings = null;
        if (pageSpecification != null) {
            settings = pageSpecification.getSettings();
        }
        LayoutUtil._updateClientExtensions(cetManager, layout, settings, serviceContext);
        layout = LayoutUtil._updateLookAndFeel(layout, settings);
        LayoutUtil._setExpandoBridgeAttributes(pageSpecification, serviceContext);
        return LayoutUtil._updateLayout(layout, nameMap, titleMap, descriptionMap, robotsMap, LayoutUtil._getStyleBookEntryId(serviceContext.getScopeGroupId(), settings), LayoutUtil._getFaviconFileEntryId(settings, serviceContext), LayoutUtil._getMasterLayoutPlid(serviceContext.getScopeGroupId(), layout, settings), friendlyURLMap, serviceContext);
    }

    public static Layout updatePortletLayout(CETManager cetManager, Layout layout, Map<Locale, String> nameMap, Map<Locale, String> friendlyURLMap, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext, WidgetPageSpecification widgetPageSpecification) throws Exception {
        layout = LayoutUtil.updateLayout(cetManager, layout, nameMap, layout.getTitleMap(), layout.getDescriptionMap(), layout.getRobotsMap(), friendlyURLMap, (PageSpecification)widgetPageSpecification, serviceContext);
        if (typeSettingsUnicodeProperties == null) {
            return layout;
        }
        UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        unicodeProperties.putAll((Map)typeSettingsUnicodeProperties);
        return LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)typeSettingsUnicodeProperties.toString());
    }

    private static long _getFaviconFileEntryId(Settings settings, ServiceContext serviceContext) throws Exception {
        DLFileEntry dlFileEntry;
        if (settings == null || settings.getFavIcon() == null) {
            return 0L;
        }
        FavIcon favIcon = settings.getFavIcon();
        if (!Objects.equals(favIcon.getClassName(), FileEntry.class.getName()) || Validator.isNull((String)favIcon.getExternalReferenceCode())) {
            return 0L;
        }
        long groupId = serviceContext.getScopeGroupId();
        Scope scope = favIcon.getScope();
        if (scope != null) {
            groupId = GroupUtil.getGroupId(true, true, serviceContext.getCompanyId(), scope.getExternalReferenceCode());
        }
        if ((dlFileEntry = DLFileEntryServiceUtil.fetchFileEntryByExternalReferenceCode((long)groupId, (String)favIcon.getExternalReferenceCode())) == null) {
            throw new UnsupportedOperationException();
        }
        return dlFileEntry.getFileEntryId();
    }

    private static long _getMasterLayoutPlid(long groupId, Layout layout, Settings settings) throws Exception {
        if (settings == null) {
            return 0L;
        }
        ItemExternalReference itemExternalReference = settings.getMasterPageItemExternalReference();
        if (itemExternalReference == null || Validator.isNull((String)itemExternalReference.getExternalReferenceCode())) {
            return 0L;
        }
        if (itemExternalReference.getScope() != null) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByPlid((long)layout.getPlid());
        if (layoutPageTemplateEntry != null && Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        layoutPageTemplateEntry = LayoutPageTemplateEntryServiceUtil.fetchLayoutPageTemplateEntryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)groupId);
        if (layoutPageTemplateEntry == null || !Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return layoutPageTemplateEntry.getPlid();
    }

    private static long _getStyleBookEntryId(long groupId, Settings settings) throws Exception {
        if (settings == null) {
            return 0L;
        }
        ItemExternalReference itemExternalReference = settings.getStyleBookItemExternalReference();
        if (itemExternalReference == null || Validator.isNull((String)itemExternalReference.getExternalReferenceCode())) {
            return 0L;
        }
        StyleBookEntry styleBookEntry = StyleBookEntryServiceUtil.getStyleBookEntryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)groupId);
        return styleBookEntry.getStyleBookEntryId();
    }

    private static void _setExpandoBridgeAttributes(PageSpecification pageSpecification, ServiceContext serviceContext) {
        if (pageSpecification == null) {
            serviceContext.setExpandoBridgeAttributes(null);
        } else {
            serviceContext.setExpandoBridgeAttributes(CustomFieldsUtil.toMap((String)Layout.class.getName(), (long)serviceContext.getCompanyId(), (CustomField[])pageSpecification.getCustomFields(), null));
        }
    }

    private static void _updateClientExtensionEntryRel(CETManager cetManager, long classNameId, ClientExtension clientExtension, Layout layout, String type, ServiceContext serviceContext) throws Exception {
        ClientExtension[] clientExtensions = null;
        if (clientExtension != null) {
            clientExtensions = new ClientExtension[]{clientExtension};
        }
        LayoutUtil._updateClientExtensionEntryRels(cetManager, classNameId, clientExtensions, layout, type, serviceContext);
    }

    private static void _updateClientExtensionEntryRels(CETManager cetManager, long classNameId, ClientExtension[] clientExtensions, Layout layout, String type, ServiceContext serviceContext) throws Exception {
        ClientExtensionEntryRelLocalServiceUtil.deleteClientExtensionEntryRels((long)classNameId, (long)layout.getPlid(), (String)type);
        if (ArrayUtil.isEmpty((Object[])clientExtensions)) {
            return;
        }
        for (ClientExtension clientExtension : clientExtensions) {
            CET cet = cetManager.getCET(layout.getCompanyId(), clientExtension.getExternalReferenceCode());
            if (cet == null) {
                throw new UnsupportedOperationException();
            }
            ClientExtensionEntryRelLocalServiceUtil.addClientExtensionEntryRel((long)serviceContext.getUserId(), (long)layout.getGroupId(), (long)classNameId, (long)layout.getPlid(), (String)clientExtension.getExternalReferenceCode(), (String)type, (String)UnicodePropertiesBuilder.create((Map)clientExtension.getClientExtensionConfig(), (boolean)true).buildString(), (ServiceContext)serviceContext);
        }
    }

    private static void _updateClientExtensions(CETManager cetManager, Layout layout, Settings settings, ServiceContext serviceContext) throws Exception {
        if (settings == null) {
            ClientExtensionEntryRelLocalServiceUtil.deleteClientExtensionEntryRels((long)PortalUtil.getClassNameId(Layout.class), (long)layout.getPlid());
            return;
        }
        if (layout.isTypeUtility()) {
            if (Validator.isNotNull((Object)settings.getFavIcon()) || ArrayUtil.isNotEmpty((Object[])settings.getGlobalCSSClientExtensions()) || ArrayUtil.isNotEmpty((Object[])settings.getGlobalJSClientExtensions()) || Validator.isNotNull((Object)settings.getThemeCSSClientExtension()) || Validator.isNotNull((Object)settings.getThemeSpritemapClientExtension())) {
                throw new UnsupportedOperationException();
            }
            return;
        }
        long classNameId = PortalUtil.getClassNameId(Layout.class);
        ClientExtension clientExtension = null;
        final FavIcon favIcon = settings.getFavIcon();
        if (favIcon != null && Objects.equals(favIcon.getClassName(), ClientExtension.class.getName())) {
            clientExtension = new ClientExtension(){
                {
                    this.setClientExtensionConfig(() -> ((FavIcon)favIcon).getClientExtensionConfig());
                    this.setExternalReferenceCode(() -> ((FavIcon)favIcon).getExternalReferenceCode());
                }
            };
        }
        LayoutUtil._updateClientExtensionEntryRels(cetManager, classNameId, settings.getGlobalCSSClientExtensions(), layout, "globalCSS", serviceContext);
        LayoutUtil._updateClientExtensionEntryRels(cetManager, classNameId, settings.getGlobalJSClientExtensions(), layout, "globalJS", serviceContext);
        LayoutUtil._updateClientExtensionEntryRel(cetManager, classNameId, settings.getThemeCSSClientExtension(), layout, "themeCSS", serviceContext);
        LayoutUtil._updateClientExtensionEntryRel(cetManager, classNameId, clientExtension, layout, "themeFavicon", serviceContext);
        LayoutUtil._updateClientExtensionEntryRel(cetManager, classNameId, settings.getThemeSpritemapClientExtension(), layout, "themeSpritemap", serviceContext);
    }

    private static Layout _updateLayout(Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> robotsMap, long styleBookEntryId, long faviconFileEntryId, long masterLayoutPlid, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws Exception {
        if (layout.isTypeAssetDisplay() || layout.isTypeUtility()) {
            serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        }
        return LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (long)GetterUtil.getLong((Object)serviceContext.getAttribute("parentLayoutId"), (long)layout.getParentLayoutId()), nameMap, titleMap, descriptionMap, (Map)layout.getKeywordsMap(), robotsMap, (String)layout.getType(), (boolean)GetterUtil.getBoolean((Object)serviceContext.getAttribute("hidden"), (boolean)layout.isHidden()), friendlyURLMap, (boolean)layout.getIconImage(), null, (long)styleBookEntryId, (long)faviconFileEntryId, (long)masterLayoutPlid, (ServiceContext)serviceContext);
    }

    private static Layout _updateLookAndFeel(Layout layout, Settings settings) throws Exception {
        UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        if (settings != null) {
            unicodeProperties.setProperty("javascript", settings.getJavascript());
        } else {
            unicodeProperties.remove((Object)"javascript");
        }
        for (String key : ListUtil.fromCollection((Collection)unicodeProperties.keySet())) {
            if (!key.startsWith("lfr-theme:")) continue;
            unicodeProperties.remove((Object)key);
        }
        if (settings != null && MapUtil.isNotEmpty((Map)settings.getThemeSettings())) {
            unicodeProperties.putAll(settings.getThemeSettings());
        }
        layout = LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)unicodeProperties.toString());
        String themeId = null;
        String colorSchemeId = null;
        String css = null;
        if (settings != null) {
            themeId = settings.getThemeName();
            colorSchemeId = settings.getColorSchemeName();
            css = settings.getCss();
        }
        return LayoutServiceUtil.updateLookAndFeel((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)themeId, (String)colorSchemeId, (String)css);
    }

    private static void _updatePageExperiences(Layout layout, PageExperience[] pageExperiences, ServiceContext serviceContext) throws Exception {
        List segmentsExperiences = SegmentsExperienceServiceUtil.getSegmentsExperiences((long)layout.getGroupId(), (long)layout.getPlid(), (boolean)true);
        if (pageExperiences == null || pageExperiences.length != segmentsExperiences.size()) {
            throw new UnsupportedOperationException();
        }
        HashMap<String, SegmentsExperience> segmentsExperiencesMap = new HashMap<String, SegmentsExperience>();
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            segmentsExperiencesMap.put(segmentsExperience.getExternalReferenceCode(), segmentsExperience);
        }
        for (PageExperience pageExperience : pageExperiences) {
            SegmentsExperience segmentsExperience = (SegmentsExperience)segmentsExperiencesMap.get(pageExperience.getExternalReferenceCode());
            if (segmentsExperience == null) {
                throw new UnsupportedOperationException();
            }
            SegmentsExperienceUtil.updateSegmentsExperience(layout, pageExperience, segmentsExperience, serviceContext);
        }
    }
}

