/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Date;

public class ServiceContextUtil {
    public static ServiceContext createServiceContext(ItemExternalReference[] assetCategoriesItemExternalReferences, Date createDate, long groupId, HttpServletRequest httpServletRequest, String[] keywords, Date modifiedDate, long userId, String uuid) throws Exception {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)httpServletRequest, null).build();
        serviceContext.setAssetCategoryIds(ServiceContextUtil._getAssetCategoryIds(groupId, assetCategoriesItemExternalReferences));
        serviceContext.setAssetTagNames(keywords);
        serviceContext.setCreateDate(createDate);
        serviceContext.setModifiedDate(modifiedDate);
        serviceContext.setUserId(userId);
        serviceContext.setUuid(uuid);
        return serviceContext;
    }

    public static ServiceContext createServiceContext(long groupId, HttpServletRequest httpServletRequest, long userId) {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)httpServletRequest, null).build();
        serviceContext.setUserId(userId);
        return serviceContext;
    }

    private static long[] _getAssetCategoryIds(long groupId, ItemExternalReference[] itemExternalReferences) throws Exception {
        if (ArrayUtil.isEmpty((Object[])itemExternalReferences)) {
            return new long[0];
        }
        Group group = GroupServiceUtil.getGroup((long)groupId);
        return TransformUtil.unsafeTransformToLongArray((Collection)ListUtil.fromArray((Object[])itemExternalReferences), itemExternalReference -> {
            AssetCategory assetCategory;
            long scopeGroupId = groupId;
            Scope scope = itemExternalReference.getScope();
            if (scope != null) {
                scopeGroupId = GroupUtil.getGroupId(true, true, group.getCompanyId(), scope.getExternalReferenceCode());
            }
            if ((assetCategory = AssetCategoryServiceUtil.fetchCategoryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)scopeGroupId)) == null) {
                throw new UnsupportedOperationException();
            }
            return assetCategory.getCategoryId();
        });
    }
}

