/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPage;
import com.liferay.headless.admin.site.resource.v1_0.UtilityPageResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineExportTaskResource;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Path(value="/v1.0")
public abstract class BaseUtilityPageResourceImpl
implements EntityModelResource,
UtilityPageResource,
VulcanBatchEngineTaskItemDelegate<UtilityPage> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<UtilityPage>, UnsafeFunction<UtilityPage, UtilityPage, Exception>, Exception> contextBatchUnsafeBiConsumer;
    protected UnsafeBiConsumer<Collection<UtilityPage>, UnsafeConsumer<UtilityPage, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseUtilityPageResourceImpl.class);

    @Operation(description="Deletes a specific utility page of a site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="utilityPageExternalReferenceCode")})
    @Tags(value={@Tag(name="UtilityPage")})
    @DELETE
    @Path(value="/sites/{siteExternalReferenceCode}/utility-pages/{utilityPageExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteSiteSiteByExternalReferenceCodeUtilityPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="utilityPageExternalReferenceCode") String utilityPageExternalReferenceCode) throws Exception {
    }

    @Operation(description="Retrieves a specific utility page of a site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="utilityPageExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="UtilityPage")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/utility-pages/{utilityPageExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public UtilityPage getSiteSiteByExternalReferenceCodeUtilityPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="utilityPageExternalReferenceCode") String utilityPageExternalReferenceCode) throws Exception {
        return new UtilityPage();
    }

    @Operation(description="Retrieves the utility pages of the site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="UtilityPage")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/utility-pages")
    @Produces(value={"application/json", "application/xml"})
    public Page<UtilityPage> getSiteSiteByExternalReferenceCodeUtilityPagesPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="utilityPageExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="UtilityPage")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/utility-pages/{utilityPageExternalReferenceCode}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteUtilityPagePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="utilityPageExternalReferenceCode") String utilityPageExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="utilityPageExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="UtilityPage")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/sites/{siteExternalReferenceCode}/utility-pages/{utilityPageExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public UtilityPage patchSiteSiteByExternalReferenceCodeUtilityPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="utilityPageExternalReferenceCode") String utilityPageExternalReferenceCode, UtilityPage utilityPage) throws Exception {
        UtilityPage existingUtilityPage = this.getSiteSiteByExternalReferenceCodeUtilityPage(siteExternalReferenceCode, utilityPageExternalReferenceCode);
        if (utilityPage.getCreatorExternalReferenceCode() != null) {
            existingUtilityPage.setCreatorExternalReferenceCode(utilityPage.getCreatorExternalReferenceCode());
        }
        if (utilityPage.getDateCreated() != null) {
            existingUtilityPage.setDateCreated(utilityPage.getDateCreated());
        }
        if (utilityPage.getDateModified() != null) {
            existingUtilityPage.setDateModified(utilityPage.getDateModified());
        }
        if (utilityPage.getDatePublished() != null) {
            existingUtilityPage.setDatePublished(utilityPage.getDatePublished());
        }
        if (utilityPage.getExternalReferenceCode() != null) {
            existingUtilityPage.setExternalReferenceCode(utilityPage.getExternalReferenceCode());
        }
        if (utilityPage.getFriendlyUrlPath_i18n() != null) {
            existingUtilityPage.setFriendlyUrlPath_i18n(utilityPage.getFriendlyUrlPath_i18n());
        }
        if (utilityPage.getMarkedAsDefault() != null) {
            existingUtilityPage.setMarkedAsDefault(utilityPage.getMarkedAsDefault());
        }
        if (utilityPage.getName() != null) {
            existingUtilityPage.setName(utilityPage.getName());
        }
        if (utilityPage.getType() != null) {
            existingUtilityPage.setType(utilityPage.getType());
        }
        if (utilityPage.getUuid() != null) {
            existingUtilityPage.setUuid(utilityPage.getUuid());
        }
        this.preparePatch(utilityPage, existingUtilityPage);
        return this.putSiteSiteByExternalReferenceCodeUtilityPage(siteExternalReferenceCode, utilityPageExternalReferenceCode, existingUtilityPage);
    }

    @Operation(description="Adds a new utility page")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode")})
    @Tags(value={@Tag(name="UtilityPage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/utility-pages")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public UtilityPage postSiteSiteByExternalReferenceCodeUtilityPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, UtilityPage utilityPage) throws Exception {
        return new UtilityPage();
    }

    @Operation(description="Adds a new page specification to a utility page.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="utilityPageExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="UtilityPage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/utility-pages/{utilityPageExternalReferenceCode}/page-specifications")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public ContentPageSpecification postSiteSiteByExternalReferenceCodeUtilityPagePageSpecification(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @PathParam(value="utilityPageExternalReferenceCode") String utilityPageExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        return new ContentPageSpecification();
    }

    @Operation(description="Updates the utility page with the given external reference code, or creates it if it does not exist.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="utilityPageExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="UtilityPage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/utility-pages/{utilityPageExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public UtilityPage putSiteSiteByExternalReferenceCodeUtilityPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="utilityPageExternalReferenceCode") String utilityPageExternalReferenceCode, UtilityPage utilityPage) throws Exception {
        return new UtilityPage();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="utilityPageExternalReferenceCode")})
    @Tags(value={@Tag(name="UtilityPage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/utility-pages/{utilityPageExternalReferenceCode}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteUtilityPagePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="utilityPageExternalReferenceCode") String utilityPageExternalReferenceCode, Permission[] permissions) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void create(Collection<UtilityPage> utilityPages, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void delete(Collection<UtilityPage> utilityPages, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getResourceName() {
        return "UtilityPage";
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<UtilityPage> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<UtilityPage> utilityPages, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeBiConsumer(UnsafeBiConsumer<Collection<UtilityPage>, UnsafeFunction<UtilityPage, UtilityPage, Exception>, Exception> contextBatchUnsafeBiConsumer) {
        this.contextBatchUnsafeBiConsumer = contextBatchUnsafeBiConsumer;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<UtilityPage>, UnsafeConsumer<UtilityPage, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = UriInfoUtil.getVulcanUriInfo((String)this.getApplicationPath(), (UriInfo)contextUriInfo);
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    protected String getApplicationPath() {
        return "headless-admin-site";
    }

    public void setVulcanBatchEngineExportTaskResource(VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource) {
        this.vulcanBatchEngineExportTaskResource = vulcanBatchEngineExportTaskResource;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(UtilityPage utilityPage, UtilityPage existingUtilityPage) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToLongArray(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToLongArray(collection, unsafeFunction);
    }
}

