/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryModel;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.function.Function;

public class AssetUtil {
    public static ItemExternalReference[] getKeywordItemExternalReferences(String className, long classPK, long groupId) {
        List assetTags = AssetTagLocalServiceUtil.getTags((String)className, (long)classPK);
        return AssetUtil._getItemExternalReferences(AssetTagModel::getExternalReferenceCode, AssetTagModel::getGroupId, groupId, AssetTag.class.getName(), assetTags);
    }

    public static ItemExternalReference[] getTaxonomyCategoryItemExternalReferences(String className, long classPK, long groupId) {
        List assetCategories = AssetCategoryLocalServiceUtil.getCategories((String)className, (long)classPK);
        return AssetUtil._getItemExternalReferences(AssetCategoryModel::getExternalReferenceCode, AssetCategoryModel::getGroupId, groupId, AssetCategory.class.getName(), assetCategories);
    }

    private static <T> ItemExternalReference[] _getItemExternalReferences(final Function<T, String> getExternalReferenceCodeFunction, final Function<T, Long> getGroupIdFunction, final long groupId, final String itemClassName, List<T> items) {
        if (ListUtil.isEmpty(items)) {
            return new ItemExternalReference[0];
        }
        return (ItemExternalReference[])TransformUtil.unsafeTransformToArray(items, item -> new ItemExternalReference(){
            {
                this.setClassName(() -> itemClassName);
                this.setExternalReferenceCode(() -> (String)getExternalReferenceCodeFunction.apply(item));
                this.setScope(() -> AssetUtil._getScope(groupId, (Long)getGroupIdFunction.apply(item)));
            }
        }, ItemExternalReference.class);
    }

    private static Scope _getScope(long groupId, long scopeGroupId) throws Exception {
        if (groupId == scopeGroupId) {
            return null;
        }
        final Group group = GroupLocalServiceUtil.getGroup((long)scopeGroupId);
        return new Scope(){
            {
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setType(() -> {
                    if (group.getType() == 5) {
                        return Scope.Type.ASSET_LIBRARY;
                    }
                    return Scope.Type.SITE;
                });
            }
        };
    }
}

