/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.ContentPageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.PageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.PageTemplateSet;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageTemplate;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.AssetUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeService;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry"}, service={DTOConverter.class})
public class PageTemplateDTOConverter
implements DTOConverter<LayoutPageTemplateEntry, PageTemplate> {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionLocalService _layoutPageTemplateCollectionLocalService;
    @Reference
    private LayoutPrototypeService _layoutPrototypeService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageTemplateSetDTOConverter)")
    private DTOConverter<LayoutPageTemplateCollection, PageTemplateSet> _pageTemplateSetDTOConverter;

    public String getContentType() {
        return PageTemplate.class.getSimpleName();
    }

    public PageTemplate toDTO(DTOConverterContext dtoConverterContext, LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        if (layoutPageTemplateEntry.getType() == 0) {
            return this._getContentPageTemplate(layoutPageTemplateEntry);
        }
        return this._getWidgetPageTemplate(layoutPageTemplateEntry);
    }

    private PageTemplate _getContentPageTemplate(final LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        final Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        return new ContentPageTemplate(){
            {
                this.setDateCreated(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getCreateDate());
                this.setDateModified(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setExternalReferenceCode(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getExternalReferenceCode());
                this.setKey(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getLayoutPageTemplateEntryKey());
                this.setKeywordItemExternalReferences(() -> AssetUtil.getKeywordItemExternalReferences(Layout.class.getName(), layoutPageTemplateEntry.getPlid(), layoutPageTemplateEntry.getGroupId()));
                this.setName(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getName());
                this.setPageTemplateSet(() -> PageTemplateDTOConverter.this._getPageTemplateSet(layoutPageTemplateEntry));
                this.setTaxonomyCategoryItemExternalReferences(() -> AssetUtil.getTaxonomyCategoryItemExternalReferences(Layout.class.getName(), layoutPageTemplateEntry.getPlid(), layoutPageTemplateEntry.getGroupId()));
                this.setType(() -> PageTemplate.Type.CONTENT_PAGE_TEMPLATE);
                this.setUuid(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getUuid());
            }
        };
    }

    private PageTemplateSet _getPageTemplateSet(LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionLocalService.fetchLayoutPageTemplateCollection(layoutPageTemplateEntry.getLayoutPageTemplateCollectionId());
        if (layoutPageTemplateCollection == null) {
            return null;
        }
        return (PageTemplateSet)this._pageTemplateSetDTOConverter.toDTO((Object)layoutPageTemplateCollection);
    }

    private PageTemplate _getWidgetPageTemplate(final LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        final Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        final LayoutPrototype layoutPrototype = this._layoutPrototypeService.getLayoutPrototype(layoutPageTemplateEntry.getLayoutPrototypeId());
        return new WidgetPageTemplate(){
            {
                this.setActive(() -> ((LayoutPrototype)layoutPrototype).isActive());
                this.setDateCreated(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getCreateDate());
                this.setDateModified(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setDescription_i18n(() -> {
                    if (MapUtil.isEmpty((Map)layoutPrototype.getDescriptionMap())) {
                        return null;
                    }
                    return LocalizedMapUtil.getI18nMap((boolean)true, (Map)layoutPrototype.getDescriptionMap());
                });
                this.setExternalReferenceCode(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getExternalReferenceCode());
                this.setFriendlyUrlPath_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getFriendlyURLMap()));
                this.setKey(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getLayoutPageTemplateEntryKey());
                this.setKeywordItemExternalReferences(() -> AssetUtil.getKeywordItemExternalReferences(Layout.class.getName(), layoutPageTemplateEntry.getPlid(), layoutPageTemplateEntry.getGroupId()));
                this.setName(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getName());
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layoutPrototype.getNameMap()));
                this.setPageTemplateSet(() -> PageTemplateDTOConverter.this._getPageTemplateSet(layoutPageTemplateEntry));
                this.setTaxonomyCategoryItemExternalReferences(() -> AssetUtil.getTaxonomyCategoryItemExternalReferences(Layout.class.getName(), layoutPageTemplateEntry.getPlid(), layoutPageTemplateEntry.getGroupId()));
                this.setType(() -> PageTemplate.Type.WIDGET_PAGE_TEMPLATE);
                this.setUuid(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getUuid());
            }
        };
    }
}

