/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageExperience;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.headless.admin.site.dto.v1_0.Settings;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.SegmentsExperienceUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceServiceUtil;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryServiceUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class LayoutUtil {
    public static Layout addContentLayout(long groupId, PageSpecification[] pageSpecifications, boolean privateLayout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String type, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, int status, ServiceContext serviceContext) throws Exception {
        if (pageSpecifications == null) {
            Layout layout = LayoutLocalServiceUtil.addLayout(null, (long)serviceContext.getUserId(), (long)groupId, (boolean)privateLayout, (long)0L, (long)0L, (long)0L, nameMap, titleMap, descriptionMap, null, null, (String)type, null, (boolean)hidden, (boolean)system, friendlyURLMap, (long)0L, (ServiceContext)serviceContext);
            return LayoutLocalServiceUtil.updateStatus((long)serviceContext.getUserId(), (long)layout.getPlid(), (int)status, (ServiceContext)serviceContext);
        }
        if (pageSpecifications.length != 2) {
            throw new UnsupportedOperationException();
        }
        ContentPageSpecification draftContentPageSpecification = null;
        ContentPageSpecification publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[0];
        if (Validator.isNull((String)publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode())) {
            draftContentPageSpecification = publishedContentPageSpecification;
            publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        } else {
            draftContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        }
        if (Validator.isNull((String)publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode()) || !Objects.equals(draftContentPageSpecification.getExternalReferenceCode(), publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode())) {
            throw new UnsupportedOperationException();
        }
        UnicodeProperties typeSettingsUnicodeProperties = new UnicodeProperties();
        Settings settings = publishedContentPageSpecification.getSettings();
        if (settings == null || Validator.isNull((Object)settings.getMasterPageItemExternalReference())) {
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-footer", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header-search", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:wrap-widget-page-content", Boolean.FALSE.toString());
        }
        long masterLayoutPlid = 0L;
        if (settings != null && settings.getMasterPageItemExternalReference() != null) {
            if (Objects.equals(3, serviceContext.getAttribute("layout.page.template.entry.type"))) {
                throw new UnsupportedOperationException();
            }
            ItemExternalReference itemExternalReference = settings.getMasterPageItemExternalReference();
            if (Validator.isNotNull((String)itemExternalReference.getExternalReferenceCode())) {
                if (itemExternalReference.getScope() != null) {
                    throw new UnsupportedOperationException();
                }
                Layout masterLayout = LayoutLocalServiceUtil.fetchLayoutByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)groupId);
                if (masterLayout == null) {
                    throw new UnsupportedOperationException();
                }
                masterLayoutPlid = masterLayout.getPlid();
            }
        }
        serviceContext.setAttribute("defaultSegmentsExperienceExternalReferenceCode", (Serializable)((Object)SegmentsExperienceUtil.getDefaultSegmentsExperienceExternalReferenceCode(publishedContentPageSpecification.getPageExperiences())));
        serviceContext.setAttribute("draftLayoutDefaultSegmentsExperienceExternalReferenceCode", (Serializable)((Object)SegmentsExperienceUtil.getDefaultSegmentsExperienceExternalReferenceCode(draftContentPageSpecification.getPageExperiences())));
        serviceContext.setAttribute("draftLayoutExternalReferenceCode", (Serializable)((Object)draftContentPageSpecification.getExternalReferenceCode()));
        if (Objects.equals(publishedContentPageSpecification.getStatus(), PageSpecification.Status.APPROVED)) {
            serviceContext.setAttribute("published", (Serializable)((Object)Boolean.TRUE.toString()));
            typeSettingsUnicodeProperties.setProperty("published", Boolean.TRUE.toString());
        } else {
            serviceContext.setAttribute("published", (Serializable)((Object)Boolean.FALSE.toString()));
        }
        Layout layout = LayoutLocalServiceUtil.addLayout((String)publishedContentPageSpecification.getExternalReferenceCode(), (long)serviceContext.getUserId(), (long)groupId, (boolean)privateLayout, (long)0L, (long)0L, (long)0L, nameMap, titleMap, descriptionMap, null, null, (String)type, (String)typeSettingsUnicodeProperties.toString(), (boolean)hidden, (boolean)system, friendlyURLMap, (long)masterLayoutPlid, (ServiceContext)serviceContext);
        Layout draftLayout = layout.fetchDraftLayout();
        int draftLayoutStatus = 0;
        if (Objects.equals(draftContentPageSpecification.getStatus(), PageSpecification.Status.DRAFT)) {
            draftLayoutStatus = 2;
        }
        LayoutUtil.updateLayout(draftContentPageSpecification, draftLayout, nameMap, titleMap, descriptionMap, draftLayout.getFriendlyURLMap(), draftLayoutStatus, serviceContext);
        return LayoutUtil.updateLayout(publishedContentPageSpecification, layout, nameMap, titleMap, descriptionMap, friendlyURLMap, status, serviceContext);
    }

    public static Layout addDraftToLayout(ContentPageSpecification contentPageSpecification, Layout layout, ServiceContext serviceContext) throws Exception {
        if (Validator.isNotNull((Object)contentPageSpecification.getStatus()) && !Objects.equals(contentPageSpecification.getStatus(), PageSpecification.Status.DRAFT) || layout.isDraftLayout()) {
            throw new UnsupportedOperationException();
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (Validator.isNotNull((String)contentPageSpecification.getExternalReferenceCode()) && !Objects.equals(contentPageSpecification.getExternalReferenceCode(), draftLayout.getExternalReferenceCode()) || !Objects.equals(draftLayout.getStatus(), 0)) {
            throw new UnsupportedOperationException();
        }
        return LayoutUtil.updateLayout(contentPageSpecification, draftLayout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), draftLayout.getFriendlyURLMap(), 2, serviceContext);
    }

    public static boolean isPublished(Layout layout) {
        if (!layout.isTypeAssetDisplay() && !layout.isTypeContent()) {
            return true;
        }
        if (layout.isDraftLayout()) {
            return GetterUtil.getBoolean((String)layout.getTypeSettingsProperty("published"));
        }
        Layout draftLayout = layout.fetchDraftLayout();
        return GetterUtil.getBoolean((String)draftLayout.getTypeSettingsProperty("published"));
    }

    public static Layout updateContentLayout(Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> friendlyURLMap, PageSpecification[] pageSpecifications, ServiceContext serviceContext) throws Exception {
        if (pageSpecifications == null) {
            return LayoutUtil._updateLayout(layout, nameMap, titleMap, descriptionMap, layout.getStyleBookEntryId(), layout.getFaviconFileEntryId(), layout.getMasterLayoutPlid(), friendlyURLMap, serviceContext);
        }
        if (pageSpecifications.length != 2) {
            throw new UnsupportedOperationException();
        }
        ContentPageSpecification draftContentPageSpecification = null;
        ContentPageSpecification publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[0];
        if (!Objects.equals(layout.getExternalReferenceCode(), publishedContentPageSpecification.getExternalReferenceCode())) {
            draftContentPageSpecification = publishedContentPageSpecification;
            publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        } else {
            draftContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (!(Objects.equals(draftLayout.getExternalReferenceCode(), draftContentPageSpecification.getExternalReferenceCode()) && Objects.equals(layout.getExternalReferenceCode(), publishedContentPageSpecification.getExternalReferenceCode()) && Objects.equals(publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode(), draftContentPageSpecification.getExternalReferenceCode()))) {
            throw new UnsupportedOperationException();
        }
        int draftLayoutStatus = 0;
        if (Objects.equals(draftContentPageSpecification.getStatus(), PageSpecification.Status.DRAFT)) {
            draftLayoutStatus = 2;
        }
        int status = layout.getStatus();
        if (Objects.equals(publishedContentPageSpecification.getStatus(), PageSpecification.Status.APPROVED)) {
            serviceContext.setAttribute("published", (Serializable)((Object)Boolean.TRUE.toString()));
            status = 0;
        }
        LayoutUtil.updateLayout(draftContentPageSpecification, draftLayout, nameMap, titleMap, descriptionMap, draftLayout.getFriendlyURLMap(), draftLayoutStatus, serviceContext);
        return LayoutUtil.updateLayout(publishedContentPageSpecification, layout, nameMap, titleMap, descriptionMap, friendlyURLMap, status, serviceContext);
    }

    public static Layout updateLayout(ContentPageSpecification contentPageSpecification, Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> friendlyURLMap, int status, ServiceContext serviceContext) throws Exception {
        LayoutUtil.updateLayout(layout, nameMap, titleMap, descriptionMap, friendlyURLMap, contentPageSpecification.getSettings(), serviceContext);
        LayoutUtil._updatePageExperiences(layout, contentPageSpecification.getPageExperiences(), serviceContext);
        return LayoutLocalServiceUtil.updateStatus((long)serviceContext.getUserId(), (long)layout.getPlid(), (int)status, (ServiceContext)serviceContext);
    }

    public static Layout updateLayout(Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> friendlyURLMap, Settings settings, ServiceContext serviceContext) throws Exception {
        layout = LayoutUtil._updateLookAndFeel(layout, settings);
        return LayoutUtil._updateLayout(layout, nameMap, titleMap, descriptionMap, LayoutUtil._getStyleBookEntryId(layout, settings), LayoutUtil._getFaviconFileEntryId(layout, settings), LayoutUtil._getMasterLayoutPlid(layout, settings), friendlyURLMap, serviceContext);
    }

    private static long _getFaviconFileEntryId(Layout layout, Settings settings) throws Exception {
        DLFileEntry dlFileEntry;
        if (settings == null || settings.getFavIcon() == null || !(settings.getFavIcon() instanceof ItemExternalReference)) {
            return 0L;
        }
        ItemExternalReference itemExternalReference = (ItemExternalReference)settings.getFavIcon();
        if (Validator.isNull((String)itemExternalReference.getExternalReferenceCode())) {
            return 0L;
        }
        long groupId = layout.getGroupId();
        Scope scope = itemExternalReference.getScope();
        if (scope != null) {
            groupId = GroupUtil.getGroupId(true, true, layout.getCompanyId(), scope.getExternalReferenceCode());
        }
        if ((dlFileEntry = DLFileEntryServiceUtil.fetchFileEntryByExternalReferenceCode((long)groupId, (String)itemExternalReference.getExternalReferenceCode())) == null) {
            throw new UnsupportedOperationException();
        }
        return dlFileEntry.getFileEntryId();
    }

    private static long _getMasterLayoutPlid(Layout layout, Settings settings) throws Exception {
        if (settings == null) {
            return 0L;
        }
        ItemExternalReference itemExternalReference = settings.getMasterPageItemExternalReference();
        if (itemExternalReference == null || Validator.isNull((String)itemExternalReference.getExternalReferenceCode())) {
            return 0L;
        }
        if (itemExternalReference.getScope() != null) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByPlid((long)layout.getPlid());
        if (layoutPageTemplateEntry != null && Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        layoutPageTemplateEntry = LayoutPageTemplateEntryServiceUtil.fetchLayoutPageTemplateEntryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)layout.getGroupId());
        if (layoutPageTemplateEntry == null || !Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return layoutPageTemplateEntry.getPlid();
    }

    private static long _getStyleBookEntryId(Layout layout, Settings settings) throws Exception {
        if (settings == null) {
            return 0L;
        }
        ItemExternalReference itemExternalReference = settings.getStyleBookItemExternalReference();
        if (itemExternalReference == null || Validator.isNull((String)itemExternalReference.getExternalReferenceCode())) {
            return 0L;
        }
        StyleBookEntry styleBookEntry = StyleBookEntryServiceUtil.getStyleBookEntryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)layout.getGroupId());
        return styleBookEntry.getStyleBookEntryId();
    }

    private static Layout _updateLayout(Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long styleBookEntryId, long faviconFileEntryId, long masterLayoutPlid, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws Exception {
        if (layout.isTypeAssetDisplay() || layout.isTypeUtility()) {
            serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        }
        return LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (long)layout.getParentLayoutId(), nameMap, titleMap, descriptionMap, (Map)layout.getKeywordsMap(), (Map)layout.getRobotsMap(), (String)layout.getType(), (boolean)layout.isHidden(), friendlyURLMap, (boolean)layout.getIconImage(), null, (long)styleBookEntryId, (long)faviconFileEntryId, (long)masterLayoutPlid, (ServiceContext)serviceContext);
    }

    private static Layout _updateLookAndFeel(Layout layout, Settings settings) throws Exception {
        UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        if (settings != null) {
            unicodeProperties.setProperty("javascript", settings.getJavascript());
        } else {
            unicodeProperties.remove((Object)"javascript");
        }
        for (String key : ListUtil.fromCollection((Collection)unicodeProperties.keySet())) {
            if (!key.startsWith("lfr-theme:")) continue;
            unicodeProperties.remove((Object)key);
        }
        if (settings != null && MapUtil.isNotEmpty((Map)settings.getThemeSettings())) {
            unicodeProperties.putAll(settings.getThemeSettings());
        }
        layout = LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)unicodeProperties.toString());
        Theme theme = null;
        String themeId = null;
        if (settings != null && Validator.isNotNull((String)settings.getThemeName())) {
            for (Theme curTheme : ThemeLocalServiceUtil.getThemes((long)layout.getCompanyId())) {
                if (!Objects.equals(curTheme.getName(), settings.getThemeName())) continue;
                theme = curTheme;
                themeId = curTheme.getThemeId();
                break;
            }
            if (themeId == null) {
                throw new UnsupportedOperationException();
            }
        }
        String colorSchemeId = null;
        if (settings != null && Validator.isNotNull((String)settings.getColorSchemeName())) {
            ColorScheme colorScheme;
            if (theme == null) {
                throw new UnsupportedOperationException();
            }
            for (ColorScheme colorScheme2 : theme.getColorSchemes()) {
                if (!Objects.equals(colorScheme2.getName(), settings.getColorSchemeName())) continue;
                colorSchemeId = colorScheme2.getColorSchemeId();
                break;
            }
            if (colorSchemeId == null && Objects.equals((colorScheme = ColorSchemeFactoryUtil.getDefaultRegularColorScheme()).getName(), settings.getColorSchemeName())) {
                colorSchemeId = colorScheme.getColorSchemeId();
            }
            if (colorSchemeId == null) {
                throw new UnsupportedOperationException();
            }
        }
        String css = null;
        if (settings != null) {
            css = settings.getCss();
        }
        return LayoutServiceUtil.updateLookAndFeel((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), themeId, colorSchemeId, (String)css);
    }

    private static void _updatePageExperiences(Layout layout, PageExperience[] pageExperiences, ServiceContext serviceContext) throws Exception {
        List segmentsExperiences = SegmentsExperienceServiceUtil.getSegmentsExperiences((long)layout.getGroupId(), (long)layout.getPlid(), (boolean)true);
        if (pageExperiences == null || pageExperiences.length != segmentsExperiences.size()) {
            throw new UnsupportedOperationException();
        }
        HashMap<String, SegmentsExperience> segmentsExperiencesMap = new HashMap<String, SegmentsExperience>();
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            segmentsExperiencesMap.put(segmentsExperience.getExternalReferenceCode(), segmentsExperience);
        }
        for (PageExperience pageExperience : pageExperiences) {
            SegmentsExperience segmentsExperience = (SegmentsExperience)segmentsExperiencesMap.get(pageExperience.getExternalReferenceCode());
            if (segmentsExperience == null) {
                throw new UnsupportedOperationException();
            }
            SegmentsExperienceUtil.updateSegmentsExperience(layout, pageExperience, segmentsExperience, serviceContext);
        }
    }
}

