/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.client.resource.v1_0;

import com.liferay.headless.admin.site.client.dto.v1_0.FragmentComposition;
import com.liferay.headless.admin.site.client.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.client.http.HttpInvoker;
import com.liferay.headless.admin.site.client.pagination.Page;
import com.liferay.headless.admin.site.client.problem.Problem;
import com.liferay.headless.admin.site.client.serdes.v1_0.PageElementSerDes;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface PageElementResource {
    public static Builder builder() {
        return new Builder();
    }

    public void deleteSitePageSpecificationPageExperiencePageElement(String var1, String var2, String var3, String var4) throws Exception;

    public HttpInvoker.HttpResponse deleteSitePageSpecificationPageExperiencePageElementHttpResponse(String var1, String var2, String var3, String var4) throws Exception;

    public PageElement getSitePageSpecificationPageExperiencePageElement(String var1, String var2, String var3, String var4) throws Exception;

    public HttpInvoker.HttpResponse getSitePageSpecificationPageExperiencePageElementHttpResponse(String var1, String var2, String var3, String var4) throws Exception;

    public Page<PageElement> getSitePageSpecificationPageExperiencePageElementPageElementsPage(String var1, String var2, String var3, String var4, Boolean var5) throws Exception;

    public HttpInvoker.HttpResponse getSitePageSpecificationPageExperiencePageElementPageElementsPageHttpResponse(String var1, String var2, String var3, String var4, Boolean var5) throws Exception;

    public Page<PageElement> getSitePageSpecificationPageExperiencePageElementsPage(String var1, String var2, String var3, Boolean var4) throws Exception;

    public HttpInvoker.HttpResponse getSitePageSpecificationPageExperiencePageElementsPageHttpResponse(String var1, String var2, String var3, Boolean var4) throws Exception;

    public PageElement patchSitePageSpecificationPageExperiencePageElement(String var1, String var2, String var3, String var4, PageElement var5) throws Exception;

    public HttpInvoker.HttpResponse patchSitePageSpecificationPageExperiencePageElementHttpResponse(String var1, String var2, String var3, String var4, PageElement var5) throws Exception;

    public PageElement postSitePageSpecificationPageExperiencePageElement(String var1, String var2, String var3, PageElement var4) throws Exception;

    public HttpInvoker.HttpResponse postSitePageSpecificationPageExperiencePageElementHttpResponse(String var1, String var2, String var3, PageElement var4) throws Exception;

    public PageElement postSitePageSpecificationPageExperiencePageElementFragmentComposition(String var1, String var2, String var3, String var4, Integer var5, FragmentComposition var6) throws Exception;

    public HttpInvoker.HttpResponse postSitePageSpecificationPageExperiencePageElementFragmentCompositionHttpResponse(String var1, String var2, String var3, String var4, Integer var5, FragmentComposition var6) throws Exception;

    public PageElement putSitePageSpecificationPageExperiencePageElement(String var1, String var2, String var3, String var4, PageElement var5) throws Exception;

    public HttpInvoker.HttpResponse putSitePageSpecificationPageExperiencePageElementHttpResponse(String var1, String var2, String var3, String var4, PageElement var5) throws Exception;

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login;
        private String _password;
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public Builder bearerToken(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        public PageElementResource build() {
            return new PageElementResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String address, String scheme) {
            String[] addressParts = address.split(":");
            String host = addressParts[0];
            int port = 443;
            if (addressParts.length > 1) {
                String portString = addressParts[1];
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse port from " + portString);
                }
            }
            return this.endpoint(host, port, scheme);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder endpoint(URL url) {
            return this.endpoint(url.getHost(), url.getPort(), url.getProtocol());
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }

    public static class PageElementResourceImpl
    implements PageElementResource {
        private static final Logger _logger = Logger.getLogger(PageElementResource.class.getName());
        private Builder _builder;

        @Override
        public void deleteSitePageSpecificationPageExperiencePageElement(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteSitePageSpecificationPageExperiencePageElementHttpResponse(siteExternalReferenceCode, pageSpecificationExternalReferenceCode, pageExperienceExternalReferenceCode, pageElementExternalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteSitePageSpecificationPageExperiencePageElementHttpResponse(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/page-specifications/{pageSpecificationExternalReferenceCode}/page-experiences/{pageExperienceExternalReferenceCode}/page-elements/{pageElementExternalReferenceCode}");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("pageSpecificationExternalReferenceCode", pageSpecificationExternalReferenceCode);
            httpInvoker.path("pageExperienceExternalReferenceCode", pageExperienceExternalReferenceCode);
            httpInvoker.path("pageElementExternalReferenceCode", pageElementExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public PageElement getSitePageSpecificationPageExperiencePageElement(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSitePageSpecificationPageExperiencePageElementHttpResponse(siteExternalReferenceCode, pageSpecificationExternalReferenceCode, pageExperienceExternalReferenceCode, pageElementExternalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return PageElementSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSitePageSpecificationPageExperiencePageElementHttpResponse(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/page-specifications/{pageSpecificationExternalReferenceCode}/page-experiences/{pageExperienceExternalReferenceCode}/page-elements/{pageElementExternalReferenceCode}");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("pageSpecificationExternalReferenceCode", pageSpecificationExternalReferenceCode);
            httpInvoker.path("pageExperienceExternalReferenceCode", pageExperienceExternalReferenceCode);
            httpInvoker.path("pageElementExternalReferenceCode", pageElementExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<PageElement> getSitePageSpecificationPageExperiencePageElementPageElementsPage(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode, Boolean flatten) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSitePageSpecificationPageExperiencePageElementPageElementsPageHttpResponse(siteExternalReferenceCode, pageSpecificationExternalReferenceCode, pageExperienceExternalReferenceCode, pageElementExternalReferenceCode, flatten);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, PageElementSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSitePageSpecificationPageExperiencePageElementPageElementsPageHttpResponse(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode, Boolean flatten) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (flatten != null) {
                httpInvoker.parameter("flatten", String.valueOf(flatten));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/page-specifications/{pageSpecificationExternalReferenceCode}/page-experiences/{pageExperienceExternalReferenceCode}/page-elements/{pageElementExternalReferenceCode}/page-elements");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("pageSpecificationExternalReferenceCode", pageSpecificationExternalReferenceCode);
            httpInvoker.path("pageExperienceExternalReferenceCode", pageExperienceExternalReferenceCode);
            httpInvoker.path("pageElementExternalReferenceCode", pageElementExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<PageElement> getSitePageSpecificationPageExperiencePageElementsPage(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, Boolean flatten) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSitePageSpecificationPageExperiencePageElementsPageHttpResponse(siteExternalReferenceCode, pageSpecificationExternalReferenceCode, pageExperienceExternalReferenceCode, flatten);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, PageElementSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSitePageSpecificationPageExperiencePageElementsPageHttpResponse(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, Boolean flatten) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (flatten != null) {
                httpInvoker.parameter("flatten", String.valueOf(flatten));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/page-specifications/{pageSpecificationExternalReferenceCode}/page-experiences/{pageExperienceExternalReferenceCode}/page-elements");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("pageSpecificationExternalReferenceCode", pageSpecificationExternalReferenceCode);
            httpInvoker.path("pageExperienceExternalReferenceCode", pageExperienceExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public PageElement patchSitePageSpecificationPageExperiencePageElement(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode, PageElement pageElement) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchSitePageSpecificationPageExperiencePageElementHttpResponse(siteExternalReferenceCode, pageSpecificationExternalReferenceCode, pageExperienceExternalReferenceCode, pageElementExternalReferenceCode, pageElement);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return PageElementSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse patchSitePageSpecificationPageExperiencePageElementHttpResponse(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode, PageElement pageElement) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(pageElement.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/page-specifications/{pageSpecificationExternalReferenceCode}/page-experiences/{pageExperienceExternalReferenceCode}/page-elements/{pageElementExternalReferenceCode}");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("pageSpecificationExternalReferenceCode", pageSpecificationExternalReferenceCode);
            httpInvoker.path("pageExperienceExternalReferenceCode", pageExperienceExternalReferenceCode);
            httpInvoker.path("pageElementExternalReferenceCode", pageElementExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public PageElement postSitePageSpecificationPageExperiencePageElement(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, PageElement pageElement) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postSitePageSpecificationPageExperiencePageElementHttpResponse(siteExternalReferenceCode, pageSpecificationExternalReferenceCode, pageExperienceExternalReferenceCode, pageElement);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return PageElementSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postSitePageSpecificationPageExperiencePageElementHttpResponse(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, PageElement pageElement) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(pageElement.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/page-specifications/{pageSpecificationExternalReferenceCode}/page-experiences/{pageExperienceExternalReferenceCode}/page-elements");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("pageSpecificationExternalReferenceCode", pageSpecificationExternalReferenceCode);
            httpInvoker.path("pageExperienceExternalReferenceCode", pageExperienceExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public PageElement postSitePageSpecificationPageExperiencePageElementFragmentComposition(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode, Integer position, FragmentComposition fragmentComposition) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postSitePageSpecificationPageExperiencePageElementFragmentCompositionHttpResponse(siteExternalReferenceCode, pageSpecificationExternalReferenceCode, pageExperienceExternalReferenceCode, pageElementExternalReferenceCode, position, fragmentComposition);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return PageElementSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postSitePageSpecificationPageExperiencePageElementFragmentCompositionHttpResponse(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode, Integer position, FragmentComposition fragmentComposition) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(fragmentComposition.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (position != null) {
                httpInvoker.parameter("position", String.valueOf(position));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/page-specifications/{pageSpecificationExternalReferenceCode}/page-experiences/{pageExperienceExternalReferenceCode}/page-elements/{pageElementExternalReferenceCode}/fragment-compositions");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("pageSpecificationExternalReferenceCode", pageSpecificationExternalReferenceCode);
            httpInvoker.path("pageExperienceExternalReferenceCode", pageExperienceExternalReferenceCode);
            httpInvoker.path("pageElementExternalReferenceCode", pageElementExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public PageElement putSitePageSpecificationPageExperiencePageElement(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode, PageElement pageElement) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putSitePageSpecificationPageExperiencePageElementHttpResponse(siteExternalReferenceCode, pageSpecificationExternalReferenceCode, pageExperienceExternalReferenceCode, pageElementExternalReferenceCode, pageElement);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return PageElementSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putSitePageSpecificationPageExperiencePageElementHttpResponse(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode, PageElement pageElement) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(pageElement.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/page-specifications/{pageSpecificationExternalReferenceCode}/page-experiences/{pageExperienceExternalReferenceCode}/page-elements/{pageElementExternalReferenceCode}");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("pageSpecificationExternalReferenceCode", pageSpecificationExternalReferenceCode);
            httpInvoker.path("pageExperienceExternalReferenceCode", pageExperienceExternalReferenceCode);
            httpInvoker.path("pageElementExternalReferenceCode", pageElementExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        private PageElementResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }
}

