/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.client.dto.v1_0;

import com.liferay.headless.admin.site.client.function.UnsafeSupplier;
import com.liferay.headless.admin.site.client.serdes.v1_0.NavigationMenuValueSerDes;
import java.io.Serializable;
import java.util.Objects;

public abstract class NavigationMenuValue
implements Cloneable,
Serializable {
    protected NavigationMenuType navigationMenuType;

    public static NavigationMenuValue toDTO(String json) {
        return NavigationMenuValueSerDes.toDTO(json);
    }

    public NavigationMenuType getNavigationMenuType() {
        return this.navigationMenuType;
    }

    public String getNavigationMenuTypeAsString() {
        if (this.navigationMenuType == null) {
            return null;
        }
        return this.navigationMenuType.toString();
    }

    public void setNavigationMenuType(NavigationMenuType navigationMenuType) {
        this.navigationMenuType = navigationMenuType;
    }

    public void setNavigationMenuType(UnsafeSupplier<NavigationMenuType, Exception> navigationMenuTypeUnsafeSupplier) {
        try {
            this.navigationMenuType = navigationMenuTypeUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NavigationMenuValue clone() throws CloneNotSupportedException {
        return (NavigationMenuValue)super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NavigationMenuValue)) {
            return false;
        }
        NavigationMenuValue navigationMenuValue = (NavigationMenuValue)object;
        return Objects.equals(this.toString(), navigationMenuValue.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        return NavigationMenuValueSerDes.toJSON(this);
    }

    public static enum NavigationMenuType {
        CONTEXTUAL_MENU("ContextualMenu"),
        SITE_MENU("SiteMenu"),
        SITE_PAGES("SitePages");

        private final String _value;

        public static NavigationMenuType create(String value) {
            for (NavigationMenuType navigationMenuType : NavigationMenuType.values()) {
                if (!Objects.equals(navigationMenuType.getValue(), value) && !Objects.equals(navigationMenuType.name(), value)) continue;
                return navigationMenuType;
            }
            return null;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private NavigationMenuType(String value) {
            this._value = value;
        }
    }
}

