/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.headless.admin.site.client.serdes.v1_0;

import com.liferay.headless.admin.site.client.dto.v1_0.TextFragmentEditableElementValue;
import com.liferay.headless.admin.site.client.json.BaseJSONParser;

import jakarta.annotation.Generated;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

/**
 * @author Rubén Pulido
 * @generated
 */
@Generated("")
public class TextFragmentEditableElementValueSerDes {

	public static TextFragmentEditableElementValue toDTO(String json) {
		TextFragmentEditableElementValueJSONParser
			textFragmentEditableElementValueJSONParser =
				new TextFragmentEditableElementValueJSONParser();

		return textFragmentEditableElementValueJSONParser.parseToDTO(json);
	}

	public static TextFragmentEditableElementValue[] toDTOs(String json) {
		TextFragmentEditableElementValueJSONParser
			textFragmentEditableElementValueJSONParser =
				new TextFragmentEditableElementValueJSONParser();

		return textFragmentEditableElementValueJSONParser.parseToDTOs(json);
	}

	public static String toJSON(
		TextFragmentEditableElementValue textFragmentEditableElementValue) {

		if (textFragmentEditableElementValue == null) {
			return "null";
		}

		StringBuilder sb = new StringBuilder();

		sb.append("{");

		if (textFragmentEditableElementValue.
				getFragmentEditableElementValueFragmentLink() != null) {

			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"fragmentEditableElementValueFragmentLink\": ");

			sb.append(
				String.valueOf(
					textFragmentEditableElementValue.
						getFragmentEditableElementValueFragmentLink()));
		}

		if (textFragmentEditableElementValue.getTextFragmentValue() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"textFragmentValue\": ");

			sb.append(
				String.valueOf(
					textFragmentEditableElementValue.getTextFragmentValue()));
		}

		if (textFragmentEditableElementValue.getType() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"type\": ");

			sb.append("\"");
			sb.append(textFragmentEditableElementValue.getType());
			sb.append("\"");
		}

		sb.append("}");

		return sb.toString();
	}

	public static Map<String, Object> toMap(String json) {
		TextFragmentEditableElementValueJSONParser
			textFragmentEditableElementValueJSONParser =
				new TextFragmentEditableElementValueJSONParser();

		return textFragmentEditableElementValueJSONParser.parseToMap(json);
	}

	public static Map<String, String> toMap(
		TextFragmentEditableElementValue textFragmentEditableElementValue) {

		if (textFragmentEditableElementValue == null) {
			return null;
		}

		Map<String, String> map = new TreeMap<>();

		if (textFragmentEditableElementValue.
				getFragmentEditableElementValueFragmentLink() == null) {

			map.put("fragmentEditableElementValueFragmentLink", null);
		}
		else {
			map.put(
				"fragmentEditableElementValueFragmentLink",
				String.valueOf(
					textFragmentEditableElementValue.
						getFragmentEditableElementValueFragmentLink()));
		}

		if (textFragmentEditableElementValue.getTextFragmentValue() == null) {
			map.put("textFragmentValue", null);
		}
		else {
			map.put(
				"textFragmentValue",
				String.valueOf(
					textFragmentEditableElementValue.getTextFragmentValue()));
		}

		if (textFragmentEditableElementValue.getType() == null) {
			map.put("type", null);
		}
		else {
			map.put(
				"type",
				String.valueOf(textFragmentEditableElementValue.getType()));
		}

		return map;
	}

	public static class TextFragmentEditableElementValueJSONParser
		extends BaseJSONParser<TextFragmentEditableElementValue> {

		@Override
		protected TextFragmentEditableElementValue createDTO() {
			return new TextFragmentEditableElementValue();
		}

		@Override
		protected TextFragmentEditableElementValue[] createDTOArray(int size) {
			return new TextFragmentEditableElementValue[size];
		}

		@Override
		protected boolean parseMaps(String jsonParserFieldName) {
			if (Objects.equals(
					jsonParserFieldName,
					"fragmentEditableElementValueFragmentLink")) {

				return false;
			}
			else if (Objects.equals(jsonParserFieldName, "textFragmentValue")) {
				return false;
			}
			else if (Objects.equals(jsonParserFieldName, "type")) {
				return false;
			}

			return false;
		}

		@Override
		protected void setField(
			TextFragmentEditableElementValue textFragmentEditableElementValue,
			String jsonParserFieldName, Object jsonParserFieldValue) {

			if (Objects.equals(
					jsonParserFieldName,
					"fragmentEditableElementValueFragmentLink")) {

				if (jsonParserFieldValue != null) {
					textFragmentEditableElementValue.
						setFragmentEditableElementValueFragmentLink(
							FragmentEditableElementValueFragmentLinkSerDes.
								toDTO((String)jsonParserFieldValue));
				}
			}
			else if (Objects.equals(jsonParserFieldName, "textFragmentValue")) {
				if (jsonParserFieldValue != null) {
					textFragmentEditableElementValue.setTextFragmentValue(
						TextFragmentValueSerDes.toDTO(
							(String)jsonParserFieldValue));
				}
			}
			else if (Objects.equals(jsonParserFieldName, "type")) {
				if (jsonParserFieldValue != null) {
					textFragmentEditableElementValue.setType(
						TextFragmentEditableElementValue.Type.create(
							(String)jsonParserFieldValue));
				}
			}
		}

	}

	private static String _escape(Object object) {
		String string = String.valueOf(object);

		for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
			string = string.replace(strings[0], strings[1]);
		}

		return string;
	}

	private static String _toJSON(Map<String, ?> map) {
		StringBuilder sb = new StringBuilder("{");

		@SuppressWarnings("unchecked")
		Set set = map.entrySet();

		@SuppressWarnings("unchecked")
		Iterator<Map.Entry<String, ?>> iterator = set.iterator();

		while (iterator.hasNext()) {
			Map.Entry<String, ?> entry = iterator.next();

			sb.append("\"");
			sb.append(entry.getKey());
			sb.append("\": ");

			Object value = entry.getValue();

			sb.append(_toJSON(value));

			if (iterator.hasNext()) {
				sb.append(", ");
			}
		}

		sb.append("}");

		return sb.toString();
	}

	private static String _toJSON(Object value) {
		if (value == null) {
			return "null";
		}

		if (value instanceof Map) {
			return _toJSON((Map)value);
		}

		Class<?> clazz = value.getClass();

		if (clazz.isArray()) {
			StringBuilder sb = new StringBuilder("[");

			Object[] values = (Object[])value;

			for (int i = 0; i < values.length; i++) {
				sb.append(_toJSON(values[i]));

				if ((i + 1) < values.length) {
					sb.append(", ");
				}
			}

			sb.append("]");

			return sb.toString();
		}

		if (value instanceof String) {
			return "\"" + _escape(value) + "\"";
		}

		return String.valueOf(value);
	}

}