/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.headless.admin.site.client.dto.v1_0;

import com.liferay.headless.admin.site.client.function.UnsafeSupplier;
import com.liferay.headless.admin.site.client.serdes.v1_0.StyleBookSerDes;

import jakarta.annotation.Generated;

import java.io.Serializable;

import java.util.Date;
import java.util.Objects;

/**
 * @author Rubén Pulido
 * @generated
 */
@Generated("")
public class StyleBook implements Cloneable, Serializable {

	public static StyleBook toDTO(String json) {
		return StyleBookSerDes.toDTO(json);
	}

	public Creator getCreator() {
		return creator;
	}

	public void setCreator(Creator creator) {
		this.creator = creator;
	}

	public void setCreator(
		UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {

		try {
			creator = creatorUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected Creator creator;

	public Date getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}

	public void setDateCreated(
		UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {

		try {
			dateCreated = dateCreatedUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected Date dateCreated;

	public Date getDateModified() {
		return dateModified;
	}

	public void setDateModified(Date dateModified) {
		this.dateModified = dateModified;
	}

	public void setDateModified(
		UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {

		try {
			dateModified = dateModifiedUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected Date dateModified;

	public Boolean getDefaultStyleBook() {
		return defaultStyleBook;
	}

	public void setDefaultStyleBook(Boolean defaultStyleBook) {
		this.defaultStyleBook = defaultStyleBook;
	}

	public void setDefaultStyleBook(
		UnsafeSupplier<Boolean, Exception> defaultStyleBookUnsafeSupplier) {

		try {
			defaultStyleBook = defaultStyleBookUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected Boolean defaultStyleBook;

	public String getExternalReferenceCode() {
		return externalReferenceCode;
	}

	public void setExternalReferenceCode(String externalReferenceCode) {
		this.externalReferenceCode = externalReferenceCode;
	}

	public void setExternalReferenceCode(
		UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {

		try {
			externalReferenceCode = externalReferenceCodeUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected String externalReferenceCode;

	public String getFrontendTokensValues() {
		return frontendTokensValues;
	}

	public void setFrontendTokensValues(String frontendTokensValues) {
		this.frontendTokensValues = frontendTokensValues;
	}

	public void setFrontendTokensValues(
		UnsafeSupplier<String, Exception> frontendTokensValuesUnsafeSupplier) {

		try {
			frontendTokensValues = frontendTokensValuesUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected String frontendTokensValues;

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public void setKey(UnsafeSupplier<String, Exception> keyUnsafeSupplier) {
		try {
			key = keyUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected String key;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
		try {
			name = nameUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected String name;

	public String getPreviewFileEntryExternalReferenceCode() {
		return previewFileEntryExternalReferenceCode;
	}

	public void setPreviewFileEntryExternalReferenceCode(
		String previewFileEntryExternalReferenceCode) {

		this.previewFileEntryExternalReferenceCode =
			previewFileEntryExternalReferenceCode;
	}

	public void setPreviewFileEntryExternalReferenceCode(
		UnsafeSupplier<String, Exception>
			previewFileEntryExternalReferenceCodeUnsafeSupplier) {

		try {
			previewFileEntryExternalReferenceCode =
				previewFileEntryExternalReferenceCodeUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected String previewFileEntryExternalReferenceCode;

	public String getThemeId() {
		return themeId;
	}

	public void setThemeId(String themeId) {
		this.themeId = themeId;
	}

	public void setThemeId(
		UnsafeSupplier<String, Exception> themeIdUnsafeSupplier) {

		try {
			themeId = themeIdUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected String themeId;

	@Override
	public StyleBook clone() throws CloneNotSupportedException {
		return (StyleBook)super.clone();
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof StyleBook)) {
			return false;
		}

		StyleBook styleBook = (StyleBook)object;

		return Objects.equals(toString(), styleBook.toString());
	}

	@Override
	public int hashCode() {
		String string = toString();

		return string.hashCode();
	}

	public String toString() {
		return StyleBookSerDes.toJSON(this);
	}

}