/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.client.resource.v1_0;

import com.liferay.headless.admin.site.client.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.client.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.client.http.HttpInvoker;
import com.liferay.headless.admin.site.client.pagination.Page;
import com.liferay.headless.admin.site.client.pagination.Pagination;
import com.liferay.headless.admin.site.client.permission.Permission;
import com.liferay.headless.admin.site.client.problem.Problem;
import com.liferay.headless.admin.site.client.serdes.v1_0.ContentPageSpecificationSerDes;
import com.liferay.headless.admin.site.client.serdes.v1_0.SitePageSerDes;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface SitePageResource {
    public static Builder builder() {
        return new Builder();
    }

    public void deleteSiteSiteByExternalReferenceCodeSitePage(String var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse deleteSiteSiteByExternalReferenceCodeSitePageHttpResponse(String var1, String var2) throws Exception;

    public SitePage getSiteSiteByExternalReferenceCodeSitePage(String var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse getSiteSiteByExternalReferenceCodeSitePageHttpResponse(String var1, String var2) throws Exception;

    public Page<SitePage> getSiteSiteByExternalReferenceCodeSitePagesPage(String var1, String var2, List<String> var3, String var4, Pagination var5, String var6) throws Exception;

    public HttpInvoker.HttpResponse getSiteSiteByExternalReferenceCodeSitePagesPageHttpResponse(String var1, String var2, List<String> var3, String var4, Pagination var5, String var6) throws Exception;

    public Page<Permission> getSiteSitePagePermissionsPage(String var1, String var2, String var3) throws Exception;

    public HttpInvoker.HttpResponse getSiteSitePagePermissionsPageHttpResponse(String var1, String var2, String var3) throws Exception;

    public SitePage patchSiteSiteByExternalReferenceCodeSitePage(String var1, String var2, SitePage var3) throws Exception;

    public HttpInvoker.HttpResponse patchSiteSiteByExternalReferenceCodeSitePageHttpResponse(String var1, String var2, SitePage var3) throws Exception;

    public SitePage postByExternalReferenceCodeSitePage(String var1, SitePage var2) throws Exception;

    public HttpInvoker.HttpResponse postByExternalReferenceCodeSitePageHttpResponse(String var1, SitePage var2) throws Exception;

    public ContentPageSpecification postSiteSiteByExternalReferenceCodeSitePagePageSpecification(String var1, String var2, ContentPageSpecification var3) throws Exception;

    public HttpInvoker.HttpResponse postSiteSiteByExternalReferenceCodeSitePagePageSpecificationHttpResponse(String var1, String var2, ContentPageSpecification var3) throws Exception;

    public SitePage putSiteSiteByExternalReferenceCodeSitePage(String var1, String var2, SitePage var3) throws Exception;

    public HttpInvoker.HttpResponse putSiteSiteByExternalReferenceCodeSitePageHttpResponse(String var1, String var2, SitePage var3) throws Exception;

    public Page<Permission> putSiteSitePagePermissionsPage(String var1, String var2, Permission[] var3) throws Exception;

    public HttpInvoker.HttpResponse putSiteSitePagePermissionsPageHttpResponse(String var1, String var2, Permission[] var3) throws Exception;

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login;
        private String _password;
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public Builder bearerToken(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        public SitePageResource build() {
            return new SitePageResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String address, String scheme) {
            String[] addressParts = address.split(":");
            String host = addressParts[0];
            int port = 443;
            if (addressParts.length > 1) {
                String portString = addressParts[1];
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse port from " + portString);
                }
            }
            return this.endpoint(host, port, scheme);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder endpoint(URL url) {
            return this.endpoint(url.getHost(), url.getPort(), url.getProtocol());
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }

    public static class SitePageResourceImpl
    implements SitePageResource {
        private static final Logger _logger = Logger.getLogger(SitePageResource.class.getName());
        private Builder _builder;

        @Override
        public void deleteSiteSiteByExternalReferenceCodeSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteSiteSiteByExternalReferenceCodeSitePageHttpResponse(siteExternalReferenceCode, sitePageExternalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteSiteSiteByExternalReferenceCodeSitePageHttpResponse(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/site-pages/{sitePageExternalReferenceCode}");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("sitePageExternalReferenceCode", sitePageExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public SitePage getSiteSiteByExternalReferenceCodeSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSiteSiteByExternalReferenceCodeSitePageHttpResponse(siteExternalReferenceCode, sitePageExternalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return SitePageSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSiteSiteByExternalReferenceCodeSitePageHttpResponse(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/site-pages/{sitePageExternalReferenceCode}");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("sitePageExternalReferenceCode", sitePageExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<SitePage> getSiteSiteByExternalReferenceCodeSitePagesPage(String siteExternalReferenceCode, String search, List<String> aggregations, String filterString, Pagination pagination, String sortString) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSiteSiteByExternalReferenceCodeSitePagesPageHttpResponse(siteExternalReferenceCode, search, aggregations, filterString, pagination, sortString);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, SitePageSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSiteSiteByExternalReferenceCodeSitePagesPageHttpResponse(String siteExternalReferenceCode, String search, List<String> aggregations, String filterString, Pagination pagination, String sortString) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (search != null) {
                httpInvoker.parameter("search", String.valueOf(search));
            }
            if (filterString != null) {
                httpInvoker.parameter("filter", filterString);
            }
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            if (sortString != null) {
                httpInvoker.parameter("sort", sortString);
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/site-pages");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<Permission> getSiteSitePagePermissionsPage(String siteExternalReferenceCode, String sitePageExternalReferenceCode, String roleNames) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSiteSitePagePermissionsPageHttpResponse(siteExternalReferenceCode, sitePageExternalReferenceCode, roleNames);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, Permission::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSiteSitePagePermissionsPageHttpResponse(String siteExternalReferenceCode, String sitePageExternalReferenceCode, String roleNames) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (roleNames != null) {
                httpInvoker.parameter("roleNames", String.valueOf(roleNames));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/site-pages/{sitePageExternalReferenceCode}/permissions");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("sitePageExternalReferenceCode", sitePageExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public SitePage patchSiteSiteByExternalReferenceCodeSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode, SitePage sitePage) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchSiteSiteByExternalReferenceCodeSitePageHttpResponse(siteExternalReferenceCode, sitePageExternalReferenceCode, sitePage);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return SitePageSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse patchSiteSiteByExternalReferenceCodeSitePageHttpResponse(String siteExternalReferenceCode, String sitePageExternalReferenceCode, SitePage sitePage) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(sitePage.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/site-pages/{sitePageExternalReferenceCode}");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("sitePageExternalReferenceCode", sitePageExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public SitePage postByExternalReferenceCodeSitePage(String siteExternalReferenceCode, SitePage sitePage) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postByExternalReferenceCodeSitePageHttpResponse(siteExternalReferenceCode, sitePage);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return SitePageSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postByExternalReferenceCodeSitePageHttpResponse(String siteExternalReferenceCode, SitePage sitePage) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(sitePage.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/site-pages");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public ContentPageSpecification postSiteSiteByExternalReferenceCodeSitePagePageSpecification(String siteExternalReferenceCode, String sitePageExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postSiteSiteByExternalReferenceCodeSitePagePageSpecificationHttpResponse(siteExternalReferenceCode, sitePageExternalReferenceCode, contentPageSpecification);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ContentPageSpecificationSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postSiteSiteByExternalReferenceCodeSitePagePageSpecificationHttpResponse(String siteExternalReferenceCode, String sitePageExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(contentPageSpecification.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/site-pages/{sitePageExternalReferenceCode}/page-specifications");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("sitePageExternalReferenceCode", sitePageExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public SitePage putSiteSiteByExternalReferenceCodeSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode, SitePage sitePage) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putSiteSiteByExternalReferenceCodeSitePageHttpResponse(siteExternalReferenceCode, sitePageExternalReferenceCode, sitePage);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return SitePageSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putSiteSiteByExternalReferenceCodeSitePageHttpResponse(String siteExternalReferenceCode, String sitePageExternalReferenceCode, SitePage sitePage) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(sitePage.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/site-pages/{sitePageExternalReferenceCode}");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("sitePageExternalReferenceCode", sitePageExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<Permission> putSiteSitePagePermissionsPage(String siteExternalReferenceCode, String sitePageExternalReferenceCode, Permission[] permissions) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putSiteSitePagePermissionsPageHttpResponse(siteExternalReferenceCode, sitePageExternalReferenceCode, permissions);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, Permission::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putSiteSitePagePermissionsPageHttpResponse(String siteExternalReferenceCode, String sitePageExternalReferenceCode, Permission[] permissions) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            ArrayList<String> values = new ArrayList<String>();
            for (Permission permissionValue : permissions) {
                values.add(String.valueOf(permissionValue));
            }
            httpInvoker.body(((Object)values).toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-admin-site/v1.0/sites/{siteExternalReferenceCode}/site-pages/{sitePageExternalReferenceCode}/permissions");
            httpInvoker.path("siteExternalReferenceCode", siteExternalReferenceCode);
            httpInvoker.path("sitePageExternalReferenceCode", sitePageExternalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        private SitePageResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }
}

