/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.client.dto.v1_0;

import com.liferay.headless.admin.site.client.function.UnsafeSupplier;
import com.liferay.headless.admin.site.client.serdes.v1_0.NavigationSettingsSerDes;
import java.io.Serializable;
import java.util.Objects;

public class NavigationSettings
implements Cloneable,
Serializable {
    protected String target;
    protected TargetType targetType;

    public static NavigationSettings toDTO(String json) {
        return NavigationSettingsSerDes.toDTO(json);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTarget(UnsafeSupplier<String, Exception> targetUnsafeSupplier) {
        try {
            this.target = targetUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public String getTargetTypeAsString() {
        if (this.targetType == null) {
            return null;
        }
        return this.targetType.toString();
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    public void setTargetType(UnsafeSupplier<TargetType, Exception> targetTypeUnsafeSupplier) {
        try {
            this.targetType = targetTypeUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NavigationSettings clone() throws CloneNotSupportedException {
        return (NavigationSettings)super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NavigationSettings)) {
            return false;
        }
        NavigationSettings navigationSettings = (NavigationSettings)object;
        return Objects.equals(this.toString(), navigationSettings.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        return NavigationSettingsSerDes.toJSON(this);
    }

    public static enum TargetType {
        SPECIFIC_FRAME("SpecificFrame"),
        NEW_TAB("NewTab");

        private final String _value;

        public static TargetType create(String value) {
            for (TargetType targetType : TargetType.values()) {
                if (!Objects.equals(targetType.getValue(), value) && !Objects.equals(targetType.name(), value)) continue;
                return targetType;
            }
            return null;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private TargetType(String value) {
            this._value = value;
        }
    }
}

