/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPermission;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="A widget instance, containing the common properties of both a content page widget instance and a widget page widget instance.", value="WidgetInstance")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="WidgetInstance")
public class WidgetInstance
implements Serializable {
    @GraphQLField(description="The configuration keys and values of the widget instance.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The configuration keys and values of the widget instance.") Map<String, Object> widgetConfig;
    @JsonIgnore
    private Supplier<Map<String, Object>> _widgetConfigSupplier;
    @GraphQLField(description="The widget instance's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The widget instance's ID.") String widgetInstanceId;
    @JsonIgnore
    private Supplier<String> _widgetInstanceIdSupplier;
    @GraphQLField(description="The widget instance's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The widget instance's name.") String widgetName;
    @JsonIgnore
    private Supplier<String> _widgetNameSupplier;
    @GraphQLField(description="The widget instance's permissions.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The widget instance's permissions.") WidgetPermission[] widgetPermissions;
    @JsonIgnore
    private Supplier<WidgetPermission[]> _widgetPermissionsSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.WidgetInstance", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static WidgetInstance toDTO(String json) {
        return (WidgetInstance)ObjectMapperUtil.readValue(WidgetInstance.class, (String)json);
    }

    public static WidgetInstance unsafeToDTO(String json) {
        return (WidgetInstance)ObjectMapperUtil.unsafeReadValue(WidgetInstance.class, (String)json);
    }

    @Schema(description="The configuration keys and values of the widget instance.")
    @Valid
    public Map<String, Object> getWidgetConfig() {
        if (this._widgetConfigSupplier != null) {
            this.widgetConfig = this._widgetConfigSupplier.get();
            this._widgetConfigSupplier = null;
        }
        return this.widgetConfig;
    }

    public void setWidgetConfig(Map<String, Object> widgetConfig) {
        this.widgetConfig = widgetConfig;
        this._widgetConfigSupplier = null;
    }

    @JsonIgnore
    public void setWidgetConfig(UnsafeSupplier<Map<String, Object>, Exception> widgetConfigUnsafeSupplier) {
        this._widgetConfigSupplier = () -> {
            try {
                return (Map)widgetConfigUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The widget instance's ID.")
    public String getWidgetInstanceId() {
        if (this._widgetInstanceIdSupplier != null) {
            this.widgetInstanceId = this._widgetInstanceIdSupplier.get();
            this._widgetInstanceIdSupplier = null;
        }
        return this.widgetInstanceId;
    }

    public void setWidgetInstanceId(String widgetInstanceId) {
        this.widgetInstanceId = widgetInstanceId;
        this._widgetInstanceIdSupplier = null;
    }

    @JsonIgnore
    public void setWidgetInstanceId(UnsafeSupplier<String, Exception> widgetInstanceIdUnsafeSupplier) {
        this._widgetInstanceIdSupplier = () -> {
            try {
                return (String)widgetInstanceIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The widget instance's name.")
    public String getWidgetName() {
        if (this._widgetNameSupplier != null) {
            this.widgetName = this._widgetNameSupplier.get();
            this._widgetNameSupplier = null;
        }
        return this.widgetName;
    }

    public void setWidgetName(String widgetName) {
        this.widgetName = widgetName;
        this._widgetNameSupplier = null;
    }

    @JsonIgnore
    public void setWidgetName(UnsafeSupplier<String, Exception> widgetNameUnsafeSupplier) {
        this._widgetNameSupplier = () -> {
            try {
                return (String)widgetNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The widget instance's permissions.")
    @Valid
    public WidgetPermission[] getWidgetPermissions() {
        if (this._widgetPermissionsSupplier != null) {
            this.widgetPermissions = this._widgetPermissionsSupplier.get();
            this._widgetPermissionsSupplier = null;
        }
        return this.widgetPermissions;
    }

    public void setWidgetPermissions(WidgetPermission[] widgetPermissions) {
        this.widgetPermissions = widgetPermissions;
        this._widgetPermissionsSupplier = null;
    }

    @JsonIgnore
    public void setWidgetPermissions(UnsafeSupplier<WidgetPermission[], Exception> widgetPermissionsUnsafeSupplier) {
        this._widgetPermissionsSupplier = () -> {
            try {
                return (WidgetPermission[])widgetPermissionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WidgetInstance)) {
            return false;
        }
        WidgetInstance widgetInstance = (WidgetInstance)object;
        return Objects.equals(this.toString(), widgetInstance.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        WidgetPermission[] widgetPermissions;
        String widgetName;
        String widgetInstanceId;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Map<String, Object> widgetConfig = this.getWidgetConfig();
        if (widgetConfig != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"widgetConfig\": ");
            sb.append(WidgetInstance._toJSON(widgetConfig));
        }
        if ((widgetInstanceId = this.getWidgetInstanceId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"widgetInstanceId\": ");
            sb.append("\"");
            sb.append(WidgetInstance._escape(widgetInstanceId));
            sb.append("\"");
        }
        if ((widgetName = this.getWidgetName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"widgetName\": ");
            sb.append("\"");
            sb.append(WidgetInstance._escape(widgetName));
            sb.append("\"");
        }
        if ((widgetPermissions = this.getWidgetPermissions()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"widgetPermissions\": ");
            sb.append("[");
            for (int i = 0; i < widgetPermissions.length; ++i) {
                sb.append(String.valueOf(widgetPermissions[i]));
                if (i + 1 >= widgetPermissions.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WidgetInstance._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WidgetInstance._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(WidgetInstance._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WidgetInstance._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WidgetInstance._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

