/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Represents settings related with the site map.", value="SitemapSettings")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="SitemapSettings")
public class SitemapSettings
implements Serializable {
    @GraphQLField(description="Indicates how often a page is updated.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Indicates how often a page is updated.") ChangeFrequency changeFrequency;
    @JsonIgnore
    private Supplier<ChangeFrequency> _changeFrequencySupplier;
    @GraphQLField(description="Whether search engines should crawl and index the page.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Whether search engines should crawl and index the page.") Boolean include;
    @JsonIgnore
    private Supplier<Boolean> _includeSupplier;
    @GraphQLField(description="Whether search engines should crawl and index the child pages.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Whether search engines should crawl and index the child pages.") Boolean includeChildSitePages;
    @JsonIgnore
    private Supplier<Boolean> _includeChildSitePagesSupplier;
    @GraphQLField(description="How the page should be prioritized relative to other pages.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="How the page should be prioritized relative to other pages.") Double pagePriority;
    @JsonIgnore
    private Supplier<Double> _pagePrioritySupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.SitemapSettings", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static SitemapSettings toDTO(String json) {
        return (SitemapSettings)ObjectMapperUtil.readValue(SitemapSettings.class, (String)json);
    }

    public static SitemapSettings unsafeToDTO(String json) {
        return (SitemapSettings)ObjectMapperUtil.unsafeReadValue(SitemapSettings.class, (String)json);
    }

    @Schema(description="Indicates how often a page is updated.")
    @JsonGetter(value="changeFrequency")
    @Valid
    public ChangeFrequency getChangeFrequency() {
        if (this._changeFrequencySupplier != null) {
            this.changeFrequency = this._changeFrequencySupplier.get();
            this._changeFrequencySupplier = null;
        }
        return this.changeFrequency;
    }

    @JsonIgnore
    public String getChangeFrequencyAsString() {
        ChangeFrequency changeFrequency = this.getChangeFrequency();
        if (changeFrequency == null) {
            return null;
        }
        return changeFrequency.toString();
    }

    public void setChangeFrequency(ChangeFrequency changeFrequency) {
        this.changeFrequency = changeFrequency;
        this._changeFrequencySupplier = null;
    }

    @JsonIgnore
    public void setChangeFrequency(UnsafeSupplier<ChangeFrequency, Exception> changeFrequencyUnsafeSupplier) {
        this._changeFrequencySupplier = () -> {
            try {
                return (ChangeFrequency)((Object)((Object)changeFrequencyUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Whether search engines should crawl and index the page.")
    public Boolean getInclude() {
        if (this._includeSupplier != null) {
            this.include = this._includeSupplier.get();
            this._includeSupplier = null;
        }
        return this.include;
    }

    public void setInclude(Boolean include) {
        this.include = include;
        this._includeSupplier = null;
    }

    @JsonIgnore
    public void setInclude(UnsafeSupplier<Boolean, Exception> includeUnsafeSupplier) {
        this._includeSupplier = () -> {
            try {
                return (Boolean)includeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Whether search engines should crawl and index the child pages.")
    public Boolean getIncludeChildSitePages() {
        if (this._includeChildSitePagesSupplier != null) {
            this.includeChildSitePages = this._includeChildSitePagesSupplier.get();
            this._includeChildSitePagesSupplier = null;
        }
        return this.includeChildSitePages;
    }

    public void setIncludeChildSitePages(Boolean includeChildSitePages) {
        this.includeChildSitePages = includeChildSitePages;
        this._includeChildSitePagesSupplier = null;
    }

    @JsonIgnore
    public void setIncludeChildSitePages(UnsafeSupplier<Boolean, Exception> includeChildSitePagesUnsafeSupplier) {
        this._includeChildSitePagesSupplier = () -> {
            try {
                return (Boolean)includeChildSitePagesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMax(value="1")
    @DecimalMin(value="0")
    @Schema(description="How the page should be prioritized relative to other pages.")
    public @DecimalMax(value="1") @DecimalMin(value="0") Double getPagePriority() {
        if (this._pagePrioritySupplier != null) {
            this.pagePriority = this._pagePrioritySupplier.get();
            this._pagePrioritySupplier = null;
        }
        return this.pagePriority;
    }

    public void setPagePriority(Double pagePriority) {
        this.pagePriority = pagePriority;
        this._pagePrioritySupplier = null;
    }

    @JsonIgnore
    public void setPagePriority(UnsafeSupplier<Double, Exception> pagePriorityUnsafeSupplier) {
        this._pagePrioritySupplier = () -> {
            try {
                return (Double)pagePriorityUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SitemapSettings)) {
            return false;
        }
        SitemapSettings sitemapSettings = (SitemapSettings)object;
        return Objects.equals(this.toString(), sitemapSettings.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Double pagePriority;
        Boolean includeChildSitePages;
        Boolean include;
        StringBundler sb = new StringBundler();
        sb.append("{");
        ChangeFrequency changeFrequency = this.getChangeFrequency();
        if (changeFrequency != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"changeFrequency\": ");
            sb.append("\"");
            sb.append((Object)changeFrequency);
            sb.append("\"");
        }
        if ((include = this.getInclude()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"include\": ");
            sb.append((Object)include);
        }
        if ((includeChildSitePages = this.getIncludeChildSitePages()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"includeChildSitePages\": ");
            sb.append((Object)includeChildSitePages);
        }
        if ((pagePriority = this.getPagePriority()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pagePriority\": ");
            sb.append((Object)pagePriority);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(SitemapSettings._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (SitemapSettings._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(SitemapSettings._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(SitemapSettings._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(SitemapSettings._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="ChangeFrequency")
    public static enum ChangeFrequency {
        ALWAYS("Always"),
        HOURLY("Hourly"),
        DAILY("Daily"),
        WEEKLY("Weekly"),
        MONTHLY("Monthly"),
        YEARLY("Yearly"),
        NEVER("Never");

        private final String _value;

        @JsonCreator
        public static ChangeFrequency create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (ChangeFrequency changeFrequency : ChangeFrequency.values()) {
                if (!Objects.equals(changeFrequency.getValue(), value)) continue;
                return changeFrequency;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ChangeFrequency(String value) {
            this._value = value;
        }
    }
}

