/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.Settings;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSpecification;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="A page specification of a content page, content page template, widget page, or widget page template. A content page will contain 1 page specifications for its draft layout and 1 page specifications for its published layout. A widget page contains only 1 page specification for its published layout.", value="PageSpecification")
@JsonFilter(value="Liferay.Vulcan")
@JsonSubTypes(value={@JsonSubTypes.Type(name="ContentPageSpecification", value=ContentPageSpecification.class), @JsonSubTypes.Type(name="WidgetPageSpecification", value=WidgetPageSpecification.class)})
@JsonTypeInfo(include=JsonTypeInfo.As.PROPERTY, property="type", use=JsonTypeInfo.Id.NAME, visible=true)
@XmlRootElement(name="PageSpecification")
public abstract class PageSpecification
implements Serializable {
    @GraphQLField(description="The page specification's external reference code, unique per site.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page specification's external reference code, unique per site.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Settings settings;
    @JsonIgnore
    private Supplier<Settings> _settingsSupplier;
    @GraphQLField(description="The status of the page specification.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The status of the page specification.") Status status;
    @JsonIgnore
    private Supplier<Status> _statusSupplier;
    @GraphQLField(description="The type of the page specification.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The type of the page specification.") Type type;
    @JsonIgnore
    private Supplier<Type> _typeSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.PageSpecification", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static PageSpecification toDTO(String json) {
        return (PageSpecification)ObjectMapperUtil.readValue(PageSpecification.class, (String)json);
    }

    public static PageSpecification unsafeToDTO(String json) {
        return (PageSpecification)ObjectMapperUtil.unsafeReadValue(PageSpecification.class, (String)json);
    }

    @Schema(description="The page specification's external reference code, unique per site.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Settings getSettings() {
        if (this._settingsSupplier != null) {
            this.settings = this._settingsSupplier.get();
            this._settingsSupplier = null;
        }
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this._settingsSupplier = null;
    }

    @JsonIgnore
    public void setSettings(UnsafeSupplier<Settings, Exception> settingsUnsafeSupplier) {
        this._settingsSupplier = () -> {
            try {
                return (Settings)settingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The status of the page specification.")
    @JsonGetter(value="status")
    @Valid
    public Status getStatus() {
        if (this._statusSupplier != null) {
            this.status = this._statusSupplier.get();
            this._statusSupplier = null;
        }
        return this.status;
    }

    @JsonIgnore
    public String getStatusAsString() {
        Status status = this.getStatus();
        if (status == null) {
            return null;
        }
        return status.toString();
    }

    public void setStatus(Status status) {
        this.status = status;
        this._statusSupplier = null;
    }

    @JsonIgnore
    public void setStatus(UnsafeSupplier<Status, Exception> statusUnsafeSupplier) {
        this._statusSupplier = () -> {
            try {
                return (Status)((Object)((Object)statusUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The type of the page specification.")
    @JsonGetter(value="type")
    @Valid
    public Type getType() {
        if (this._typeSupplier != null) {
            this.type = this._typeSupplier.get();
            this._typeSupplier = null;
        }
        return this.type;
    }

    @JsonIgnore
    public String getTypeAsString() {
        Type type = this.getType();
        if (type == null) {
            return null;
        }
        return type.toString();
    }

    public void setType(Type type) {
        this.type = type;
        this._typeSupplier = null;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Type, Exception> typeUnsafeSupplier) {
        this._typeSupplier = () -> {
            try {
                return (Type)((Object)((Object)typeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PageSpecification)) {
            return false;
        }
        PageSpecification pageSpecification = (PageSpecification)object;
        return Objects.equals(this.toString(), pageSpecification.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Type type;
        Status status;
        Settings settings;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String externalReferenceCode = this.getExternalReferenceCode();
        if (externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(PageSpecification._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((settings = this.getSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"settings\": ");
            sb.append(String.valueOf(settings));
        }
        if ((status = this.getStatus()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"status\": ");
            sb.append("\"");
            sb.append((Object)status);
            sb.append("\"");
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)type);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(PageSpecification._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (PageSpecification._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(PageSpecification._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(PageSpecification._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(PageSpecification._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Status")
    public static enum Status {
        APPROVED("Approved"),
        DRAFT("Draft");

        private final String _value;

        @JsonCreator
        public static Status create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Status status : Status.values()) {
                if (!Objects.equals(status.getValue(), value)) continue;
                return status;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Status(String value) {
            this._value = value;
        }
    }

    @GraphQLName(value="Type")
    public static enum Type {
        CONTENT_PAGE_SPECIFICATION("ContentPageSpecification"),
        WIDGET_PAGE_SPECIFICATION("WidgetPageSpecification");

        private final String _value;

        @JsonCreator
        public static Type create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Type type : Type.values()) {
                if (!Objects.equals(type.getValue(), value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }
}

