/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.ClassSubtypeReference;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateFolder;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateSettings;
import com.liferay.headless.admin.site.dto.v1_0.FriendlyUrlHistory;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="A display page template.", value="DisplayPageTemplate")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="DisplayPageTemplate")
public class DisplayPageTemplate
implements Serializable {
    @GraphQLField(description="The content type (and optionally subtype) associated to the display page template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The content type (and optionally subtype) associated to the display page template.") ClassSubtypeReference contentTypeReference;
    @JsonIgnore
    private Supplier<ClassSubtypeReference> _contentTypeReferenceSupplier;
    @GraphQLField(description="The display page template's creator. It is not returned by default. It can be embedded via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The display page template's creator. It is not returned by default. It can be embedded via nestedFields.") Creator creator;
    @JsonIgnore
    private Supplier<Creator> _creatorSupplier;
    @GraphQLField(description="The display page template's creator external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's creator external reference code.") String creatorExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _creatorExternalReferenceCodeSupplier;
    @GraphQLField(description="The display page template's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The last time any field of the display page template was changed.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The last time any field of the display page template was changed.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField(description="The display page template's most recent publication date.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's most recent publication date.") Date datePublished;
    @JsonIgnore
    private Supplier<Date> _datePublishedSupplier;
    @GraphQLField(description="Settings of the display page template, such as SEO or OpenGraph.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Settings of the display page template, such as SEO or OpenGraph.") DisplayPageTemplateSettings displayPageTemplateSettings;
    @JsonIgnore
    private Supplier<DisplayPageTemplateSettings> _displayPageTemplateSettingsSupplier;
    @GraphQLField(description="The display page template's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The history of previously used URLs to the display page template's rendered content. This field is not returned by default. It can be requested via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The history of previously used URLs to the display page template's rendered content. This field is not returned by default. It can be requested via nestedFields.") FriendlyUrlHistory friendlyUrlHistory;
    @JsonIgnore
    private Supplier<FriendlyUrlHistory> _friendlyUrlHistorySupplier;
    @GraphQLField(description="The localized relative URLs to the display page template's rendered content.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized relative URLs to the display page template's rendered content.") Map<String, String> friendlyUrlPath_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _friendlyUrlPath_i18nSupplier;
    @GraphQLField(description="The display page template's key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's key.") String key;
    @JsonIgnore
    private Supplier<String> _keySupplier;
    @GraphQLField(description="Whether the display page template is the default one for the given content type/subtype.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Whether the display page template is the default one for the given content type/subtype.") Boolean markedAsDefault;
    @JsonIgnore
    private Supplier<Boolean> _markedAsDefaultSupplier;
    @GraphQLField(description="The display page template's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's name.") String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField(description="The display page template's specifications. A display page template will contain 1 page specifications for its draft layout and 1 page specifications for its published layout. This field is not returned by default. It can be requested via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's specifications. A display page template will contain 1 page specifications for its draft layout and 1 page specifications for its published layout. This field is not returned by default. It can be requested via nestedFields.") PageSpecification[] pageSpecifications;
    @JsonIgnore
    private Supplier<PageSpecification[]> _pageSpecificationsSupplier;
    @GraphQLField(description="The display page template's parent folder.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's parent folder.") DisplayPageTemplateFolder parentFolder;
    @JsonIgnore
    private Supplier<DisplayPageTemplateFolder> _parentFolderSupplier;
    @GraphQLField(description="The display page template's thumbnail.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's thumbnail.") ItemExternalReference thumbnail;
    @JsonIgnore
    private Supplier<ItemExternalReference> _thumbnailSupplier;
    @GraphQLField(description="A valid external identifier to reference this display page template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A valid external identifier to reference this display page template.") String uuid;
    @JsonIgnore
    private Supplier<String> _uuidSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplate", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static DisplayPageTemplate toDTO(String json) {
        return (DisplayPageTemplate)ObjectMapperUtil.readValue(DisplayPageTemplate.class, (String)json);
    }

    public static DisplayPageTemplate unsafeToDTO(String json) {
        return (DisplayPageTemplate)ObjectMapperUtil.unsafeReadValue(DisplayPageTemplate.class, (String)json);
    }

    @Schema(description="The content type (and optionally subtype) associated to the display page template.")
    @Valid
    public ClassSubtypeReference getContentTypeReference() {
        if (this._contentTypeReferenceSupplier != null) {
            this.contentTypeReference = this._contentTypeReferenceSupplier.get();
            this._contentTypeReferenceSupplier = null;
        }
        return this.contentTypeReference;
    }

    public void setContentTypeReference(ClassSubtypeReference contentTypeReference) {
        this.contentTypeReference = contentTypeReference;
        this._contentTypeReferenceSupplier = null;
    }

    @JsonIgnore
    public void setContentTypeReference(UnsafeSupplier<ClassSubtypeReference, Exception> contentTypeReferenceUnsafeSupplier) {
        this._contentTypeReferenceSupplier = () -> {
            try {
                return (ClassSubtypeReference)contentTypeReferenceUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The display page template's creator. It is not returned by default. It can be embedded via nestedFields.")
    @Valid
    public Creator getCreator() {
        if (this._creatorSupplier != null) {
            this.creator = this._creatorSupplier.get();
            this._creatorSupplier = null;
        }
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
        this._creatorSupplier = null;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        this._creatorSupplier = () -> {
            try {
                return (Creator)creatorUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The display page template's creator external reference code.")
    public String getCreatorExternalReferenceCode() {
        if (this._creatorExternalReferenceCodeSupplier != null) {
            this.creatorExternalReferenceCode = this._creatorExternalReferenceCodeSupplier.get();
            this._creatorExternalReferenceCodeSupplier = null;
        }
        return this.creatorExternalReferenceCode;
    }

    public void setCreatorExternalReferenceCode(String creatorExternalReferenceCode) {
        this.creatorExternalReferenceCode = creatorExternalReferenceCode;
        this._creatorExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setCreatorExternalReferenceCode(UnsafeSupplier<String, Exception> creatorExternalReferenceCodeUnsafeSupplier) {
        this._creatorExternalReferenceCodeSupplier = () -> {
            try {
                return (String)creatorExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The display page template's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time any field of the display page template was changed.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The display page template's most recent publication date.")
    public Date getDatePublished() {
        if (this._datePublishedSupplier != null) {
            this.datePublished = this._datePublishedSupplier.get();
            this._datePublishedSupplier = null;
        }
        return this.datePublished;
    }

    public void setDatePublished(Date datePublished) {
        this.datePublished = datePublished;
        this._datePublishedSupplier = null;
    }

    @JsonIgnore
    public void setDatePublished(UnsafeSupplier<Date, Exception> datePublishedUnsafeSupplier) {
        this._datePublishedSupplier = () -> {
            try {
                return (Date)datePublishedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Settings of the display page template, such as SEO or OpenGraph.")
    @Valid
    public DisplayPageTemplateSettings getDisplayPageTemplateSettings() {
        if (this._displayPageTemplateSettingsSupplier != null) {
            this.displayPageTemplateSettings = this._displayPageTemplateSettingsSupplier.get();
            this._displayPageTemplateSettingsSupplier = null;
        }
        return this.displayPageTemplateSettings;
    }

    public void setDisplayPageTemplateSettings(DisplayPageTemplateSettings displayPageTemplateSettings) {
        this.displayPageTemplateSettings = displayPageTemplateSettings;
        this._displayPageTemplateSettingsSupplier = null;
    }

    @JsonIgnore
    public void setDisplayPageTemplateSettings(UnsafeSupplier<DisplayPageTemplateSettings, Exception> displayPageTemplateSettingsUnsafeSupplier) {
        this._displayPageTemplateSettingsSupplier = () -> {
            try {
                return (DisplayPageTemplateSettings)displayPageTemplateSettingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The display page template's external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The history of previously used URLs to the display page template's rendered content. This field is not returned by default. It can be requested via nestedFields.")
    @Valid
    public FriendlyUrlHistory getFriendlyUrlHistory() {
        if (this._friendlyUrlHistorySupplier != null) {
            this.friendlyUrlHistory = this._friendlyUrlHistorySupplier.get();
            this._friendlyUrlHistorySupplier = null;
        }
        return this.friendlyUrlHistory;
    }

    public void setFriendlyUrlHistory(FriendlyUrlHistory friendlyUrlHistory) {
        this.friendlyUrlHistory = friendlyUrlHistory;
        this._friendlyUrlHistorySupplier = null;
    }

    @JsonIgnore
    public void setFriendlyUrlHistory(UnsafeSupplier<FriendlyUrlHistory, Exception> friendlyUrlHistoryUnsafeSupplier) {
        this._friendlyUrlHistorySupplier = () -> {
            try {
                return (FriendlyUrlHistory)friendlyUrlHistoryUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized relative URLs to the display page template's rendered content.")
    @Valid
    public Map<String, String> getFriendlyUrlPath_i18n() {
        if (this._friendlyUrlPath_i18nSupplier != null) {
            this.friendlyUrlPath_i18n = this._friendlyUrlPath_i18nSupplier.get();
            this._friendlyUrlPath_i18nSupplier = null;
        }
        return this.friendlyUrlPath_i18n;
    }

    public void setFriendlyUrlPath_i18n(Map<String, String> friendlyUrlPath_i18n) {
        this.friendlyUrlPath_i18n = friendlyUrlPath_i18n;
        this._friendlyUrlPath_i18nSupplier = null;
    }

    @JsonIgnore
    public void setFriendlyUrlPath_i18n(UnsafeSupplier<Map<String, String>, Exception> friendlyUrlPath_i18nUnsafeSupplier) {
        this._friendlyUrlPath_i18nSupplier = () -> {
            try {
                return (Map)friendlyUrlPath_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The display page template's key.")
    public String getKey() {
        if (this._keySupplier != null) {
            this.key = this._keySupplier.get();
            this._keySupplier = null;
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this._keySupplier = null;
    }

    @JsonIgnore
    public void setKey(UnsafeSupplier<String, Exception> keyUnsafeSupplier) {
        this._keySupplier = () -> {
            try {
                return (String)keyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Whether the display page template is the default one for the given content type/subtype.")
    public Boolean getMarkedAsDefault() {
        if (this._markedAsDefaultSupplier != null) {
            this.markedAsDefault = this._markedAsDefaultSupplier.get();
            this._markedAsDefaultSupplier = null;
        }
        return this.markedAsDefault;
    }

    public void setMarkedAsDefault(Boolean markedAsDefault) {
        this.markedAsDefault = markedAsDefault;
        this._markedAsDefaultSupplier = null;
    }

    @JsonIgnore
    public void setMarkedAsDefault(UnsafeSupplier<Boolean, Exception> markedAsDefaultUnsafeSupplier) {
        this._markedAsDefaultSupplier = () -> {
            try {
                return (Boolean)markedAsDefaultUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The display page template's name.")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The display page template's specifications. A display page template will contain 1 page specifications for its draft layout and 1 page specifications for its published layout. This field is not returned by default. It can be requested via nestedFields.")
    @Valid
    public PageSpecification[] getPageSpecifications() {
        if (this._pageSpecificationsSupplier != null) {
            this.pageSpecifications = this._pageSpecificationsSupplier.get();
            this._pageSpecificationsSupplier = null;
        }
        return this.pageSpecifications;
    }

    public void setPageSpecifications(PageSpecification[] pageSpecifications) {
        this.pageSpecifications = pageSpecifications;
        this._pageSpecificationsSupplier = null;
    }

    @JsonIgnore
    public void setPageSpecifications(UnsafeSupplier<PageSpecification[], Exception> pageSpecificationsUnsafeSupplier) {
        this._pageSpecificationsSupplier = () -> {
            try {
                return (PageSpecification[])pageSpecificationsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The display page template's parent folder.")
    @Valid
    public DisplayPageTemplateFolder getParentFolder() {
        if (this._parentFolderSupplier != null) {
            this.parentFolder = this._parentFolderSupplier.get();
            this._parentFolderSupplier = null;
        }
        return this.parentFolder;
    }

    public void setParentFolder(DisplayPageTemplateFolder parentFolder) {
        this.parentFolder = parentFolder;
        this._parentFolderSupplier = null;
    }

    @JsonIgnore
    public void setParentFolder(UnsafeSupplier<DisplayPageTemplateFolder, Exception> parentFolderUnsafeSupplier) {
        this._parentFolderSupplier = () -> {
            try {
                return (DisplayPageTemplateFolder)parentFolderUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The display page template's thumbnail.")
    @Valid
    public ItemExternalReference getThumbnail() {
        if (this._thumbnailSupplier != null) {
            this.thumbnail = this._thumbnailSupplier.get();
            this._thumbnailSupplier = null;
        }
        return this.thumbnail;
    }

    public void setThumbnail(ItemExternalReference thumbnail) {
        this.thumbnail = thumbnail;
        this._thumbnailSupplier = null;
    }

    @JsonIgnore
    public void setThumbnail(UnsafeSupplier<ItemExternalReference, Exception> thumbnailUnsafeSupplier) {
        this._thumbnailSupplier = () -> {
            try {
                return (ItemExternalReference)thumbnailUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A valid external identifier to reference this display page template.")
    public String getUuid() {
        if (this._uuidSupplier != null) {
            this.uuid = this._uuidSupplier.get();
            this._uuidSupplier = null;
        }
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
        this._uuidSupplier = null;
    }

    @JsonIgnore
    public void setUuid(UnsafeSupplier<String, Exception> uuidUnsafeSupplier) {
        this._uuidSupplier = () -> {
            try {
                return (String)uuidUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DisplayPageTemplate)) {
            return false;
        }
        DisplayPageTemplate displayPageTemplate = (DisplayPageTemplate)object;
        return Objects.equals(this.toString(), displayPageTemplate.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String uuid;
        ItemExternalReference thumbnail;
        DisplayPageTemplateFolder parentFolder;
        PageSpecification[] pageSpecifications;
        String name;
        Boolean markedAsDefault;
        String key;
        Map<String, String> friendlyUrlPath_i18n;
        FriendlyUrlHistory friendlyUrlHistory;
        String externalReferenceCode;
        DisplayPageTemplateSettings displayPageTemplateSettings;
        Date datePublished;
        Date dateModified;
        Date dateCreated;
        String creatorExternalReferenceCode;
        Creator creator;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        ClassSubtypeReference contentTypeReference = this.getContentTypeReference();
        if (contentTypeReference != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentTypeReference\": ");
            sb.append(String.valueOf(contentTypeReference));
        }
        if ((creator = this.getCreator()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)creator);
        }
        if ((creatorExternalReferenceCode = this.getCreatorExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creatorExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(creatorExternalReferenceCode));
            sb.append("\"");
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((datePublished = this.getDatePublished()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"datePublished\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(datePublished));
            sb.append("\"");
        }
        if ((displayPageTemplateSettings = this.getDisplayPageTemplateSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayPageTemplateSettings\": ");
            sb.append(String.valueOf(displayPageTemplateSettings));
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((friendlyUrlHistory = this.getFriendlyUrlHistory()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"friendlyUrlHistory\": ");
            sb.append(String.valueOf(friendlyUrlHistory));
        }
        if ((friendlyUrlPath_i18n = this.getFriendlyUrlPath_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"friendlyUrlPath_i18n\": ");
            sb.append(DisplayPageTemplate._toJSON(friendlyUrlPath_i18n));
        }
        if ((key = this.getKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"key\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(key));
            sb.append("\"");
        }
        if ((markedAsDefault = this.getMarkedAsDefault()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"markedAsDefault\": ");
            sb.append((Object)markedAsDefault);
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(name));
            sb.append("\"");
        }
        if ((pageSpecifications = this.getPageSpecifications()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageSpecifications\": ");
            sb.append("[");
            for (int i = 0; i < pageSpecifications.length; ++i) {
                sb.append(String.valueOf(pageSpecifications[i]));
                if (i + 1 >= pageSpecifications.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((parentFolder = this.getParentFolder()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentFolder\": ");
            sb.append(String.valueOf(parentFolder));
        }
        if ((thumbnail = this.getThumbnail()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"thumbnail\": ");
            sb.append(String.valueOf(thumbnail));
        }
        if ((uuid = this.getUuid()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"uuid\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(uuid));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (DisplayPageTemplate._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(DisplayPageTemplate._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(DisplayPageTemplate._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(DisplayPageTemplate._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

