/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="The page form's configuration.", value="FormConfig")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="FormConfig")
public class FormConfig
implements Serializable {
    @GraphQLField(description="The form reference.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The form reference.") Object formReference;
    @JsonIgnore
    private Supplier<Object> _formReferenceSupplier;
    @GraphQLField(description="The definition for the success message of the form.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The definition for the success message of the form.") Object formSuccessSubmissionResult;
    @JsonIgnore
    private Supplier<Object> _formSuccessSubmissionResultSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected FormType formType;
    @JsonIgnore
    private Supplier<FormType> _formTypeSupplier;
    @GraphQLField(description="The page form's number of steps.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page form's number of steps.") Integer numberOfSteps;
    @JsonIgnore
    private Supplier<Integer> _numberOfStepsSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.FormConfig", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static FormConfig toDTO(String json) {
        return (FormConfig)ObjectMapperUtil.readValue(FormConfig.class, (String)json);
    }

    public static FormConfig unsafeToDTO(String json) {
        return (FormConfig)ObjectMapperUtil.unsafeReadValue(FormConfig.class, (String)json);
    }

    @Schema(description="The form reference.")
    @Valid
    public Object getFormReference() {
        if (this._formReferenceSupplier != null) {
            this.formReference = this._formReferenceSupplier.get();
            this._formReferenceSupplier = null;
        }
        return this.formReference;
    }

    public void setFormReference(Object formReference) {
        this.formReference = formReference;
        this._formReferenceSupplier = null;
    }

    @JsonIgnore
    public void setFormReference(UnsafeSupplier<Object, Exception> formReferenceUnsafeSupplier) {
        this._formReferenceSupplier = () -> {
            try {
                return formReferenceUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The definition for the success message of the form.")
    @Valid
    public Object getFormSuccessSubmissionResult() {
        if (this._formSuccessSubmissionResultSupplier != null) {
            this.formSuccessSubmissionResult = this._formSuccessSubmissionResultSupplier.get();
            this._formSuccessSubmissionResultSupplier = null;
        }
        return this.formSuccessSubmissionResult;
    }

    public void setFormSuccessSubmissionResult(Object formSuccessSubmissionResult) {
        this.formSuccessSubmissionResult = formSuccessSubmissionResult;
        this._formSuccessSubmissionResultSupplier = null;
    }

    @JsonIgnore
    public void setFormSuccessSubmissionResult(UnsafeSupplier<Object, Exception> formSuccessSubmissionResultUnsafeSupplier) {
        this._formSuccessSubmissionResultSupplier = () -> {
            try {
                return formSuccessSubmissionResultUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @JsonGetter(value="formType")
    @Valid
    public FormType getFormType() {
        if (this._formTypeSupplier != null) {
            this.formType = this._formTypeSupplier.get();
            this._formTypeSupplier = null;
        }
        return this.formType;
    }

    @JsonIgnore
    public String getFormTypeAsString() {
        FormType formType = this.getFormType();
        if (formType == null) {
            return null;
        }
        return formType.toString();
    }

    public void setFormType(FormType formType) {
        this.formType = formType;
        this._formTypeSupplier = null;
    }

    @JsonIgnore
    public void setFormType(UnsafeSupplier<FormType, Exception> formTypeUnsafeSupplier) {
        this._formTypeSupplier = () -> {
            try {
                return (FormType)((Object)((Object)formTypeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page form's number of steps.")
    public Integer getNumberOfSteps() {
        if (this._numberOfStepsSupplier != null) {
            this.numberOfSteps = this._numberOfStepsSupplier.get();
            this._numberOfStepsSupplier = null;
        }
        return this.numberOfSteps;
    }

    public void setNumberOfSteps(Integer numberOfSteps) {
        this.numberOfSteps = numberOfSteps;
        this._numberOfStepsSupplier = null;
    }

    @JsonIgnore
    public void setNumberOfSteps(UnsafeSupplier<Integer, Exception> numberOfStepsUnsafeSupplier) {
        this._numberOfStepsSupplier = () -> {
            try {
                return (Integer)numberOfStepsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FormConfig)) {
            return false;
        }
        FormConfig formConfig = (FormConfig)object;
        return Objects.equals(this.toString(), formConfig.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Integer numberOfSteps;
        FormType formType;
        Object formSuccessSubmissionResult;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Object formReference = this.getFormReference();
        if (formReference != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"formReference\": ");
            if (formReference instanceof Map) {
                sb.append((Object)JSONFactoryUtil.createJSONObject((Map)((Map)formReference)));
            } else if (formReference instanceof String) {
                sb.append("\"");
                sb.append(FormConfig._escape((String)formReference));
                sb.append("\"");
            } else {
                sb.append(formReference);
            }
        }
        if ((formSuccessSubmissionResult = this.getFormSuccessSubmissionResult()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"formSuccessSubmissionResult\": ");
            if (formSuccessSubmissionResult instanceof Map) {
                sb.append((Object)JSONFactoryUtil.createJSONObject((Map)((Map)formSuccessSubmissionResult)));
            } else if (formSuccessSubmissionResult instanceof String) {
                sb.append("\"");
                sb.append(FormConfig._escape((String)formSuccessSubmissionResult));
                sb.append("\"");
            } else {
                sb.append(formSuccessSubmissionResult);
            }
        }
        if ((formType = this.getFormType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"formType\": ");
            sb.append("\"");
            sb.append((Object)formType);
            sb.append("\"");
        }
        if ((numberOfSteps = this.getNumberOfSteps()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfSteps\": ");
            sb.append((Object)numberOfSteps);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(FormConfig._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (FormConfig._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(FormConfig._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(FormConfig._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(FormConfig._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="FormType")
    public static enum FormType {
        MULTISTEP("Multistep"),
        SIMPLE("Simple");

        private final String _value;

        @JsonCreator
        public static FormType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (FormType formType : FormType.values()) {
                if (!Objects.equals(formType.getValue(), value)) continue;
                return formType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private FormType(String value) {
            this._value = value;
        }
    }
}

