/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents the Adaptive Media fragment image configuration for different viewports.", value="Config")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Config")
public class Config
implements Serializable {
    @GraphQLField(description="The landscape mobile configuration of the fragment image.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The landscape mobile configuration of the fragment image.") String landscapeMobile;
    @JsonIgnore
    private Supplier<String> _landscapeMobileSupplier;
    @GraphQLField(description="The portrait mobile configuration of the fragment image.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The portrait mobile configuration of the fragment image.") String portraitMobile;
    @JsonIgnore
    private Supplier<String> _portraitMobileSupplier;
    @GraphQLField(description="The tablet configuration of the fragment image.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The tablet configuration of the fragment image.") String tablet;
    @JsonIgnore
    private Supplier<String> _tabletSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.Config", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Config toDTO(String json) {
        return (Config)ObjectMapperUtil.readValue(Config.class, (String)json);
    }

    public static Config unsafeToDTO(String json) {
        return (Config)ObjectMapperUtil.unsafeReadValue(Config.class, (String)json);
    }

    @Schema(description="The landscape mobile configuration of the fragment image.")
    public String getLandscapeMobile() {
        if (this._landscapeMobileSupplier != null) {
            this.landscapeMobile = this._landscapeMobileSupplier.get();
            this._landscapeMobileSupplier = null;
        }
        return this.landscapeMobile;
    }

    public void setLandscapeMobile(String landscapeMobile) {
        this.landscapeMobile = landscapeMobile;
        this._landscapeMobileSupplier = null;
    }

    @JsonIgnore
    public void setLandscapeMobile(UnsafeSupplier<String, Exception> landscapeMobileUnsafeSupplier) {
        this._landscapeMobileSupplier = () -> {
            try {
                return (String)landscapeMobileUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The portrait mobile configuration of the fragment image.")
    public String getPortraitMobile() {
        if (this._portraitMobileSupplier != null) {
            this.portraitMobile = this._portraitMobileSupplier.get();
            this._portraitMobileSupplier = null;
        }
        return this.portraitMobile;
    }

    public void setPortraitMobile(String portraitMobile) {
        this.portraitMobile = portraitMobile;
        this._portraitMobileSupplier = null;
    }

    @JsonIgnore
    public void setPortraitMobile(UnsafeSupplier<String, Exception> portraitMobileUnsafeSupplier) {
        this._portraitMobileSupplier = () -> {
            try {
                return (String)portraitMobileUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The tablet configuration of the fragment image.")
    public String getTablet() {
        if (this._tabletSupplier != null) {
            this.tablet = this._tabletSupplier.get();
            this._tabletSupplier = null;
        }
        return this.tablet;
    }

    public void setTablet(String tablet) {
        this.tablet = tablet;
        this._tabletSupplier = null;
    }

    @JsonIgnore
    public void setTablet(UnsafeSupplier<String, Exception> tabletUnsafeSupplier) {
        this._tabletSupplier = () -> {
            try {
                return (String)tabletUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Config)) {
            return false;
        }
        Config config = (Config)object;
        return Objects.equals(this.toString(), config.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String tablet;
        String portraitMobile;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String landscapeMobile = this.getLandscapeMobile();
        if (landscapeMobile != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"landscapeMobile\": ");
            sb.append("\"");
            sb.append(Config._escape(landscapeMobile));
            sb.append("\"");
        }
        if ((portraitMobile = this.getPortraitMobile()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"portraitMobile\": ");
            sb.append("\"");
            sb.append(Config._escape(portraitMobile));
            sb.append("\"");
        }
        if ((tablet = this.getTablet()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"tablet\": ");
            sb.append("\"");
            sb.append(Config._escape(tablet));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Config._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Config._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Config._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Config._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Config._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

