/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.site.dto.v1_0.ClassNameReference;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="The page collection's reference.", value="CollectionReference")
@JsonFilter(value="Liferay.Vulcan")
@JsonSubTypes(value={@JsonSubTypes.Type(name="Collection", value=ItemExternalReference.class), @JsonSubTypes.Type(name="CollectionProvider", value=ClassNameReference.class)})
@JsonTypeInfo(include=JsonTypeInfo.As.PROPERTY, property="collectionType", use=JsonTypeInfo.Id.NAME, visible=true)
@XmlRootElement(name="CollectionReference")
public abstract class CollectionReference
implements Serializable {
    @GraphQLField(description="The collection's type (Collection, CollectionProvider).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The collection's type (Collection, CollectionProvider).") CollectionType collectionType;
    @JsonIgnore
    private Supplier<CollectionType> _collectionTypeSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.CollectionReference", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static CollectionReference toDTO(String json) {
        return (CollectionReference)ObjectMapperUtil.readValue(CollectionReference.class, (String)json);
    }

    public static CollectionReference unsafeToDTO(String json) {
        return (CollectionReference)ObjectMapperUtil.unsafeReadValue(CollectionReference.class, (String)json);
    }

    @JsonGetter(value="collectionType")
    @Schema(description="The collection's type (Collection, CollectionProvider).")
    @Valid
    public CollectionType getCollectionType() {
        if (this._collectionTypeSupplier != null) {
            this.collectionType = this._collectionTypeSupplier.get();
            this._collectionTypeSupplier = null;
        }
        return this.collectionType;
    }

    @JsonIgnore
    public String getCollectionTypeAsString() {
        CollectionType collectionType = this.getCollectionType();
        if (collectionType == null) {
            return null;
        }
        return collectionType.toString();
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
        this._collectionTypeSupplier = null;
    }

    @JsonIgnore
    public void setCollectionType(UnsafeSupplier<CollectionType, Exception> collectionTypeUnsafeSupplier) {
        this._collectionTypeSupplier = () -> {
            try {
                return (CollectionType)((Object)((Object)collectionTypeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CollectionReference)) {
            return false;
        }
        CollectionReference collectionReference = (CollectionReference)object;
        return Objects.equals(this.toString(), collectionReference.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        CollectionType collectionType = this.getCollectionType();
        if (collectionType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"collectionType\": ");
            sb.append("\"");
            sb.append((Object)collectionType);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(CollectionReference._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (CollectionReference._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(CollectionReference._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(CollectionReference._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(CollectionReference._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="CollectionType")
    public static enum CollectionType {
        COLLECTION("Collection"),
        COLLECTION_PROVIDER("CollectionProvider");

        private final String _value;

        @JsonCreator
        public static CollectionType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (CollectionType collectionType : CollectionType.values()) {
                if (!Objects.equals(collectionType.getValue(), value)) continue;
                return collectionType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private CollectionType(String value) {
            this._value = value;
        }
    }
}

