/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.site.dto.v1_0.FragmentInlineValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="The definition of a submission result of type message.", value="MessageFormSubmissionResult")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="MessageFormSubmissionResult")
public class MessageFormSubmissionResult
implements Serializable {
    @GraphQLField(description="The localized submission of message type.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized submission of message type.") FragmentInlineValue message;
    @JsonIgnore
    private Supplier<FragmentInlineValue> _messageSupplier;
    @GraphQLField(description="The message form submission type (embedded, none).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The message form submission type (embedded, none).") MessageType messageType;
    @JsonIgnore
    private Supplier<MessageType> _messageTypeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean showNotification;
    @JsonIgnore
    private Supplier<Boolean> _showNotificationSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.MessageFormSubmissionResult", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static MessageFormSubmissionResult toDTO(String json) {
        return (MessageFormSubmissionResult)ObjectMapperUtil.readValue(MessageFormSubmissionResult.class, (String)json);
    }

    public static MessageFormSubmissionResult unsafeToDTO(String json) {
        return (MessageFormSubmissionResult)ObjectMapperUtil.unsafeReadValue(MessageFormSubmissionResult.class, (String)json);
    }

    @Schema(description="The localized submission of message type.")
    @Valid
    public FragmentInlineValue getMessage() {
        if (this._messageSupplier != null) {
            this.message = this._messageSupplier.get();
            this._messageSupplier = null;
        }
        return this.message;
    }

    public void setMessage(FragmentInlineValue message) {
        this.message = message;
        this._messageSupplier = null;
    }

    @JsonIgnore
    public void setMessage(UnsafeSupplier<FragmentInlineValue, Exception> messageUnsafeSupplier) {
        this._messageSupplier = () -> {
            try {
                return (FragmentInlineValue)messageUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @JsonGetter(value="messageType")
    @Schema(description="The message form submission type (embedded, none).")
    @Valid
    public MessageType getMessageType() {
        if (this._messageTypeSupplier != null) {
            this.messageType = this._messageTypeSupplier.get();
            this._messageTypeSupplier = null;
        }
        return this.messageType;
    }

    @JsonIgnore
    public String getMessageTypeAsString() {
        MessageType messageType = this.getMessageType();
        if (messageType == null) {
            return null;
        }
        return messageType.toString();
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
        this._messageTypeSupplier = null;
    }

    @JsonIgnore
    public void setMessageType(UnsafeSupplier<MessageType, Exception> messageTypeUnsafeSupplier) {
        this._messageTypeSupplier = () -> {
            try {
                return (MessageType)((Object)((Object)messageTypeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Boolean getShowNotification() {
        if (this._showNotificationSupplier != null) {
            this.showNotification = this._showNotificationSupplier.get();
            this._showNotificationSupplier = null;
        }
        return this.showNotification;
    }

    public void setShowNotification(Boolean showNotification) {
        this.showNotification = showNotification;
        this._showNotificationSupplier = null;
    }

    @JsonIgnore
    public void setShowNotification(UnsafeSupplier<Boolean, Exception> showNotificationUnsafeSupplier) {
        this._showNotificationSupplier = () -> {
            try {
                return (Boolean)showNotificationUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFormSubmissionResult)) {
            return false;
        }
        MessageFormSubmissionResult messageFormSubmissionResult = (MessageFormSubmissionResult)object;
        return Objects.equals(this.toString(), messageFormSubmissionResult.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Boolean showNotification;
        MessageType messageType;
        StringBundler sb = new StringBundler();
        sb.append("{");
        FragmentInlineValue message = this.getMessage();
        if (message != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"message\": ");
            sb.append(String.valueOf(message));
        }
        if ((messageType = this.getMessageType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"messageType\": ");
            sb.append("\"");
            sb.append((Object)messageType);
            sb.append("\"");
        }
        if ((showNotification = this.getShowNotification()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"showNotification\": ");
            sb.append((Object)showNotification);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(MessageFormSubmissionResult._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (MessageFormSubmissionResult._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(MessageFormSubmissionResult._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(MessageFormSubmissionResult._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(MessageFormSubmissionResult._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="MessageType")
    public static enum MessageType {
        EMBEDDED("Embedded"),
        NONE("None");

        private final String _value;

        @JsonCreator
        public static MessageType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (MessageType messageType : MessageType.values()) {
                if (!Objects.equals(messageType.getValue(), value)) continue;
                return messageType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private MessageType(String value) {
            this._value = value;
        }
    }
}

