/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.OpenGraphSettings;
import com.liferay.headless.admin.site.dto.v1_0.SEOSettings;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="The settings of a Display Page Template.", value="DisplayPageTemplateSettings")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="DisplayPageTemplateSettings")
public class DisplayPageTemplateSettings
implements Serializable {
    @GraphQLField(description="The display page template's Open Graph settings.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's Open Graph settings.") OpenGraphSettings openGraphSettings;
    @JsonIgnore
    private Supplier<OpenGraphSettings> _openGraphSettingsSupplier;
    @GraphQLField(description="The display page template's SEO settings.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's SEO settings.") SEOSettings seoSettings;
    @JsonIgnore
    private Supplier<SEOSettings> _seoSettingsSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateSettings", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static DisplayPageTemplateSettings toDTO(String json) {
        return (DisplayPageTemplateSettings)ObjectMapperUtil.readValue(DisplayPageTemplateSettings.class, (String)json);
    }

    public static DisplayPageTemplateSettings unsafeToDTO(String json) {
        return (DisplayPageTemplateSettings)ObjectMapperUtil.unsafeReadValue(DisplayPageTemplateSettings.class, (String)json);
    }

    @Schema(description="The display page template's Open Graph settings.")
    @Valid
    public OpenGraphSettings getOpenGraphSettings() {
        if (this._openGraphSettingsSupplier != null) {
            this.openGraphSettings = this._openGraphSettingsSupplier.get();
            this._openGraphSettingsSupplier = null;
        }
        return this.openGraphSettings;
    }

    public void setOpenGraphSettings(OpenGraphSettings openGraphSettings) {
        this.openGraphSettings = openGraphSettings;
        this._openGraphSettingsSupplier = null;
    }

    @JsonIgnore
    public void setOpenGraphSettings(UnsafeSupplier<OpenGraphSettings, Exception> openGraphSettingsUnsafeSupplier) {
        this._openGraphSettingsSupplier = () -> {
            try {
                return (OpenGraphSettings)openGraphSettingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The display page template's SEO settings.")
    @Valid
    public SEOSettings getSeoSettings() {
        if (this._seoSettingsSupplier != null) {
            this.seoSettings = this._seoSettingsSupplier.get();
            this._seoSettingsSupplier = null;
        }
        return this.seoSettings;
    }

    public void setSeoSettings(SEOSettings seoSettings) {
        this.seoSettings = seoSettings;
        this._seoSettingsSupplier = null;
    }

    @JsonIgnore
    public void setSeoSettings(UnsafeSupplier<SEOSettings, Exception> seoSettingsUnsafeSupplier) {
        this._seoSettingsSupplier = () -> {
            try {
                return (SEOSettings)seoSettingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DisplayPageTemplateSettings)) {
            return false;
        }
        DisplayPageTemplateSettings displayPageTemplateSettings = (DisplayPageTemplateSettings)object;
        return Objects.equals(this.toString(), displayPageTemplateSettings.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        SEOSettings seoSettings;
        StringBundler sb = new StringBundler();
        sb.append("{");
        OpenGraphSettings openGraphSettings = this.getOpenGraphSettings();
        if (openGraphSettings != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"openGraphSettings\": ");
            sb.append(String.valueOf(openGraphSettings));
        }
        if ((seoSettings = this.getSeoSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"seoSettings\": ");
            sb.append(String.valueOf(seoSettings));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(DisplayPageTemplateSettings._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (DisplayPageTemplateSettings._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(DisplayPageTemplateSettings._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(DisplayPageTemplateSettings._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(DisplayPageTemplateSettings._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

