/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.site.dto.v1_0.CollectionReference;
import com.liferay.headless.admin.site.dto.v1_0.CollectionViewport;
import com.liferay.headless.admin.site.dto.v1_0.EmptyCollectionConfig;
import com.liferay.headless.admin.site.dto.v1_0.FragmentStyle;
import com.liferay.headless.admin.site.dto.v1_0.FragmentViewport;
import com.liferay.headless.admin.site.dto.v1_0.Layout;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="The definition of a Page Collection.", value="PageCollectionDefinition")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="PageCollectionDefinition")
public class PageCollectionDefinition
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected CollectionReference collectionReference;
    @JsonIgnore
    private Supplier<CollectionReference> _collectionReferenceSupplier;
    @GraphQLField(description="A list of viewports of the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of viewports of the page collection.") CollectionViewport[] collectionViewports;
    @JsonIgnore
    private Supplier<CollectionViewport[]> _collectionViewportsSupplier;
    @GraphQLField(description="Whether to show all items when pagination is disabled.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Whether to show all items when pagination is disabled.") Boolean displayAllItems;
    @JsonIgnore
    private Supplier<Boolean> _displayAllItemsSupplier;
    @GraphQLField(description="Whether to show all pages when pagination is enabled.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Whether to show all pages when pagination is enabled.") Boolean displayAllPages;
    @JsonIgnore
    private Supplier<Boolean> _displayAllPagesSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected EmptyCollectionConfig emptyCollectionConfig;
    @JsonIgnore
    private Supplier<EmptyCollectionConfig> _emptyCollectionConfigSupplier;
    @GraphQLField(description="The fragment style of the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment style of the page collection.") FragmentStyle fragmentStyle;
    @JsonIgnore
    private Supplier<FragmentStyle> _fragmentStyleSupplier;
    @GraphQLField(description="The fragment viewports of the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment viewports of the page collection.") FragmentViewport[] fragmentViewports;
    @JsonIgnore
    private Supplier<FragmentViewport[]> _fragmentViewportsSupplier;
    @GraphQLField(description="the page collection's layout.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="the page collection's layout.") Layout layout;
    @JsonIgnore
    private Supplier<Layout> _layoutSupplier;
    @GraphQLField(description="The style of a list of items in the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The style of a list of items in the page collection.") String listItemStyle;
    @JsonIgnore
    private Supplier<String> _listItemStyleSupplier;
    @GraphQLField(description="The style of a list in the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The style of a list in the page collection.") String listStyle;
    @JsonIgnore
    private Supplier<String> _listStyleSupplier;
    @GraphQLField(description="The custom name of a Page Collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The custom name of a Page Collection.") String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField(description="The number of columns in the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The number of columns in the page collection.") Integer numberOfColumns;
    @JsonIgnore
    private Supplier<Integer> _numberOfColumnsSupplier;
    @GraphQLField(description="The maximum number of items to display in the page collection when pagination is disabled.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The maximum number of items to display in the page collection when pagination is disabled.") Integer numberOfItems;
    @JsonIgnore
    private Supplier<Integer> _numberOfItemsSupplier;
    @GraphQLField(description="The number of items per page in the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The number of items per page in the page collection.") Integer numberOfItemsPerPage;
    @JsonIgnore
    private Supplier<Integer> _numberOfItemsPerPageSupplier;
    @GraphQLField(description="The maximum number of pages to show when pagination is enabled.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The maximum number of pages to show when pagination is enabled.") Integer numberOfPages;
    @JsonIgnore
    private Supplier<Integer> _numberOfPagesSupplier;
    @GraphQLField(description="The type of pagination.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The type of pagination.") PaginationType paginationType;
    @JsonIgnore
    private Supplier<PaginationType> _paginationTypeSupplier;
    @GraphQLField(description="The page collection's template key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page collection's template key.") String templateKey;
    @JsonIgnore
    private Supplier<String> _templateKeySupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.PageCollectionDefinition", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static PageCollectionDefinition toDTO(String json) {
        return (PageCollectionDefinition)ObjectMapperUtil.readValue(PageCollectionDefinition.class, (String)json);
    }

    public static PageCollectionDefinition unsafeToDTO(String json) {
        return (PageCollectionDefinition)ObjectMapperUtil.unsafeReadValue(PageCollectionDefinition.class, (String)json);
    }

    @Schema
    @Valid
    public CollectionReference getCollectionReference() {
        if (this._collectionReferenceSupplier != null) {
            this.collectionReference = this._collectionReferenceSupplier.get();
            this._collectionReferenceSupplier = null;
        }
        return this.collectionReference;
    }

    public void setCollectionReference(CollectionReference collectionReference) {
        this.collectionReference = collectionReference;
        this._collectionReferenceSupplier = null;
    }

    @JsonIgnore
    public void setCollectionReference(UnsafeSupplier<CollectionReference, Exception> collectionReferenceUnsafeSupplier) {
        this._collectionReferenceSupplier = () -> {
            try {
                return (CollectionReference)collectionReferenceUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A list of viewports of the page collection.")
    @Valid
    public CollectionViewport[] getCollectionViewports() {
        if (this._collectionViewportsSupplier != null) {
            this.collectionViewports = this._collectionViewportsSupplier.get();
            this._collectionViewportsSupplier = null;
        }
        return this.collectionViewports;
    }

    public void setCollectionViewports(CollectionViewport[] collectionViewports) {
        this.collectionViewports = collectionViewports;
        this._collectionViewportsSupplier = null;
    }

    @JsonIgnore
    public void setCollectionViewports(UnsafeSupplier<CollectionViewport[], Exception> collectionViewportsUnsafeSupplier) {
        this._collectionViewportsSupplier = () -> {
            try {
                return (CollectionViewport[])collectionViewportsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Whether to show all items when pagination is disabled.")
    public Boolean getDisplayAllItems() {
        if (this._displayAllItemsSupplier != null) {
            this.displayAllItems = this._displayAllItemsSupplier.get();
            this._displayAllItemsSupplier = null;
        }
        return this.displayAllItems;
    }

    public void setDisplayAllItems(Boolean displayAllItems) {
        this.displayAllItems = displayAllItems;
        this._displayAllItemsSupplier = null;
    }

    @JsonIgnore
    public void setDisplayAllItems(UnsafeSupplier<Boolean, Exception> displayAllItemsUnsafeSupplier) {
        this._displayAllItemsSupplier = () -> {
            try {
                return (Boolean)displayAllItemsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Whether to show all pages when pagination is enabled.")
    public Boolean getDisplayAllPages() {
        if (this._displayAllPagesSupplier != null) {
            this.displayAllPages = this._displayAllPagesSupplier.get();
            this._displayAllPagesSupplier = null;
        }
        return this.displayAllPages;
    }

    public void setDisplayAllPages(Boolean displayAllPages) {
        this.displayAllPages = displayAllPages;
        this._displayAllPagesSupplier = null;
    }

    @JsonIgnore
    public void setDisplayAllPages(UnsafeSupplier<Boolean, Exception> displayAllPagesUnsafeSupplier) {
        this._displayAllPagesSupplier = () -> {
            try {
                return (Boolean)displayAllPagesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public EmptyCollectionConfig getEmptyCollectionConfig() {
        if (this._emptyCollectionConfigSupplier != null) {
            this.emptyCollectionConfig = this._emptyCollectionConfigSupplier.get();
            this._emptyCollectionConfigSupplier = null;
        }
        return this.emptyCollectionConfig;
    }

    public void setEmptyCollectionConfig(EmptyCollectionConfig emptyCollectionConfig) {
        this.emptyCollectionConfig = emptyCollectionConfig;
        this._emptyCollectionConfigSupplier = null;
    }

    @JsonIgnore
    public void setEmptyCollectionConfig(UnsafeSupplier<EmptyCollectionConfig, Exception> emptyCollectionConfigUnsafeSupplier) {
        this._emptyCollectionConfigSupplier = () -> {
            try {
                return (EmptyCollectionConfig)emptyCollectionConfigUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The fragment style of the page collection.")
    @Valid
    public FragmentStyle getFragmentStyle() {
        if (this._fragmentStyleSupplier != null) {
            this.fragmentStyle = this._fragmentStyleSupplier.get();
            this._fragmentStyleSupplier = null;
        }
        return this.fragmentStyle;
    }

    public void setFragmentStyle(FragmentStyle fragmentStyle) {
        this.fragmentStyle = fragmentStyle;
        this._fragmentStyleSupplier = null;
    }

    @JsonIgnore
    public void setFragmentStyle(UnsafeSupplier<FragmentStyle, Exception> fragmentStyleUnsafeSupplier) {
        this._fragmentStyleSupplier = () -> {
            try {
                return (FragmentStyle)fragmentStyleUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The fragment viewports of the page collection.")
    @Valid
    public FragmentViewport[] getFragmentViewports() {
        if (this._fragmentViewportsSupplier != null) {
            this.fragmentViewports = this._fragmentViewportsSupplier.get();
            this._fragmentViewportsSupplier = null;
        }
        return this.fragmentViewports;
    }

    public void setFragmentViewports(FragmentViewport[] fragmentViewports) {
        this.fragmentViewports = fragmentViewports;
        this._fragmentViewportsSupplier = null;
    }

    @JsonIgnore
    public void setFragmentViewports(UnsafeSupplier<FragmentViewport[], Exception> fragmentViewportsUnsafeSupplier) {
        this._fragmentViewportsSupplier = () -> {
            try {
                return (FragmentViewport[])fragmentViewportsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="the page collection's layout.")
    @Valid
    public Layout getLayout() {
        if (this._layoutSupplier != null) {
            this.layout = this._layoutSupplier.get();
            this._layoutSupplier = null;
        }
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
        this._layoutSupplier = null;
    }

    @JsonIgnore
    public void setLayout(UnsafeSupplier<Layout, Exception> layoutUnsafeSupplier) {
        this._layoutSupplier = () -> {
            try {
                return (Layout)layoutUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The style of a list of items in the page collection.")
    public String getListItemStyle() {
        if (this._listItemStyleSupplier != null) {
            this.listItemStyle = this._listItemStyleSupplier.get();
            this._listItemStyleSupplier = null;
        }
        return this.listItemStyle;
    }

    public void setListItemStyle(String listItemStyle) {
        this.listItemStyle = listItemStyle;
        this._listItemStyleSupplier = null;
    }

    @JsonIgnore
    public void setListItemStyle(UnsafeSupplier<String, Exception> listItemStyleUnsafeSupplier) {
        this._listItemStyleSupplier = () -> {
            try {
                return (String)listItemStyleUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The style of a list in the page collection.")
    public String getListStyle() {
        if (this._listStyleSupplier != null) {
            this.listStyle = this._listStyleSupplier.get();
            this._listStyleSupplier = null;
        }
        return this.listStyle;
    }

    public void setListStyle(String listStyle) {
        this.listStyle = listStyle;
        this._listStyleSupplier = null;
    }

    @JsonIgnore
    public void setListStyle(UnsafeSupplier<String, Exception> listStyleUnsafeSupplier) {
        this._listStyleSupplier = () -> {
            try {
                return (String)listStyleUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The custom name of a Page Collection.")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The number of columns in the page collection.")
    public Integer getNumberOfColumns() {
        if (this._numberOfColumnsSupplier != null) {
            this.numberOfColumns = this._numberOfColumnsSupplier.get();
            this._numberOfColumnsSupplier = null;
        }
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(Integer numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
        this._numberOfColumnsSupplier = null;
    }

    @JsonIgnore
    public void setNumberOfColumns(UnsafeSupplier<Integer, Exception> numberOfColumnsUnsafeSupplier) {
        this._numberOfColumnsSupplier = () -> {
            try {
                return (Integer)numberOfColumnsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The maximum number of items to display in the page collection when pagination is disabled.")
    public Integer getNumberOfItems() {
        if (this._numberOfItemsSupplier != null) {
            this.numberOfItems = this._numberOfItemsSupplier.get();
            this._numberOfItemsSupplier = null;
        }
        return this.numberOfItems;
    }

    public void setNumberOfItems(Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        this._numberOfItemsSupplier = null;
    }

    @JsonIgnore
    public void setNumberOfItems(UnsafeSupplier<Integer, Exception> numberOfItemsUnsafeSupplier) {
        this._numberOfItemsSupplier = () -> {
            try {
                return (Integer)numberOfItemsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The number of items per page in the page collection.")
    public Integer getNumberOfItemsPerPage() {
        if (this._numberOfItemsPerPageSupplier != null) {
            this.numberOfItemsPerPage = this._numberOfItemsPerPageSupplier.get();
            this._numberOfItemsPerPageSupplier = null;
        }
        return this.numberOfItemsPerPage;
    }

    public void setNumberOfItemsPerPage(Integer numberOfItemsPerPage) {
        this.numberOfItemsPerPage = numberOfItemsPerPage;
        this._numberOfItemsPerPageSupplier = null;
    }

    @JsonIgnore
    public void setNumberOfItemsPerPage(UnsafeSupplier<Integer, Exception> numberOfItemsPerPageUnsafeSupplier) {
        this._numberOfItemsPerPageSupplier = () -> {
            try {
                return (Integer)numberOfItemsPerPageUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The maximum number of pages to show when pagination is enabled.")
    public Integer getNumberOfPages() {
        if (this._numberOfPagesSupplier != null) {
            this.numberOfPages = this._numberOfPagesSupplier.get();
            this._numberOfPagesSupplier = null;
        }
        return this.numberOfPages;
    }

    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
        this._numberOfPagesSupplier = null;
    }

    @JsonIgnore
    public void setNumberOfPages(UnsafeSupplier<Integer, Exception> numberOfPagesUnsafeSupplier) {
        this._numberOfPagesSupplier = () -> {
            try {
                return (Integer)numberOfPagesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @JsonGetter(value="paginationType")
    @Schema(description="The type of pagination.")
    @Valid
    public PaginationType getPaginationType() {
        if (this._paginationTypeSupplier != null) {
            this.paginationType = this._paginationTypeSupplier.get();
            this._paginationTypeSupplier = null;
        }
        return this.paginationType;
    }

    @JsonIgnore
    public String getPaginationTypeAsString() {
        PaginationType paginationType = this.getPaginationType();
        if (paginationType == null) {
            return null;
        }
        return paginationType.toString();
    }

    public void setPaginationType(PaginationType paginationType) {
        this.paginationType = paginationType;
        this._paginationTypeSupplier = null;
    }

    @JsonIgnore
    public void setPaginationType(UnsafeSupplier<PaginationType, Exception> paginationTypeUnsafeSupplier) {
        this._paginationTypeSupplier = () -> {
            try {
                return (PaginationType)((Object)((Object)paginationTypeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page collection's template key.")
    public String getTemplateKey() {
        if (this._templateKeySupplier != null) {
            this.templateKey = this._templateKeySupplier.get();
            this._templateKeySupplier = null;
        }
        return this.templateKey;
    }

    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
        this._templateKeySupplier = null;
    }

    @JsonIgnore
    public void setTemplateKey(UnsafeSupplier<String, Exception> templateKeyUnsafeSupplier) {
        this._templateKeySupplier = () -> {
            try {
                return (String)templateKeyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PageCollectionDefinition)) {
            return false;
        }
        PageCollectionDefinition pageCollectionDefinition = (PageCollectionDefinition)object;
        return Objects.equals(this.toString(), pageCollectionDefinition.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String templateKey;
        PaginationType paginationType;
        Integer numberOfPages;
        Integer numberOfItemsPerPage;
        Integer numberOfItems;
        Integer numberOfColumns;
        String name;
        String listStyle;
        String listItemStyle;
        Layout layout;
        FragmentViewport[] fragmentViewports;
        FragmentStyle fragmentStyle;
        EmptyCollectionConfig emptyCollectionConfig;
        Boolean displayAllPages;
        Boolean displayAllItems;
        CollectionViewport[] collectionViewports;
        StringBundler sb = new StringBundler();
        sb.append("{");
        CollectionReference collectionReference = this.getCollectionReference();
        if (collectionReference != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"collectionReference\": ");
            sb.append(String.valueOf(collectionReference));
        }
        if ((collectionViewports = this.getCollectionViewports()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"collectionViewports\": ");
            sb.append("[");
            for (int i = 0; i < collectionViewports.length; ++i) {
                sb.append(String.valueOf(collectionViewports[i]));
                if (i + 1 >= collectionViewports.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((displayAllItems = this.getDisplayAllItems()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayAllItems\": ");
            sb.append((Object)displayAllItems);
        }
        if ((displayAllPages = this.getDisplayAllPages()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayAllPages\": ");
            sb.append((Object)displayAllPages);
        }
        if ((emptyCollectionConfig = this.getEmptyCollectionConfig()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"emptyCollectionConfig\": ");
            sb.append(String.valueOf(emptyCollectionConfig));
        }
        if ((fragmentStyle = this.getFragmentStyle()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragmentStyle\": ");
            sb.append(String.valueOf(fragmentStyle));
        }
        if ((fragmentViewports = this.getFragmentViewports()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragmentViewports\": ");
            sb.append("[");
            for (int i = 0; i < fragmentViewports.length; ++i) {
                sb.append(String.valueOf(fragmentViewports[i]));
                if (i + 1 >= fragmentViewports.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((layout = this.getLayout()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"layout\": ");
            sb.append(String.valueOf(layout));
        }
        if ((listItemStyle = this.getListItemStyle()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"listItemStyle\": ");
            sb.append("\"");
            sb.append(PageCollectionDefinition._escape(listItemStyle));
            sb.append("\"");
        }
        if ((listStyle = this.getListStyle()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"listStyle\": ");
            sb.append("\"");
            sb.append(PageCollectionDefinition._escape(listStyle));
            sb.append("\"");
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(PageCollectionDefinition._escape(name));
            sb.append("\"");
        }
        if ((numberOfColumns = this.getNumberOfColumns()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfColumns\": ");
            sb.append((Object)numberOfColumns);
        }
        if ((numberOfItems = this.getNumberOfItems()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfItems\": ");
            sb.append((Object)numberOfItems);
        }
        if ((numberOfItemsPerPage = this.getNumberOfItemsPerPage()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfItemsPerPage\": ");
            sb.append((Object)numberOfItemsPerPage);
        }
        if ((numberOfPages = this.getNumberOfPages()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfPages\": ");
            sb.append((Object)numberOfPages);
        }
        if ((paginationType = this.getPaginationType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"paginationType\": ");
            sb.append("\"");
            sb.append((Object)paginationType);
            sb.append("\"");
        }
        if ((templateKey = this.getTemplateKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"templateKey\": ");
            sb.append("\"");
            sb.append(PageCollectionDefinition._escape(templateKey));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(PageCollectionDefinition._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (PageCollectionDefinition._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(PageCollectionDefinition._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(PageCollectionDefinition._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(PageCollectionDefinition._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="PaginationType")
    public static enum PaginationType {
        NONE("None"),
        NUMERIC("Numeric"),
        SIMPLE("Simple");

        private final String _value;

        @JsonCreator
        public static PaginationType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (PaginationType paginationType : PaginationType.values()) {
                if (!Objects.equals(paginationType.getValue(), value)) continue;
                return paginationType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private PaginationType(String value) {
            this._value = value;
        }
    }
}

