/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Type-specific settings for a \"URL\" navigation menu item type.", value="URLNavigationMenuItemSettings")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="URLNavigationMenuItemSettings")
public class URLNavigationMenuItemSettings
implements Serializable {
    @GraphQLField(description="The URL that this navigation menu item will take the user to.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The URL that this navigation menu item will take the user to.") String url;
    @JsonIgnore
    private Supplier<String> _urlSupplier;
    @GraphQLField(description="Whether the target URL will open in a new tab instead of the same tab.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Whether the target URL will open in a new tab instead of the same tab.") Boolean useNewTab;
    @JsonIgnore
    private Supplier<Boolean> _useNewTabSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.URLNavigationMenuItemSettings", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static URLNavigationMenuItemSettings toDTO(String json) {
        return (URLNavigationMenuItemSettings)ObjectMapperUtil.readValue(URLNavigationMenuItemSettings.class, (String)json);
    }

    public static URLNavigationMenuItemSettings unsafeToDTO(String json) {
        return (URLNavigationMenuItemSettings)ObjectMapperUtil.unsafeReadValue(URLNavigationMenuItemSettings.class, (String)json);
    }

    @Schema(description="The URL that this navigation menu item will take the user to.")
    public String getUrl() {
        if (this._urlSupplier != null) {
            this.url = this._urlSupplier.get();
            this._urlSupplier = null;
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this._urlSupplier = null;
    }

    @JsonIgnore
    public void setUrl(UnsafeSupplier<String, Exception> urlUnsafeSupplier) {
        this._urlSupplier = () -> {
            try {
                return (String)urlUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Whether the target URL will open in a new tab instead of the same tab.")
    public Boolean getUseNewTab() {
        if (this._useNewTabSupplier != null) {
            this.useNewTab = this._useNewTabSupplier.get();
            this._useNewTabSupplier = null;
        }
        return this.useNewTab;
    }

    public void setUseNewTab(Boolean useNewTab) {
        this.useNewTab = useNewTab;
        this._useNewTabSupplier = null;
    }

    @JsonIgnore
    public void setUseNewTab(UnsafeSupplier<Boolean, Exception> useNewTabUnsafeSupplier) {
        this._useNewTabSupplier = () -> {
            try {
                return (Boolean)useNewTabUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof URLNavigationMenuItemSettings)) {
            return false;
        }
        URLNavigationMenuItemSettings urlNavigationMenuItemSettings = (URLNavigationMenuItemSettings)object;
        return Objects.equals(this.toString(), urlNavigationMenuItemSettings.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Boolean useNewTab;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String url = this.getUrl();
        if (url != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"url\": ");
            sb.append("\"");
            sb.append(URLNavigationMenuItemSettings._escape(url));
            sb.append("\"");
        }
        if ((useNewTab = this.getUseNewTab()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"useNewTab\": ");
            sb.append((Object)useNewTab);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(URLNavigationMenuItemSettings._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (URLNavigationMenuItemSettings._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(URLNavigationMenuItemSettings._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(URLNavigationMenuItemSettings._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(URLNavigationMenuItemSettings._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

