/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.custom.field.CustomField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Represents a navigation menu item.", value="NavigationMenuItem")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="NavigationMenuItem")
public class NavigationMenuItem
implements Serializable {
    @GraphQLField(description="The list of languages the navigation menu item has a translation for.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The list of languages the navigation menu item has a translation for.") String[] availableLanguages;
    @JsonIgnore
    private Supplier<String[]> _availableLanguagesSupplier;
    @GraphQLField(description="The navigation menu item's creator. It is not returned by default. It can be embedded via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The navigation menu item's creator. It is not returned by default. It can be embedded via nestedFields.") Creator creator;
    @JsonIgnore
    private Supplier<Creator> _creatorSupplier;
    @GraphQLField(description="A list of the custom fields associated with the navigation menu item.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of the custom fields associated with the navigation menu item.") CustomField[] customFields;
    @JsonIgnore
    private Supplier<CustomField[]> _customFieldsSupplier;
    @GraphQLField(description="The navigation menu item's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The navigation menu item's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The last time the navigation menu item changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The last time the navigation menu item changed.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String defaultLanguageId;
    @JsonIgnore
    private Supplier<String> _defaultLanguageIdSupplier;
    @GraphQLField(description="The icon that will be displayed next to this navigation menu item.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The icon that will be displayed next to this navigation menu item.") String displayIcon;
    @JsonIgnore
    private Supplier<String> _displayIconSupplier;
    @GraphQLField(description="The navigation menu item's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The navigation menu item's external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The navigation menu item's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The navigation menu item's ID.") Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField(description="The navigation menu item's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The navigation menu item's name.") String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField(description="The localized navigation menu item's names.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized navigation menu item's names.") Map<String, String> name_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _name_i18nSupplier;
    @GraphQLField(description="The type-specific settings (i.e. typeSettings) for the navigation menu item.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The type-specific settings (i.e. typeSettings) for the navigation menu item.") Object navigationMenuItemSettings;
    @JsonIgnore
    private Supplier<Object> _navigationMenuItemSettingsSupplier;
    @GraphQLField(description="The navigation menu items this navigation menu item has.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The navigation menu items this navigation menu item has.") NavigationMenuItem[] navigationMenuItems;
    @JsonIgnore
    private Supplier<NavigationMenuItem[]> _navigationMenuItemsSupplier;
    @GraphQLField(description="The ID of the navigation menu item's parent.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The ID of the navigation menu item's parent.") Long parentNavigationMenuId;
    @JsonIgnore
    private Supplier<Long> _parentNavigationMenuIdSupplier;
    @GraphQLField(description="The navigation menu item's type.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The navigation menu item's type.") String type;
    @JsonIgnore
    private Supplier<String> _typeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean useCustomName;
    @JsonIgnore
    private Supplier<Boolean> _useCustomNameSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.NavigationMenuItem", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static NavigationMenuItem toDTO(String json) {
        return (NavigationMenuItem)ObjectMapperUtil.readValue(NavigationMenuItem.class, (String)json);
    }

    public static NavigationMenuItem unsafeToDTO(String json) {
        return (NavigationMenuItem)ObjectMapperUtil.unsafeReadValue(NavigationMenuItem.class, (String)json);
    }

    @Schema(description="The list of languages the navigation menu item has a translation for.")
    public String[] getAvailableLanguages() {
        if (this._availableLanguagesSupplier != null) {
            this.availableLanguages = this._availableLanguagesSupplier.get();
            this._availableLanguagesSupplier = null;
        }
        return this.availableLanguages;
    }

    public void setAvailableLanguages(String[] availableLanguages) {
        this.availableLanguages = availableLanguages;
        this._availableLanguagesSupplier = null;
    }

    @JsonIgnore
    public void setAvailableLanguages(UnsafeSupplier<String[], Exception> availableLanguagesUnsafeSupplier) {
        this._availableLanguagesSupplier = () -> {
            try {
                return (String[])availableLanguagesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu item's creator. It is not returned by default. It can be embedded via nestedFields.")
    @Valid
    public Creator getCreator() {
        if (this._creatorSupplier != null) {
            this.creator = this._creatorSupplier.get();
            this._creatorSupplier = null;
        }
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
        this._creatorSupplier = null;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        this._creatorSupplier = () -> {
            try {
                return (Creator)creatorUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A list of the custom fields associated with the navigation menu item.")
    @Valid
    public CustomField[] getCustomFields() {
        if (this._customFieldsSupplier != null) {
            this.customFields = this._customFieldsSupplier.get();
            this._customFieldsSupplier = null;
        }
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
        this._customFieldsSupplier = null;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        this._customFieldsSupplier = () -> {
            try {
                return (CustomField[])customFieldsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu item's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time the navigation menu item changed.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="en_US")
    public String getDefaultLanguageId() {
        if (this._defaultLanguageIdSupplier != null) {
            this.defaultLanguageId = this._defaultLanguageIdSupplier.get();
            this._defaultLanguageIdSupplier = null;
        }
        return this.defaultLanguageId;
    }

    public void setDefaultLanguageId(String defaultLanguageId) {
        this.defaultLanguageId = defaultLanguageId;
        this._defaultLanguageIdSupplier = null;
    }

    @JsonIgnore
    public void setDefaultLanguageId(UnsafeSupplier<String, Exception> defaultLanguageIdUnsafeSupplier) {
        this._defaultLanguageIdSupplier = () -> {
            try {
                return (String)defaultLanguageIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The icon that will be displayed next to this navigation menu item.")
    public String getDisplayIcon() {
        if (this._displayIconSupplier != null) {
            this.displayIcon = this._displayIconSupplier.get();
            this._displayIconSupplier = null;
        }
        return this.displayIcon;
    }

    public void setDisplayIcon(String displayIcon) {
        this.displayIcon = displayIcon;
        this._displayIconSupplier = null;
    }

    @JsonIgnore
    public void setDisplayIcon(UnsafeSupplier<String, Exception> displayIconUnsafeSupplier) {
        this._displayIconSupplier = () -> {
            try {
                return (String)displayIconUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu item's external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu item's ID.")
    public Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu item's name.")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized navigation menu item's names.")
    @Valid
    public Map<String, String> getName_i18n() {
        if (this._name_i18nSupplier != null) {
            this.name_i18n = this._name_i18nSupplier.get();
            this._name_i18nSupplier = null;
        }
        return this.name_i18n;
    }

    public void setName_i18n(Map<String, String> name_i18n) {
        this.name_i18n = name_i18n;
        this._name_i18nSupplier = null;
    }

    @JsonIgnore
    public void setName_i18n(UnsafeSupplier<Map<String, String>, Exception> name_i18nUnsafeSupplier) {
        this._name_i18nSupplier = () -> {
            try {
                return (Map)name_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The type-specific settings (i.e. typeSettings) for the navigation menu item.")
    @Valid
    public Object getNavigationMenuItemSettings() {
        if (this._navigationMenuItemSettingsSupplier != null) {
            this.navigationMenuItemSettings = this._navigationMenuItemSettingsSupplier.get();
            this._navigationMenuItemSettingsSupplier = null;
        }
        return this.navigationMenuItemSettings;
    }

    public void setNavigationMenuItemSettings(Object navigationMenuItemSettings) {
        this.navigationMenuItemSettings = navigationMenuItemSettings;
        this._navigationMenuItemSettingsSupplier = null;
    }

    @JsonIgnore
    public void setNavigationMenuItemSettings(UnsafeSupplier<Object, Exception> navigationMenuItemSettingsUnsafeSupplier) {
        this._navigationMenuItemSettingsSupplier = () -> {
            try {
                return navigationMenuItemSettingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu items this navigation menu item has.")
    @Valid
    public NavigationMenuItem[] getNavigationMenuItems() {
        if (this._navigationMenuItemsSupplier != null) {
            this.navigationMenuItems = this._navigationMenuItemsSupplier.get();
            this._navigationMenuItemsSupplier = null;
        }
        return this.navigationMenuItems;
    }

    public void setNavigationMenuItems(NavigationMenuItem[] navigationMenuItems) {
        this.navigationMenuItems = navigationMenuItems;
        this._navigationMenuItemsSupplier = null;
    }

    @JsonIgnore
    public void setNavigationMenuItems(UnsafeSupplier<NavigationMenuItem[], Exception> navigationMenuItemsUnsafeSupplier) {
        this._navigationMenuItemsSupplier = () -> {
            try {
                return (NavigationMenuItem[])navigationMenuItemsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The ID of the navigation menu item's parent.")
    public Long getParentNavigationMenuId() {
        if (this._parentNavigationMenuIdSupplier != null) {
            this.parentNavigationMenuId = this._parentNavigationMenuIdSupplier.get();
            this._parentNavigationMenuIdSupplier = null;
        }
        return this.parentNavigationMenuId;
    }

    public void setParentNavigationMenuId(Long parentNavigationMenuId) {
        this.parentNavigationMenuId = parentNavigationMenuId;
        this._parentNavigationMenuIdSupplier = null;
    }

    @JsonIgnore
    public void setParentNavigationMenuId(UnsafeSupplier<Long, Exception> parentNavigationMenuIdUnsafeSupplier) {
        this._parentNavigationMenuIdSupplier = () -> {
            try {
                return (Long)parentNavigationMenuIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu item's type.")
    public String getType() {
        if (this._typeSupplier != null) {
            this.type = this._typeSupplier.get();
            this._typeSupplier = null;
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this._typeSupplier = null;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<String, Exception> typeUnsafeSupplier) {
        this._typeSupplier = () -> {
            try {
                return (String)typeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Boolean getUseCustomName() {
        if (this._useCustomNameSupplier != null) {
            this.useCustomName = this._useCustomNameSupplier.get();
            this._useCustomNameSupplier = null;
        }
        return this.useCustomName;
    }

    public void setUseCustomName(Boolean useCustomName) {
        this.useCustomName = useCustomName;
        this._useCustomNameSupplier = null;
    }

    @JsonIgnore
    public void setUseCustomName(UnsafeSupplier<Boolean, Exception> useCustomNameUnsafeSupplier) {
        this._useCustomNameSupplier = () -> {
            try {
                return (Boolean)useCustomNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NavigationMenuItem)) {
            return false;
        }
        NavigationMenuItem navigationMenuItem = (NavigationMenuItem)object;
        return Objects.equals(this.toString(), navigationMenuItem.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Boolean useCustomName;
        String type;
        Long parentNavigationMenuId;
        NavigationMenuItem[] navigationMenuItems;
        Object navigationMenuItemSettings;
        Map<String, String> name_i18n;
        String name;
        Long id;
        String externalReferenceCode;
        String displayIcon;
        String defaultLanguageId;
        Date dateModified;
        Date dateCreated;
        CustomField[] customFields;
        Creator creator;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String[] availableLanguages = this.getAvailableLanguages();
        if (availableLanguages != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"availableLanguages\": ");
            sb.append("[");
            for (int i = 0; i < availableLanguages.length; ++i) {
                sb.append("\"");
                sb.append(NavigationMenuItem._escape(availableLanguages[i]));
                sb.append("\"");
                if (i + 1 >= availableLanguages.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((creator = this.getCreator()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)creator);
        }
        if ((customFields = this.getCustomFields()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (int i = 0; i < customFields.length; ++i) {
                sb.append((Object)customFields[i]);
                if (i + 1 >= customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((defaultLanguageId = this.getDefaultLanguageId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"defaultLanguageId\": ");
            sb.append("\"");
            sb.append(NavigationMenuItem._escape(defaultLanguageId));
            sb.append("\"");
        }
        if ((displayIcon = this.getDisplayIcon()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayIcon\": ");
            sb.append("\"");
            sb.append(NavigationMenuItem._escape(displayIcon));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(NavigationMenuItem._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(NavigationMenuItem._escape(name));
            sb.append("\"");
        }
        if ((name_i18n = this.getName_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name_i18n\": ");
            sb.append(NavigationMenuItem._toJSON(name_i18n));
        }
        if ((navigationMenuItemSettings = this.getNavigationMenuItemSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"navigationMenuItemSettings\": ");
            if (navigationMenuItemSettings instanceof Map) {
                sb.append((Object)JSONFactoryUtil.createJSONObject((Map)((Map)navigationMenuItemSettings)));
            } else if (navigationMenuItemSettings instanceof String) {
                sb.append("\"");
                sb.append(NavigationMenuItem._escape((String)navigationMenuItemSettings));
                sb.append("\"");
            } else {
                sb.append(navigationMenuItemSettings);
            }
        }
        if ((navigationMenuItems = this.getNavigationMenuItems()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"navigationMenuItems\": ");
            sb.append("[");
            for (int i = 0; i < navigationMenuItems.length; ++i) {
                sb.append(String.valueOf(navigationMenuItems[i]));
                if (i + 1 >= navigationMenuItems.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((parentNavigationMenuId = this.getParentNavigationMenuId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentNavigationMenuId\": ");
            sb.append((Object)parentNavigationMenuId);
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append(NavigationMenuItem._escape(type));
            sb.append("\"");
        }
        if ((useCustomName = this.getUseCustomName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"useCustomName\": ");
            sb.append((Object)useCustomName);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(NavigationMenuItem._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (NavigationMenuItem._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(NavigationMenuItem._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(NavigationMenuItem._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(NavigationMenuItem._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

