/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.site.dto.v1_0.CustomField;
import com.liferay.headless.admin.site.dto.v1_0.FriendlyUrlHistory;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageSettings;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.taxonomy.dto.v1_0.Keyword;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="A page on a site, which can be of type content or widget.", value="SitePage")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="SitePage")
public class SitePage
implements Serializable {
    @GraphQLField(description="The list of languages the page has a translation for.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The list of languages the page has a translation for.") String[] availableLanguages;
    @JsonIgnore
    private Supplier<String[]> _availableLanguagesSupplier;
    @GraphQLField(description="The page's creator. It is not returned by default. It can be embedded via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The page's creator. It is not returned by default. It can be embedded via nestedFields.") Creator creator;
    @JsonIgnore
    private Supplier<Creator> _creatorSupplier;
    @GraphQLField(description="The page's creator external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page's creator external reference code.") String creatorExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _creatorExternalReferenceCodeSupplier;
    @GraphQLField(description="Custom fields associated with the page.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Custom fields associated with the page.") CustomField[] customFields;
    @JsonIgnore
    private Supplier<CustomField[]> _customFieldsSupplier;
    @GraphQLField(description="The page's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The last time any field of the page was changed.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The last time any field of the page was changed.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField(description="The page's most recent publication date.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page's most recent publication date.") Date datePublished;
    @JsonIgnore
    private Supplier<Date> _datePublishedSupplier;
    @GraphQLField(description="The page's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page's external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The history of previously used URLs to the page's rendered content. This field is not returned by default. It can be requested via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The history of previously used URLs to the page's rendered content. This field is not returned by default. It can be requested via nestedFields.") FriendlyUrlHistory friendlyUrlHistory;
    @JsonIgnore
    private Supplier<FriendlyUrlHistory> _friendlyUrlHistorySupplier;
    @GraphQLField(description="The localized relative URLs to the page's rendered content.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized relative URLs to the page's rendered content.") Map<String, String> friendlyUrlPath_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _friendlyUrlPath_i18nSupplier;
    @GraphQLField(description="The external references to the associated keywords.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The external references to the associated keywords.") ItemExternalReference[] keywordItemExternalReferences;
    @JsonIgnore
    private Supplier<ItemExternalReference[]> _keywordItemExternalReferencesSupplier;
    @GraphQLField(description="The associated keywords. They are not returned by default. They can be embedded via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The associated keywords. They are not returned by default. They can be embedded via nestedFields.") Keyword[] keywords;
    @JsonIgnore
    private Supplier<Keyword[]> _keywordsSupplier;
    @GraphQLField(description="The localized page's names.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized page's names.") Map<String, String> name_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _name_i18nSupplier;
    @GraphQLField(description="Settings of the page, such as SEO or OpenGraph.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Settings of the page, such as SEO or OpenGraph.") PageSettings pageSettings;
    @JsonIgnore
    private Supplier<PageSettings> _pageSettingsSupplier;
    @GraphQLField(description="The page's specifications. A page may contain 0 or 1 page specifications in draft status and 0 or 1 page specifications in published status.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page's specifications. A page may contain 0 or 1 page specifications in draft status and 0 or 1 page specifications in published status.") PageSpecification[] pageSpecifications;
    @JsonIgnore
    private Supplier<PageSpecification[]> _pageSpecificationsSupplier;
    @GraphQLField(description="The parent page external reference code or null if it is a top level page.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The parent page external reference code or null if it is a top level page.") String parentSitePageExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _parentSitePageExternalReferenceCodeSupplier;
    @GraphQLField(description="The external reference code of the site to which this page is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The external reference code of the site to which this page is scoped.") String siteExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _siteExternalReferenceCodeSupplier;
    @GraphQLField(description="The associated categories. They are not returned by default. They can be embedded via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The associated categories. They are not returned by default. They can be embedded via nestedFields.") TaxonomyCategory[] taxonomyCategories;
    @JsonIgnore
    private Supplier<TaxonomyCategory[]> _taxonomyCategoriesSupplier;
    @GraphQLField(description="The external references to the associated categories.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The external references to the associated categories.") ItemExternalReference[] taxonomyCategoryItemExternalReferences;
    @JsonIgnore
    private Supplier<ItemExternalReference[]> _taxonomyCategoryItemExternalReferencesSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Type type;
    @JsonIgnore
    private Supplier<Type> _typeSupplier;
    @GraphQLField(description="A valid external identifier to reference this page.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A valid external identifier to reference this page.") String uuid;
    @JsonIgnore
    private Supplier<String> _uuidSupplier;
    @GraphQLField(description="A write-only property that specifies the default permissions.")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected @GraphQLField(description="A write-only property that specifies the default permissions.") ViewableBy viewableBy;
    @JsonIgnore
    private Supplier<ViewableBy> _viewableBySupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.SitePage", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static SitePage toDTO(String json) {
        return (SitePage)ObjectMapperUtil.readValue(SitePage.class, (String)json);
    }

    public static SitePage unsafeToDTO(String json) {
        return (SitePage)ObjectMapperUtil.unsafeReadValue(SitePage.class, (String)json);
    }

    @Schema(description="The list of languages the page has a translation for.")
    public String[] getAvailableLanguages() {
        if (this._availableLanguagesSupplier != null) {
            this.availableLanguages = this._availableLanguagesSupplier.get();
            this._availableLanguagesSupplier = null;
        }
        return this.availableLanguages;
    }

    public void setAvailableLanguages(String[] availableLanguages) {
        this.availableLanguages = availableLanguages;
        this._availableLanguagesSupplier = null;
    }

    @JsonIgnore
    public void setAvailableLanguages(UnsafeSupplier<String[], Exception> availableLanguagesUnsafeSupplier) {
        this._availableLanguagesSupplier = () -> {
            try {
                return (String[])availableLanguagesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page's creator. It is not returned by default. It can be embedded via nestedFields.")
    @Valid
    public Creator getCreator() {
        if (this._creatorSupplier != null) {
            this.creator = this._creatorSupplier.get();
            this._creatorSupplier = null;
        }
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
        this._creatorSupplier = null;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        this._creatorSupplier = () -> {
            try {
                return (Creator)creatorUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page's creator external reference code.")
    public String getCreatorExternalReferenceCode() {
        if (this._creatorExternalReferenceCodeSupplier != null) {
            this.creatorExternalReferenceCode = this._creatorExternalReferenceCodeSupplier.get();
            this._creatorExternalReferenceCodeSupplier = null;
        }
        return this.creatorExternalReferenceCode;
    }

    public void setCreatorExternalReferenceCode(String creatorExternalReferenceCode) {
        this.creatorExternalReferenceCode = creatorExternalReferenceCode;
        this._creatorExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setCreatorExternalReferenceCode(UnsafeSupplier<String, Exception> creatorExternalReferenceCodeUnsafeSupplier) {
        this._creatorExternalReferenceCodeSupplier = () -> {
            try {
                return (String)creatorExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Custom fields associated with the page.")
    @Valid
    public CustomField[] getCustomFields() {
        if (this._customFieldsSupplier != null) {
            this.customFields = this._customFieldsSupplier.get();
            this._customFieldsSupplier = null;
        }
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
        this._customFieldsSupplier = null;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        this._customFieldsSupplier = () -> {
            try {
                return (CustomField[])customFieldsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time any field of the page was changed.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page's most recent publication date.")
    public Date getDatePublished() {
        if (this._datePublishedSupplier != null) {
            this.datePublished = this._datePublishedSupplier.get();
            this._datePublishedSupplier = null;
        }
        return this.datePublished;
    }

    public void setDatePublished(Date datePublished) {
        this.datePublished = datePublished;
        this._datePublishedSupplier = null;
    }

    @JsonIgnore
    public void setDatePublished(UnsafeSupplier<Date, Exception> datePublishedUnsafeSupplier) {
        this._datePublishedSupplier = () -> {
            try {
                return (Date)datePublishedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page's external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The history of previously used URLs to the page's rendered content. This field is not returned by default. It can be requested via nestedFields.")
    @Valid
    public FriendlyUrlHistory getFriendlyUrlHistory() {
        if (this._friendlyUrlHistorySupplier != null) {
            this.friendlyUrlHistory = this._friendlyUrlHistorySupplier.get();
            this._friendlyUrlHistorySupplier = null;
        }
        return this.friendlyUrlHistory;
    }

    public void setFriendlyUrlHistory(FriendlyUrlHistory friendlyUrlHistory) {
        this.friendlyUrlHistory = friendlyUrlHistory;
        this._friendlyUrlHistorySupplier = null;
    }

    @JsonIgnore
    public void setFriendlyUrlHistory(UnsafeSupplier<FriendlyUrlHistory, Exception> friendlyUrlHistoryUnsafeSupplier) {
        this._friendlyUrlHistorySupplier = () -> {
            try {
                return (FriendlyUrlHistory)friendlyUrlHistoryUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized relative URLs to the page's rendered content.")
    @Valid
    public Map<String, String> getFriendlyUrlPath_i18n() {
        if (this._friendlyUrlPath_i18nSupplier != null) {
            this.friendlyUrlPath_i18n = this._friendlyUrlPath_i18nSupplier.get();
            this._friendlyUrlPath_i18nSupplier = null;
        }
        return this.friendlyUrlPath_i18n;
    }

    public void setFriendlyUrlPath_i18n(Map<String, String> friendlyUrlPath_i18n) {
        this.friendlyUrlPath_i18n = friendlyUrlPath_i18n;
        this._friendlyUrlPath_i18nSupplier = null;
    }

    @JsonIgnore
    public void setFriendlyUrlPath_i18n(UnsafeSupplier<Map<String, String>, Exception> friendlyUrlPath_i18nUnsafeSupplier) {
        this._friendlyUrlPath_i18nSupplier = () -> {
            try {
                return (Map)friendlyUrlPath_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The external references to the associated keywords.")
    @Valid
    public ItemExternalReference[] getKeywordItemExternalReferences() {
        if (this._keywordItemExternalReferencesSupplier != null) {
            this.keywordItemExternalReferences = this._keywordItemExternalReferencesSupplier.get();
            this._keywordItemExternalReferencesSupplier = null;
        }
        return this.keywordItemExternalReferences;
    }

    public void setKeywordItemExternalReferences(ItemExternalReference[] keywordItemExternalReferences) {
        this.keywordItemExternalReferences = keywordItemExternalReferences;
        this._keywordItemExternalReferencesSupplier = null;
    }

    @JsonIgnore
    public void setKeywordItemExternalReferences(UnsafeSupplier<ItemExternalReference[], Exception> keywordItemExternalReferencesUnsafeSupplier) {
        this._keywordItemExternalReferencesSupplier = () -> {
            try {
                return (ItemExternalReference[])keywordItemExternalReferencesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The associated keywords. They are not returned by default. They can be embedded via nestedFields.")
    @Valid
    public Keyword[] getKeywords() {
        if (this._keywordsSupplier != null) {
            this.keywords = this._keywordsSupplier.get();
            this._keywordsSupplier = null;
        }
        return this.keywords;
    }

    public void setKeywords(Keyword[] keywords) {
        this.keywords = keywords;
        this._keywordsSupplier = null;
    }

    @JsonIgnore
    public void setKeywords(UnsafeSupplier<Keyword[], Exception> keywordsUnsafeSupplier) {
        this._keywordsSupplier = () -> {
            try {
                return (Keyword[])keywordsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized page's names.")
    @Valid
    public Map<String, String> getName_i18n() {
        if (this._name_i18nSupplier != null) {
            this.name_i18n = this._name_i18nSupplier.get();
            this._name_i18nSupplier = null;
        }
        return this.name_i18n;
    }

    public void setName_i18n(Map<String, String> name_i18n) {
        this.name_i18n = name_i18n;
        this._name_i18nSupplier = null;
    }

    @JsonIgnore
    public void setName_i18n(UnsafeSupplier<Map<String, String>, Exception> name_i18nUnsafeSupplier) {
        this._name_i18nSupplier = () -> {
            try {
                return (Map)name_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Settings of the page, such as SEO or OpenGraph.")
    @Valid
    public PageSettings getPageSettings() {
        if (this._pageSettingsSupplier != null) {
            this.pageSettings = this._pageSettingsSupplier.get();
            this._pageSettingsSupplier = null;
        }
        return this.pageSettings;
    }

    public void setPageSettings(PageSettings pageSettings) {
        this.pageSettings = pageSettings;
        this._pageSettingsSupplier = null;
    }

    @JsonIgnore
    public void setPageSettings(UnsafeSupplier<PageSettings, Exception> pageSettingsUnsafeSupplier) {
        this._pageSettingsSupplier = () -> {
            try {
                return (PageSettings)pageSettingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page's specifications. A page may contain 0 or 1 page specifications in draft status and 0 or 1 page specifications in published status.")
    @Valid
    public PageSpecification[] getPageSpecifications() {
        if (this._pageSpecificationsSupplier != null) {
            this.pageSpecifications = this._pageSpecificationsSupplier.get();
            this._pageSpecificationsSupplier = null;
        }
        return this.pageSpecifications;
    }

    public void setPageSpecifications(PageSpecification[] pageSpecifications) {
        this.pageSpecifications = pageSpecifications;
        this._pageSpecificationsSupplier = null;
    }

    @JsonIgnore
    public void setPageSpecifications(UnsafeSupplier<PageSpecification[], Exception> pageSpecificationsUnsafeSupplier) {
        this._pageSpecificationsSupplier = () -> {
            try {
                return (PageSpecification[])pageSpecificationsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The parent page external reference code or null if it is a top level page.")
    public String getParentSitePageExternalReferenceCode() {
        if (this._parentSitePageExternalReferenceCodeSupplier != null) {
            this.parentSitePageExternalReferenceCode = this._parentSitePageExternalReferenceCodeSupplier.get();
            this._parentSitePageExternalReferenceCodeSupplier = null;
        }
        return this.parentSitePageExternalReferenceCode;
    }

    public void setParentSitePageExternalReferenceCode(String parentSitePageExternalReferenceCode) {
        this.parentSitePageExternalReferenceCode = parentSitePageExternalReferenceCode;
        this._parentSitePageExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setParentSitePageExternalReferenceCode(UnsafeSupplier<String, Exception> parentSitePageExternalReferenceCodeUnsafeSupplier) {
        this._parentSitePageExternalReferenceCodeSupplier = () -> {
            try {
                return (String)parentSitePageExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The external reference code of the site to which this page is scoped.")
    public String getSiteExternalReferenceCode() {
        if (this._siteExternalReferenceCodeSupplier != null) {
            this.siteExternalReferenceCode = this._siteExternalReferenceCodeSupplier.get();
            this._siteExternalReferenceCodeSupplier = null;
        }
        return this.siteExternalReferenceCode;
    }

    public void setSiteExternalReferenceCode(String siteExternalReferenceCode) {
        this.siteExternalReferenceCode = siteExternalReferenceCode;
        this._siteExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setSiteExternalReferenceCode(UnsafeSupplier<String, Exception> siteExternalReferenceCodeUnsafeSupplier) {
        this._siteExternalReferenceCodeSupplier = () -> {
            try {
                return (String)siteExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The associated categories. They are not returned by default. They can be embedded via nestedFields.")
    @Valid
    public TaxonomyCategory[] getTaxonomyCategories() {
        if (this._taxonomyCategoriesSupplier != null) {
            this.taxonomyCategories = this._taxonomyCategoriesSupplier.get();
            this._taxonomyCategoriesSupplier = null;
        }
        return this.taxonomyCategories;
    }

    public void setTaxonomyCategories(TaxonomyCategory[] taxonomyCategories) {
        this.taxonomyCategories = taxonomyCategories;
        this._taxonomyCategoriesSupplier = null;
    }

    @JsonIgnore
    public void setTaxonomyCategories(UnsafeSupplier<TaxonomyCategory[], Exception> taxonomyCategoriesUnsafeSupplier) {
        this._taxonomyCategoriesSupplier = () -> {
            try {
                return (TaxonomyCategory[])taxonomyCategoriesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The external references to the associated categories.")
    @Valid
    public ItemExternalReference[] getTaxonomyCategoryItemExternalReferences() {
        if (this._taxonomyCategoryItemExternalReferencesSupplier != null) {
            this.taxonomyCategoryItemExternalReferences = this._taxonomyCategoryItemExternalReferencesSupplier.get();
            this._taxonomyCategoryItemExternalReferencesSupplier = null;
        }
        return this.taxonomyCategoryItemExternalReferences;
    }

    public void setTaxonomyCategoryItemExternalReferences(ItemExternalReference[] taxonomyCategoryItemExternalReferences) {
        this.taxonomyCategoryItemExternalReferences = taxonomyCategoryItemExternalReferences;
        this._taxonomyCategoryItemExternalReferencesSupplier = null;
    }

    @JsonIgnore
    public void setTaxonomyCategoryItemExternalReferences(UnsafeSupplier<ItemExternalReference[], Exception> taxonomyCategoryItemExternalReferencesUnsafeSupplier) {
        this._taxonomyCategoryItemExternalReferencesSupplier = () -> {
            try {
                return (ItemExternalReference[])taxonomyCategoryItemExternalReferencesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @JsonGetter(value="type")
    @Schema
    @Valid
    public Type getType() {
        if (this._typeSupplier != null) {
            this.type = this._typeSupplier.get();
            this._typeSupplier = null;
        }
        return this.type;
    }

    @JsonIgnore
    public String getTypeAsString() {
        Type type = this.getType();
        if (type == null) {
            return null;
        }
        return type.toString();
    }

    public void setType(Type type) {
        this.type = type;
        this._typeSupplier = null;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Type, Exception> typeUnsafeSupplier) {
        this._typeSupplier = () -> {
            try {
                return (Type)((Object)((Object)typeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A valid external identifier to reference this page.")
    public String getUuid() {
        if (this._uuidSupplier != null) {
            this.uuid = this._uuidSupplier.get();
            this._uuidSupplier = null;
        }
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
        this._uuidSupplier = null;
    }

    @JsonIgnore
    public void setUuid(UnsafeSupplier<String, Exception> uuidUnsafeSupplier) {
        this._uuidSupplier = () -> {
            try {
                return (String)uuidUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @JsonGetter(value="viewableBy")
    @Schema(description="A write-only property that specifies the default permissions.")
    @Valid
    public ViewableBy getViewableBy() {
        if (this._viewableBySupplier != null) {
            this.viewableBy = this._viewableBySupplier.get();
            this._viewableBySupplier = null;
        }
        return this.viewableBy;
    }

    @JsonIgnore
    public String getViewableByAsString() {
        ViewableBy viewableBy = this.getViewableBy();
        if (viewableBy == null) {
            return null;
        }
        return viewableBy.toString();
    }

    public void setViewableBy(ViewableBy viewableBy) {
        this.viewableBy = viewableBy;
        this._viewableBySupplier = null;
    }

    @JsonIgnore
    public void setViewableBy(UnsafeSupplier<ViewableBy, Exception> viewableByUnsafeSupplier) {
        this._viewableBySupplier = () -> {
            try {
                return (ViewableBy)((Object)((Object)viewableByUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SitePage)) {
            return false;
        }
        SitePage sitePage = (SitePage)object;
        return Objects.equals(this.toString(), sitePage.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        ViewableBy viewableBy;
        String uuid;
        Type type;
        ItemExternalReference[] taxonomyCategoryItemExternalReferences;
        TaxonomyCategory[] taxonomyCategories;
        String siteExternalReferenceCode;
        String parentSitePageExternalReferenceCode;
        PageSpecification[] pageSpecifications;
        PageSettings pageSettings;
        Map<String, String> name_i18n;
        Keyword[] keywords;
        ItemExternalReference[] keywordItemExternalReferences;
        Map<String, String> friendlyUrlPath_i18n;
        FriendlyUrlHistory friendlyUrlHistory;
        String externalReferenceCode;
        Date datePublished;
        Date dateModified;
        Date dateCreated;
        CustomField[] customFields;
        String creatorExternalReferenceCode;
        Creator creator;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String[] availableLanguages = this.getAvailableLanguages();
        if (availableLanguages != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"availableLanguages\": ");
            sb.append("[");
            for (int i = 0; i < availableLanguages.length; ++i) {
                sb.append("\"");
                sb.append(SitePage._escape(availableLanguages[i]));
                sb.append("\"");
                if (i + 1 >= availableLanguages.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((creator = this.getCreator()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)creator);
        }
        if ((creatorExternalReferenceCode = this.getCreatorExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creatorExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(SitePage._escape(creatorExternalReferenceCode));
            sb.append("\"");
        }
        if ((customFields = this.getCustomFields()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (int i = 0; i < customFields.length; ++i) {
                sb.append(String.valueOf(customFields[i]));
                if (i + 1 >= customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((datePublished = this.getDatePublished()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"datePublished\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(datePublished));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(SitePage._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((friendlyUrlHistory = this.getFriendlyUrlHistory()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"friendlyUrlHistory\": ");
            sb.append(String.valueOf(friendlyUrlHistory));
        }
        if ((friendlyUrlPath_i18n = this.getFriendlyUrlPath_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"friendlyUrlPath_i18n\": ");
            sb.append(SitePage._toJSON(friendlyUrlPath_i18n));
        }
        if ((keywordItemExternalReferences = this.getKeywordItemExternalReferences()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywordItemExternalReferences\": ");
            sb.append("[");
            for (int i = 0; i < keywordItemExternalReferences.length; ++i) {
                sb.append(String.valueOf(keywordItemExternalReferences[i]));
                if (i + 1 >= keywordItemExternalReferences.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((keywords = this.getKeywords()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (int i = 0; i < keywords.length; ++i) {
                sb.append((Object)keywords[i]);
                if (i + 1 >= keywords.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((name_i18n = this.getName_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name_i18n\": ");
            sb.append(SitePage._toJSON(name_i18n));
        }
        if ((pageSettings = this.getPageSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageSettings\": ");
            sb.append(String.valueOf(pageSettings));
        }
        if ((pageSpecifications = this.getPageSpecifications()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageSpecifications\": ");
            sb.append("[");
            for (int i = 0; i < pageSpecifications.length; ++i) {
                sb.append(String.valueOf(pageSpecifications[i]));
                if (i + 1 >= pageSpecifications.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((parentSitePageExternalReferenceCode = this.getParentSitePageExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentSitePageExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(SitePage._escape(parentSitePageExternalReferenceCode));
            sb.append("\"");
        }
        if ((siteExternalReferenceCode = this.getSiteExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(SitePage._escape(siteExternalReferenceCode));
            sb.append("\"");
        }
        if ((taxonomyCategories = this.getTaxonomyCategories()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategories\": ");
            sb.append("[");
            for (int i = 0; i < taxonomyCategories.length; ++i) {
                sb.append((Object)taxonomyCategories[i]);
                if (i + 1 >= taxonomyCategories.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((taxonomyCategoryItemExternalReferences = this.getTaxonomyCategoryItemExternalReferences()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryItemExternalReferences\": ");
            sb.append("[");
            for (int i = 0; i < taxonomyCategoryItemExternalReferences.length; ++i) {
                sb.append(String.valueOf(taxonomyCategoryItemExternalReferences[i]));
                if (i + 1 >= taxonomyCategoryItemExternalReferences.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)type);
            sb.append("\"");
        }
        if ((uuid = this.getUuid()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"uuid\": ");
            sb.append("\"");
            sb.append(SitePage._escape(uuid));
            sb.append("\"");
        }
        if ((viewableBy = this.getViewableBy()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)viewableBy);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(SitePage._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (SitePage._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(SitePage._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(SitePage._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(SitePage._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="ViewableBy")
    public static enum ViewableBy {
        ANYONE("Anyone"),
        MEMBERS("Members"),
        OWNER("Owner");

        private final String _value;

        @JsonCreator
        public static ViewableBy create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (ViewableBy viewableBy : ViewableBy.values()) {
                if (!Objects.equals(viewableBy.getValue(), value)) continue;
                return viewableBy;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ViewableBy(String value) {
            this._value = value;
        }
    }

    @GraphQLName(value="Type")
    public static enum Type {
        COLLECTION_PAGE("CollectionPage"),
        CONTENT_PAGE("ContentPage"),
        WIDGET_PAGE("WidgetPage");

        private final String _value;

        @JsonCreator
        public static Type create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Type type : Type.values()) {
                if (!Objects.equals(type.getValue(), value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }
}

