/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(value="StyleBook")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="StyleBook")
public class StyleBook
implements Serializable {
    @GraphQLField(description="The style book's creator.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The style book's creator.") Creator creator;
    @JsonIgnore
    private Supplier<Creator> _creatorSupplier;
    @GraphQLField(description="The style book's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The style book's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The last time the style book changed.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The last time the style book changed.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField(description="A flag to indicate whether this is the default style book for the specified theme.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A flag to indicate whether this is the default style book for the specified theme.") Boolean defaultStyleBook;
    @JsonIgnore
    private Supplier<Boolean> _defaultStyleBookSupplier;
    @GraphQLField(description="The style book's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The style book's external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The style book's tokens values.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The style book's tokens values.") String frontendTokensValues;
    @JsonIgnore
    private Supplier<String> _frontendTokensValuesSupplier;
    @GraphQLField(description="The style book's key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The style book's key.") String key;
    @JsonIgnore
    private Supplier<String> _keySupplier;
    @GraphQLField(description="The style book's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The style book's name.") String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField(description="The style book's preview file entry external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The style book's preview file entry external reference code.") String previewFileEntryExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _previewFileEntryExternalReferenceCodeSupplier;
    @GraphQLField(description="The theme id or the themeCSS client extension external reference code this style book is based on.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The theme id or the themeCSS client extension external reference code this style book is based on.") String themeId;
    @JsonIgnore
    private Supplier<String> _themeIdSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.StyleBook", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static StyleBook toDTO(String json) {
        return (StyleBook)ObjectMapperUtil.readValue(StyleBook.class, (String)json);
    }

    public static StyleBook unsafeToDTO(String json) {
        return (StyleBook)ObjectMapperUtil.unsafeReadValue(StyleBook.class, (String)json);
    }

    @Schema(description="The style book's creator.")
    @Valid
    public Creator getCreator() {
        if (this._creatorSupplier != null) {
            this.creator = this._creatorSupplier.get();
            this._creatorSupplier = null;
        }
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
        this._creatorSupplier = null;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        this._creatorSupplier = () -> {
            try {
                return (Creator)creatorUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The style book's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time the style book changed.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A flag to indicate whether this is the default style book for the specified theme.")
    public Boolean getDefaultStyleBook() {
        if (this._defaultStyleBookSupplier != null) {
            this.defaultStyleBook = this._defaultStyleBookSupplier.get();
            this._defaultStyleBookSupplier = null;
        }
        return this.defaultStyleBook;
    }

    public void setDefaultStyleBook(Boolean defaultStyleBook) {
        this.defaultStyleBook = defaultStyleBook;
        this._defaultStyleBookSupplier = null;
    }

    @JsonIgnore
    public void setDefaultStyleBook(UnsafeSupplier<Boolean, Exception> defaultStyleBookUnsafeSupplier) {
        this._defaultStyleBookSupplier = () -> {
            try {
                return (Boolean)defaultStyleBookUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The style book's external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The style book's tokens values.")
    public String getFrontendTokensValues() {
        if (this._frontendTokensValuesSupplier != null) {
            this.frontendTokensValues = this._frontendTokensValuesSupplier.get();
            this._frontendTokensValuesSupplier = null;
        }
        return this.frontendTokensValues;
    }

    public void setFrontendTokensValues(String frontendTokensValues) {
        this.frontendTokensValues = frontendTokensValues;
        this._frontendTokensValuesSupplier = null;
    }

    @JsonIgnore
    public void setFrontendTokensValues(UnsafeSupplier<String, Exception> frontendTokensValuesUnsafeSupplier) {
        this._frontendTokensValuesSupplier = () -> {
            try {
                return (String)frontendTokensValuesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The style book's key.")
    public String getKey() {
        if (this._keySupplier != null) {
            this.key = this._keySupplier.get();
            this._keySupplier = null;
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this._keySupplier = null;
    }

    @JsonIgnore
    public void setKey(UnsafeSupplier<String, Exception> keyUnsafeSupplier) {
        this._keySupplier = () -> {
            try {
                return (String)keyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The style book's name.")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The style book's preview file entry external reference code.")
    public String getPreviewFileEntryExternalReferenceCode() {
        if (this._previewFileEntryExternalReferenceCodeSupplier != null) {
            this.previewFileEntryExternalReferenceCode = this._previewFileEntryExternalReferenceCodeSupplier.get();
            this._previewFileEntryExternalReferenceCodeSupplier = null;
        }
        return this.previewFileEntryExternalReferenceCode;
    }

    public void setPreviewFileEntryExternalReferenceCode(String previewFileEntryExternalReferenceCode) {
        this.previewFileEntryExternalReferenceCode = previewFileEntryExternalReferenceCode;
        this._previewFileEntryExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setPreviewFileEntryExternalReferenceCode(UnsafeSupplier<String, Exception> previewFileEntryExternalReferenceCodeUnsafeSupplier) {
        this._previewFileEntryExternalReferenceCodeSupplier = () -> {
            try {
                return (String)previewFileEntryExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The theme id or the themeCSS client extension external reference code this style book is based on.")
    public String getThemeId() {
        if (this._themeIdSupplier != null) {
            this.themeId = this._themeIdSupplier.get();
            this._themeIdSupplier = null;
        }
        return this.themeId;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
        this._themeIdSupplier = null;
    }

    @JsonIgnore
    public void setThemeId(UnsafeSupplier<String, Exception> themeIdUnsafeSupplier) {
        this._themeIdSupplier = () -> {
            try {
                return (String)themeIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StyleBook)) {
            return false;
        }
        StyleBook styleBook = (StyleBook)object;
        return Objects.equals(this.toString(), styleBook.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String themeId;
        String previewFileEntryExternalReferenceCode;
        String name;
        String key;
        String frontendTokensValues;
        String externalReferenceCode;
        Boolean defaultStyleBook;
        Date dateModified;
        Date dateCreated;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Creator creator = this.getCreator();
        if (creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)creator);
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((defaultStyleBook = this.getDefaultStyleBook()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"defaultStyleBook\": ");
            sb.append((Object)defaultStyleBook);
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(StyleBook._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((frontendTokensValues = this.getFrontendTokensValues()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"frontendTokensValues\": ");
            sb.append("\"");
            sb.append(StyleBook._escape(frontendTokensValues));
            sb.append("\"");
        }
        if ((key = this.getKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"key\": ");
            sb.append("\"");
            sb.append(StyleBook._escape(key));
            sb.append("\"");
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(StyleBook._escape(name));
            sb.append("\"");
        }
        if ((previewFileEntryExternalReferenceCode = this.getPreviewFileEntryExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"previewFileEntryExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(StyleBook._escape(previewFileEntryExternalReferenceCode));
            sb.append("\"");
        }
        if ((themeId = this.getThemeId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"themeId\": ");
            sb.append("\"");
            sb.append(StyleBook._escape(themeId));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(StyleBook._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (StyleBook._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(StyleBook._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(StyleBook._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(StyleBook._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

