/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.SitemapSettings;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Settings related with SEO of a display page template.", value="DisplayPageTemplateSEOSettings")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="DisplayPageTemplateSEOSettings")
public class DisplayPageTemplateSEOSettings
implements Serializable {
    @GraphQLField(description="The description template of the display page template to be used as summary for search engines.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The description template of the display page template to be used as summary for search engines.") String descriptionTemplate;
    @JsonIgnore
    private Supplier<String> _descriptionTemplateSupplier;
    @GraphQLField(description="The main title template of the display page template to be used by search engines.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The main title template of the display page template to be used by search engines.") String htmlTitleTemplate;
    @JsonIgnore
    private Supplier<String> _htmlTitleTemplateSupplier;
    @GraphQLField(description="A localized tag telling search engines if and how they should crawl the display page template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A localized tag telling search engines if and how they should crawl the display page template.") Map<String, String> robots_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _robots_i18nSupplier;
    @GraphQLField(description="Represents settings related with the site map.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Represents settings related with the site map.") SitemapSettings sitemapSettings;
    @JsonIgnore
    private Supplier<SitemapSettings> _sitemapSettingsSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateSEOSettings", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static DisplayPageTemplateSEOSettings toDTO(String json) {
        return (DisplayPageTemplateSEOSettings)ObjectMapperUtil.readValue(DisplayPageTemplateSEOSettings.class, (String)json);
    }

    public static DisplayPageTemplateSEOSettings unsafeToDTO(String json) {
        return (DisplayPageTemplateSEOSettings)ObjectMapperUtil.unsafeReadValue(DisplayPageTemplateSEOSettings.class, (String)json);
    }

    @Schema(description="The description template of the display page template to be used as summary for search engines.")
    public String getDescriptionTemplate() {
        if (this._descriptionTemplateSupplier != null) {
            this.descriptionTemplate = this._descriptionTemplateSupplier.get();
            this._descriptionTemplateSupplier = null;
        }
        return this.descriptionTemplate;
    }

    public void setDescriptionTemplate(String descriptionTemplate) {
        this.descriptionTemplate = descriptionTemplate;
        this._descriptionTemplateSupplier = null;
    }

    @JsonIgnore
    public void setDescriptionTemplate(UnsafeSupplier<String, Exception> descriptionTemplateUnsafeSupplier) {
        this._descriptionTemplateSupplier = () -> {
            try {
                return (String)descriptionTemplateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The main title template of the display page template to be used by search engines.")
    public String getHtmlTitleTemplate() {
        if (this._htmlTitleTemplateSupplier != null) {
            this.htmlTitleTemplate = this._htmlTitleTemplateSupplier.get();
            this._htmlTitleTemplateSupplier = null;
        }
        return this.htmlTitleTemplate;
    }

    public void setHtmlTitleTemplate(String htmlTitleTemplate) {
        this.htmlTitleTemplate = htmlTitleTemplate;
        this._htmlTitleTemplateSupplier = null;
    }

    @JsonIgnore
    public void setHtmlTitleTemplate(UnsafeSupplier<String, Exception> htmlTitleTemplateUnsafeSupplier) {
        this._htmlTitleTemplateSupplier = () -> {
            try {
                return (String)htmlTitleTemplateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A localized tag telling search engines if and how they should crawl the display page template.")
    @Valid
    public Map<String, String> getRobots_i18n() {
        if (this._robots_i18nSupplier != null) {
            this.robots_i18n = this._robots_i18nSupplier.get();
            this._robots_i18nSupplier = null;
        }
        return this.robots_i18n;
    }

    public void setRobots_i18n(Map<String, String> robots_i18n) {
        this.robots_i18n = robots_i18n;
        this._robots_i18nSupplier = null;
    }

    @JsonIgnore
    public void setRobots_i18n(UnsafeSupplier<Map<String, String>, Exception> robots_i18nUnsafeSupplier) {
        this._robots_i18nSupplier = () -> {
            try {
                return (Map)robots_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Represents settings related with the site map.")
    @Valid
    public SitemapSettings getSitemapSettings() {
        if (this._sitemapSettingsSupplier != null) {
            this.sitemapSettings = this._sitemapSettingsSupplier.get();
            this._sitemapSettingsSupplier = null;
        }
        return this.sitemapSettings;
    }

    public void setSitemapSettings(SitemapSettings sitemapSettings) {
        this.sitemapSettings = sitemapSettings;
        this._sitemapSettingsSupplier = null;
    }

    @JsonIgnore
    public void setSitemapSettings(UnsafeSupplier<SitemapSettings, Exception> sitemapSettingsUnsafeSupplier) {
        this._sitemapSettingsSupplier = () -> {
            try {
                return (SitemapSettings)sitemapSettingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DisplayPageTemplateSEOSettings)) {
            return false;
        }
        DisplayPageTemplateSEOSettings displayPageTemplateSEOSettings = (DisplayPageTemplateSEOSettings)object;
        return Objects.equals(this.toString(), displayPageTemplateSEOSettings.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        SitemapSettings sitemapSettings;
        Map<String, String> robots_i18n;
        String htmlTitleTemplate;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String descriptionTemplate = this.getDescriptionTemplate();
        if (descriptionTemplate != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"descriptionTemplate\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplateSEOSettings._escape(descriptionTemplate));
            sb.append("\"");
        }
        if ((htmlTitleTemplate = this.getHtmlTitleTemplate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"htmlTitleTemplate\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplateSEOSettings._escape(htmlTitleTemplate));
            sb.append("\"");
        }
        if ((robots_i18n = this.getRobots_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"robots_i18n\": ");
            sb.append(DisplayPageTemplateSEOSettings._toJSON(robots_i18n));
        }
        if ((sitemapSettings = this.getSitemapSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"sitemapSettings\": ");
            sb.append(String.valueOf(sitemapSettings));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(DisplayPageTemplateSEOSettings._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (DisplayPageTemplateSEOSettings._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(DisplayPageTemplateSEOSettings._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(DisplayPageTemplateSEOSettings._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(DisplayPageTemplateSEOSettings._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

