/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.WidgetLookAndFeelConfig;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPermission;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="A widget instance in a widget page.", value="WidgetPageWidgetInstance")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="WidgetPageWidgetInstance")
public class WidgetPageWidgetInstance
implements Serializable {
    @GraphQLField(description="The external reference code of the widget instance.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The external reference code of the widget instance.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The section's ID of the widget page or the nested application widget instance this widget belongs to.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The section's ID of the widget page or the nested application widget instance this widget belongs to.") String parentSectionId;
    @JsonIgnore
    private Supplier<String> _parentSectionIdSupplier;
    @GraphQLField(description="The external reference code of the parent widget instance. Only available if this widget instance is within a nested applications widget instance.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The external reference code of the parent widget instance. Only available if this widget instance is within a nested applications widget instance.") String parentWidgetInstanceExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _parentWidgetInstanceExternalReferenceCodeSupplier;
    @GraphQLField(description="The 0-based position this widget instance occupies with respect to its siblings (0 for first child, 1 for second child, ...). If not specified when creating a widget instance the widget instance will be added at the last valid position.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The 0-based position this widget instance occupies with respect to its siblings (0 for first child, 1 for second child, ...). If not specified when creating a widget instance the widget instance will be added at the last valid position.") Integer position;
    @JsonIgnore
    private Supplier<Integer> _positionSupplier;
    @GraphQLField(description="The configuration keys and values of the widget instance.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The configuration keys and values of the widget instance.") Map<String, Object> widgetConfig;
    @JsonIgnore
    private Supplier<Map<String, Object>> _widgetConfigSupplier;
    @GraphQLField(description="The widget instance's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The widget instance's ID.") String widgetInstanceId;
    @JsonIgnore
    private Supplier<String> _widgetInstanceIdSupplier;
    @GraphQLField(description="The widget instance's look and feel configuration.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The widget instance's look and feel configuration.") WidgetLookAndFeelConfig widgetLookAndFeelConfig;
    @JsonIgnore
    private Supplier<WidgetLookAndFeelConfig> _widgetLookAndFeelConfigSupplier;
    @GraphQLField(description="The widget instance's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The widget instance's name.") String widgetName;
    @JsonIgnore
    private Supplier<String> _widgetNameSupplier;
    @GraphQLField(description="The widget instance's permissions.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The widget instance's permissions.") WidgetPermission[] widgetPermissions;
    @JsonIgnore
    private Supplier<WidgetPermission[]> _widgetPermissionsSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.WidgetPageWidgetInstance", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static WidgetPageWidgetInstance toDTO(String json) {
        return (WidgetPageWidgetInstance)ObjectMapperUtil.readValue(WidgetPageWidgetInstance.class, (String)json);
    }

    public static WidgetPageWidgetInstance unsafeToDTO(String json) {
        return (WidgetPageWidgetInstance)ObjectMapperUtil.unsafeReadValue(WidgetPageWidgetInstance.class, (String)json);
    }

    @Schema(description="The external reference code of the widget instance.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The section's ID of the widget page or the nested application widget instance this widget belongs to.")
    public String getParentSectionId() {
        if (this._parentSectionIdSupplier != null) {
            this.parentSectionId = this._parentSectionIdSupplier.get();
            this._parentSectionIdSupplier = null;
        }
        return this.parentSectionId;
    }

    public void setParentSectionId(String parentSectionId) {
        this.parentSectionId = parentSectionId;
        this._parentSectionIdSupplier = null;
    }

    @JsonIgnore
    public void setParentSectionId(UnsafeSupplier<String, Exception> parentSectionIdUnsafeSupplier) {
        this._parentSectionIdSupplier = () -> {
            try {
                return (String)parentSectionIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The external reference code of the parent widget instance. Only available if this widget instance is within a nested applications widget instance.")
    public String getParentWidgetInstanceExternalReferenceCode() {
        if (this._parentWidgetInstanceExternalReferenceCodeSupplier != null) {
            this.parentWidgetInstanceExternalReferenceCode = this._parentWidgetInstanceExternalReferenceCodeSupplier.get();
            this._parentWidgetInstanceExternalReferenceCodeSupplier = null;
        }
        return this.parentWidgetInstanceExternalReferenceCode;
    }

    public void setParentWidgetInstanceExternalReferenceCode(String parentWidgetInstanceExternalReferenceCode) {
        this.parentWidgetInstanceExternalReferenceCode = parentWidgetInstanceExternalReferenceCode;
        this._parentWidgetInstanceExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setParentWidgetInstanceExternalReferenceCode(UnsafeSupplier<String, Exception> parentWidgetInstanceExternalReferenceCodeUnsafeSupplier) {
        this._parentWidgetInstanceExternalReferenceCodeSupplier = () -> {
            try {
                return (String)parentWidgetInstanceExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(description="The 0-based position this widget instance occupies with respect to its siblings (0 for first child, 1 for second child, ...). If not specified when creating a widget instance the widget instance will be added at the last valid position.")
    public @DecimalMin(value="0") Integer getPosition() {
        if (this._positionSupplier != null) {
            this.position = this._positionSupplier.get();
            this._positionSupplier = null;
        }
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
        this._positionSupplier = null;
    }

    @JsonIgnore
    public void setPosition(UnsafeSupplier<Integer, Exception> positionUnsafeSupplier) {
        this._positionSupplier = () -> {
            try {
                return (Integer)positionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The configuration keys and values of the widget instance.")
    @Valid
    public Map<String, Object> getWidgetConfig() {
        if (this._widgetConfigSupplier != null) {
            this.widgetConfig = this._widgetConfigSupplier.get();
            this._widgetConfigSupplier = null;
        }
        return this.widgetConfig;
    }

    public void setWidgetConfig(Map<String, Object> widgetConfig) {
        this.widgetConfig = widgetConfig;
        this._widgetConfigSupplier = null;
    }

    @JsonIgnore
    public void setWidgetConfig(UnsafeSupplier<Map<String, Object>, Exception> widgetConfigUnsafeSupplier) {
        this._widgetConfigSupplier = () -> {
            try {
                return (Map)widgetConfigUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The widget instance's ID.")
    public String getWidgetInstanceId() {
        if (this._widgetInstanceIdSupplier != null) {
            this.widgetInstanceId = this._widgetInstanceIdSupplier.get();
            this._widgetInstanceIdSupplier = null;
        }
        return this.widgetInstanceId;
    }

    public void setWidgetInstanceId(String widgetInstanceId) {
        this.widgetInstanceId = widgetInstanceId;
        this._widgetInstanceIdSupplier = null;
    }

    @JsonIgnore
    public void setWidgetInstanceId(UnsafeSupplier<String, Exception> widgetInstanceIdUnsafeSupplier) {
        this._widgetInstanceIdSupplier = () -> {
            try {
                return (String)widgetInstanceIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The widget instance's look and feel configuration.")
    @Valid
    public WidgetLookAndFeelConfig getWidgetLookAndFeelConfig() {
        if (this._widgetLookAndFeelConfigSupplier != null) {
            this.widgetLookAndFeelConfig = this._widgetLookAndFeelConfigSupplier.get();
            this._widgetLookAndFeelConfigSupplier = null;
        }
        return this.widgetLookAndFeelConfig;
    }

    public void setWidgetLookAndFeelConfig(WidgetLookAndFeelConfig widgetLookAndFeelConfig) {
        this.widgetLookAndFeelConfig = widgetLookAndFeelConfig;
        this._widgetLookAndFeelConfigSupplier = null;
    }

    @JsonIgnore
    public void setWidgetLookAndFeelConfig(UnsafeSupplier<WidgetLookAndFeelConfig, Exception> widgetLookAndFeelConfigUnsafeSupplier) {
        this._widgetLookAndFeelConfigSupplier = () -> {
            try {
                return (WidgetLookAndFeelConfig)widgetLookAndFeelConfigUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The widget instance's name.")
    public String getWidgetName() {
        if (this._widgetNameSupplier != null) {
            this.widgetName = this._widgetNameSupplier.get();
            this._widgetNameSupplier = null;
        }
        return this.widgetName;
    }

    public void setWidgetName(String widgetName) {
        this.widgetName = widgetName;
        this._widgetNameSupplier = null;
    }

    @JsonIgnore
    public void setWidgetName(UnsafeSupplier<String, Exception> widgetNameUnsafeSupplier) {
        this._widgetNameSupplier = () -> {
            try {
                return (String)widgetNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The widget instance's permissions.")
    @Valid
    public WidgetPermission[] getWidgetPermissions() {
        if (this._widgetPermissionsSupplier != null) {
            this.widgetPermissions = this._widgetPermissionsSupplier.get();
            this._widgetPermissionsSupplier = null;
        }
        return this.widgetPermissions;
    }

    public void setWidgetPermissions(WidgetPermission[] widgetPermissions) {
        this.widgetPermissions = widgetPermissions;
        this._widgetPermissionsSupplier = null;
    }

    @JsonIgnore
    public void setWidgetPermissions(UnsafeSupplier<WidgetPermission[], Exception> widgetPermissionsUnsafeSupplier) {
        this._widgetPermissionsSupplier = () -> {
            try {
                return (WidgetPermission[])widgetPermissionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WidgetPageWidgetInstance)) {
            return false;
        }
        WidgetPageWidgetInstance widgetPageWidgetInstance = (WidgetPageWidgetInstance)object;
        return Objects.equals(this.toString(), widgetPageWidgetInstance.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        WidgetPermission[] widgetPermissions;
        String widgetName;
        WidgetLookAndFeelConfig widgetLookAndFeelConfig;
        String widgetInstanceId;
        Map<String, Object> widgetConfig;
        Integer position;
        String parentWidgetInstanceExternalReferenceCode;
        String parentSectionId;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String externalReferenceCode = this.getExternalReferenceCode();
        if (externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(WidgetPageWidgetInstance._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((parentSectionId = this.getParentSectionId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentSectionId\": ");
            sb.append("\"");
            sb.append(WidgetPageWidgetInstance._escape(parentSectionId));
            sb.append("\"");
        }
        if ((parentWidgetInstanceExternalReferenceCode = this.getParentWidgetInstanceExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentWidgetInstanceExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(WidgetPageWidgetInstance._escape(parentWidgetInstanceExternalReferenceCode));
            sb.append("\"");
        }
        if ((position = this.getPosition()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"position\": ");
            sb.append((Object)position);
        }
        if ((widgetConfig = this.getWidgetConfig()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"widgetConfig\": ");
            sb.append(WidgetPageWidgetInstance._toJSON(widgetConfig));
        }
        if ((widgetInstanceId = this.getWidgetInstanceId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"widgetInstanceId\": ");
            sb.append("\"");
            sb.append(WidgetPageWidgetInstance._escape(widgetInstanceId));
            sb.append("\"");
        }
        if ((widgetLookAndFeelConfig = this.getWidgetLookAndFeelConfig()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"widgetLookAndFeelConfig\": ");
            sb.append(String.valueOf(widgetLookAndFeelConfig));
        }
        if ((widgetName = this.getWidgetName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"widgetName\": ");
            sb.append("\"");
            sb.append(WidgetPageWidgetInstance._escape(widgetName));
            sb.append("\"");
        }
        if ((widgetPermissions = this.getWidgetPermissions()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"widgetPermissions\": ");
            sb.append("[");
            for (int i = 0; i < widgetPermissions.length; ++i) {
                sb.append(String.valueOf(widgetPermissions[i]));
                if (i + 1 >= widgetPermissions.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WidgetPageWidgetInstance._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WidgetPageWidgetInstance._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(WidgetPageWidgetInstance._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WidgetPageWidgetInstance._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WidgetPageWidgetInstance._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

