/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.PageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.PageTemplateSet;
import com.liferay.headless.admin.site.dto.v1_0.PageTemplateSettings;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="A widget page template.", value="WidgetPageTemplate")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="WidgetPageTemplate")
public class WidgetPageTemplate
extends PageTemplate
implements Serializable {
    @GraphQLField(description="A flag that indicates whether the widget page template is active.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A flag that indicates whether the widget page template is active.") Boolean active;
    @JsonIgnore
    private Supplier<Boolean> _activeSupplier;
    @GraphQLField(description="The localized descriptions of the widget page template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized descriptions of the widget page template.") Map<String, String> description_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _description_i18nSupplier;
    @GraphQLField(description="The localized relative URLs to the page's rendered content.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized relative URLs to the page's rendered content.") Map<String, String> friendlyUrlPath_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _friendlyUrlPath_i18nSupplier;
    @GraphQLField(description="A flag that indicates whether the page created based on this page template is hidden from navigation.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A flag that indicates whether the page created based on this page template is hidden from navigation.") Boolean hiddenFromNavigation;
    @JsonIgnore
    private Supplier<Boolean> _hiddenFromNavigationSupplier;
    @GraphQLField(description="The localized names of the widget page template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized names of the widget page template.") Map<String, String> name_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _name_i18nSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.WidgetPageTemplate", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static WidgetPageTemplate toDTO(String json) {
        return (WidgetPageTemplate)ObjectMapperUtil.readValue(WidgetPageTemplate.class, (String)json);
    }

    public static WidgetPageTemplate unsafeToDTO(String json) {
        return (WidgetPageTemplate)ObjectMapperUtil.unsafeReadValue(WidgetPageTemplate.class, (String)json);
    }

    @Schema(description="A flag that indicates whether the widget page template is active.")
    public Boolean getActive() {
        if (this._activeSupplier != null) {
            this.active = this._activeSupplier.get();
            this._activeSupplier = null;
        }
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
        this._activeSupplier = null;
    }

    @JsonIgnore
    public void setActive(UnsafeSupplier<Boolean, Exception> activeUnsafeSupplier) {
        this._activeSupplier = () -> {
            try {
                return (Boolean)activeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized descriptions of the widget page template.")
    @Valid
    public Map<String, String> getDescription_i18n() {
        if (this._description_i18nSupplier != null) {
            this.description_i18n = this._description_i18nSupplier.get();
            this._description_i18nSupplier = null;
        }
        return this.description_i18n;
    }

    public void setDescription_i18n(Map<String, String> description_i18n) {
        this.description_i18n = description_i18n;
        this._description_i18nSupplier = null;
    }

    @JsonIgnore
    public void setDescription_i18n(UnsafeSupplier<Map<String, String>, Exception> description_i18nUnsafeSupplier) {
        this._description_i18nSupplier = () -> {
            try {
                return (Map)description_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized relative URLs to the page's rendered content.")
    @Valid
    public Map<String, String> getFriendlyUrlPath_i18n() {
        if (this._friendlyUrlPath_i18nSupplier != null) {
            this.friendlyUrlPath_i18n = this._friendlyUrlPath_i18nSupplier.get();
            this._friendlyUrlPath_i18nSupplier = null;
        }
        return this.friendlyUrlPath_i18n;
    }

    public void setFriendlyUrlPath_i18n(Map<String, String> friendlyUrlPath_i18n) {
        this.friendlyUrlPath_i18n = friendlyUrlPath_i18n;
        this._friendlyUrlPath_i18nSupplier = null;
    }

    @JsonIgnore
    public void setFriendlyUrlPath_i18n(UnsafeSupplier<Map<String, String>, Exception> friendlyUrlPath_i18nUnsafeSupplier) {
        this._friendlyUrlPath_i18nSupplier = () -> {
            try {
                return (Map)friendlyUrlPath_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A flag that indicates whether the page created based on this page template is hidden from navigation.")
    public Boolean getHiddenFromNavigation() {
        if (this._hiddenFromNavigationSupplier != null) {
            this.hiddenFromNavigation = this._hiddenFromNavigationSupplier.get();
            this._hiddenFromNavigationSupplier = null;
        }
        return this.hiddenFromNavigation;
    }

    public void setHiddenFromNavigation(Boolean hiddenFromNavigation) {
        this.hiddenFromNavigation = hiddenFromNavigation;
        this._hiddenFromNavigationSupplier = null;
    }

    @JsonIgnore
    public void setHiddenFromNavigation(UnsafeSupplier<Boolean, Exception> hiddenFromNavigationUnsafeSupplier) {
        this._hiddenFromNavigationSupplier = () -> {
            try {
                return (Boolean)hiddenFromNavigationUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized names of the widget page template.")
    @Valid
    public Map<String, String> getName_i18n() {
        if (this._name_i18nSupplier != null) {
            this.name_i18n = this._name_i18nSupplier.get();
            this._name_i18nSupplier = null;
        }
        return this.name_i18n;
    }

    public void setName_i18n(Map<String, String> name_i18n) {
        this.name_i18n = name_i18n;
        this._name_i18nSupplier = null;
    }

    @JsonIgnore
    public void setName_i18n(UnsafeSupplier<Map<String, String>, Exception> name_i18nUnsafeSupplier) {
        this._name_i18nSupplier = () -> {
            try {
                return (Map)name_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WidgetPageTemplate)) {
            return false;
        }
        WidgetPageTemplate widgetPageTemplate = (WidgetPageTemplate)object;
        return Objects.equals(this.toString(), widgetPageTemplate.toString());
    }

    @Override
    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    @Override
    public String toString() {
        String uuid;
        PageTemplate.Type type;
        ItemExternalReference[] taxonomyCategoryItemExternalReferences;
        PageTemplateSettings pageTemplateSettings;
        PageTemplateSet pageTemplateSet;
        PageSpecification[] pageSpecifications;
        String name;
        String[] keywords;
        String key;
        String externalReferenceCode;
        Date datePublished;
        Date dateModified;
        Date dateCreated;
        String creatorExternalReferenceCode;
        Creator creator;
        Map<String, String> name_i18n;
        Boolean hiddenFromNavigation;
        Map<String, String> friendlyUrlPath_i18n;
        Map<String, String> description_i18n;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Boolean active = this.getActive();
        if (active != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"active\": ");
            sb.append((Object)active);
        }
        if ((description_i18n = this.getDescription_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description_i18n\": ");
            sb.append(WidgetPageTemplate._toJSON(description_i18n));
        }
        if ((friendlyUrlPath_i18n = this.getFriendlyUrlPath_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"friendlyUrlPath_i18n\": ");
            sb.append(WidgetPageTemplate._toJSON(friendlyUrlPath_i18n));
        }
        if ((hiddenFromNavigation = this.getHiddenFromNavigation()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"hiddenFromNavigation\": ");
            sb.append((Object)hiddenFromNavigation);
        }
        if ((name_i18n = this.getName_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name_i18n\": ");
            sb.append(WidgetPageTemplate._toJSON(name_i18n));
        }
        if ((creator = this.getCreator()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)creator);
        }
        if ((creatorExternalReferenceCode = this.getCreatorExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creatorExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(WidgetPageTemplate._escape(creatorExternalReferenceCode));
            sb.append("\"");
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((datePublished = this.getDatePublished()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"datePublished\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(datePublished));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(WidgetPageTemplate._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((key = this.getKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"key\": ");
            sb.append("\"");
            sb.append(WidgetPageTemplate._escape(key));
            sb.append("\"");
        }
        if ((keywords = this.getKeywords()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (int i = 0; i < keywords.length; ++i) {
                sb.append("\"");
                sb.append(WidgetPageTemplate._escape(keywords[i]));
                sb.append("\"");
                if (i + 1 >= keywords.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(WidgetPageTemplate._escape(name));
            sb.append("\"");
        }
        if ((pageSpecifications = this.getPageSpecifications()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageSpecifications\": ");
            sb.append("[");
            for (int i = 0; i < pageSpecifications.length; ++i) {
                sb.append(String.valueOf(pageSpecifications[i]));
                if (i + 1 >= pageSpecifications.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((pageTemplateSet = this.getPageTemplateSet()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageTemplateSet\": ");
            sb.append(String.valueOf(pageTemplateSet));
        }
        if ((pageTemplateSettings = this.getPageTemplateSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageTemplateSettings\": ");
            sb.append(String.valueOf(pageTemplateSettings));
        }
        if ((taxonomyCategoryItemExternalReferences = this.getTaxonomyCategoryItemExternalReferences()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryItemExternalReferences\": ");
            sb.append("[");
            for (int i = 0; i < taxonomyCategoryItemExternalReferences.length; ++i) {
                sb.append(String.valueOf(taxonomyCategoryItemExternalReferences[i]));
                if (i + 1 >= taxonomyCategoryItemExternalReferences.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)type);
            sb.append("\"");
        }
        if ((uuid = this.getUuid()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"uuid\": ");
            sb.append("\"");
            sb.append(WidgetPageTemplate._escape(uuid));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WidgetPageTemplate._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WidgetPageTemplate._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(WidgetPageTemplate._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WidgetPageTemplate._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WidgetPageTemplate._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

