/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.ClientExtension;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Represents the settings of a page specification.", value="Settings")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Settings")
public class Settings
implements Serializable {
    @GraphQLField(description="The page specification's color scheme name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page specification's color scheme name.") String colorSchemeName;
    @JsonIgnore
    private Supplier<String> _colorSchemeNameSupplier;
    @GraphQLField(description="The page specification's CSS.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page specification's CSS.") String css;
    @JsonIgnore
    private Supplier<String> _cssSupplier;
    @GraphQLField(description="The FavIcon of the page specification.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The FavIcon of the page specification.") Object favIcon;
    @JsonIgnore
    private Supplier<Object> _favIconSupplier;
    @GraphQLField(description="The client extensions for global CSS associated to the page.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The client extensions for global CSS associated to the page.") ClientExtension[] globalCSSClientExtensions;
    @JsonIgnore
    private Supplier<ClientExtension[]> _globalCSSClientExtensionsSupplier;
    @GraphQLField(description="The client extensions for global JS associated to the page.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The client extensions for global JS associated to the page.") ClientExtension[] globalJSClientExtensions;
    @JsonIgnore
    private Supplier<ClientExtension[]> _globalJSClientExtensionsSupplier;
    @GraphQLField(description="The page specification's JavaScript.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page specification's JavaScript.") String javascript;
    @JsonIgnore
    private Supplier<String> _javascriptSupplier;
    @GraphQLField(description="A reference to the page specification's master page. This property is not applied if the page specification belongs to a master page.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A reference to the page specification's master page. This property is not applied if the page specification belongs to a master page.") ItemExternalReference masterPageItemExternalReference;
    @JsonIgnore
    private Supplier<ItemExternalReference> _masterPageItemExternalReferenceSupplier;
    @GraphQLField(description="A reference to the style book that is applied to the page specification.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A reference to the style book that is applied to the page specification.") ItemExternalReference styleBookItemExternalReference;
    @JsonIgnore
    private Supplier<ItemExternalReference> _styleBookItemExternalReferenceSupplier;
    @GraphQLField(description="The client extension for the theme CSS of a page specification.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The client extension for the theme CSS of a page specification.") ClientExtension themeCSSClientExtension;
    @JsonIgnore
    private Supplier<ClientExtension> _themeCSSClientExtensionSupplier;
    @GraphQLField(description="The page specification's theme name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page specification's theme name.") String themeName;
    @JsonIgnore
    private Supplier<String> _themeNameSupplier;
    @GraphQLField(description="The page specification's theme settings.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page specification's theme settings.") Map<String, String> themeSettings;
    @JsonIgnore
    private Supplier<Map<String, String>> _themeSettingsSupplier;
    @GraphQLField(description="The client extension for the theme spritemap of a page specification.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The client extension for the theme spritemap of a page specification.") ClientExtension themeSpritemapClientExtension;
    @JsonIgnore
    private Supplier<ClientExtension> _themeSpritemapClientExtensionSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.Settings", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Settings toDTO(String json) {
        return (Settings)ObjectMapperUtil.readValue(Settings.class, (String)json);
    }

    public static Settings unsafeToDTO(String json) {
        return (Settings)ObjectMapperUtil.unsafeReadValue(Settings.class, (String)json);
    }

    @Schema(description="The page specification's color scheme name.")
    public String getColorSchemeName() {
        if (this._colorSchemeNameSupplier != null) {
            this.colorSchemeName = this._colorSchemeNameSupplier.get();
            this._colorSchemeNameSupplier = null;
        }
        return this.colorSchemeName;
    }

    public void setColorSchemeName(String colorSchemeName) {
        this.colorSchemeName = colorSchemeName;
        this._colorSchemeNameSupplier = null;
    }

    @JsonIgnore
    public void setColorSchemeName(UnsafeSupplier<String, Exception> colorSchemeNameUnsafeSupplier) {
        this._colorSchemeNameSupplier = () -> {
            try {
                return (String)colorSchemeNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page specification's CSS.")
    public String getCss() {
        if (this._cssSupplier != null) {
            this.css = this._cssSupplier.get();
            this._cssSupplier = null;
        }
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
        this._cssSupplier = null;
    }

    @JsonIgnore
    public void setCss(UnsafeSupplier<String, Exception> cssUnsafeSupplier) {
        this._cssSupplier = () -> {
            try {
                return (String)cssUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The FavIcon of the page specification.")
    @Valid
    public Object getFavIcon() {
        if (this._favIconSupplier != null) {
            this.favIcon = this._favIconSupplier.get();
            this._favIconSupplier = null;
        }
        return this.favIcon;
    }

    public void setFavIcon(Object favIcon) {
        this.favIcon = favIcon;
        this._favIconSupplier = null;
    }

    @JsonIgnore
    public void setFavIcon(UnsafeSupplier<Object, Exception> favIconUnsafeSupplier) {
        this._favIconSupplier = () -> {
            try {
                return favIconUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The client extensions for global CSS associated to the page.")
    @Valid
    public ClientExtension[] getGlobalCSSClientExtensions() {
        if (this._globalCSSClientExtensionsSupplier != null) {
            this.globalCSSClientExtensions = this._globalCSSClientExtensionsSupplier.get();
            this._globalCSSClientExtensionsSupplier = null;
        }
        return this.globalCSSClientExtensions;
    }

    public void setGlobalCSSClientExtensions(ClientExtension[] globalCSSClientExtensions) {
        this.globalCSSClientExtensions = globalCSSClientExtensions;
        this._globalCSSClientExtensionsSupplier = null;
    }

    @JsonIgnore
    public void setGlobalCSSClientExtensions(UnsafeSupplier<ClientExtension[], Exception> globalCSSClientExtensionsUnsafeSupplier) {
        this._globalCSSClientExtensionsSupplier = () -> {
            try {
                return (ClientExtension[])globalCSSClientExtensionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The client extensions for global JS associated to the page.")
    @Valid
    public ClientExtension[] getGlobalJSClientExtensions() {
        if (this._globalJSClientExtensionsSupplier != null) {
            this.globalJSClientExtensions = this._globalJSClientExtensionsSupplier.get();
            this._globalJSClientExtensionsSupplier = null;
        }
        return this.globalJSClientExtensions;
    }

    public void setGlobalJSClientExtensions(ClientExtension[] globalJSClientExtensions) {
        this.globalJSClientExtensions = globalJSClientExtensions;
        this._globalJSClientExtensionsSupplier = null;
    }

    @JsonIgnore
    public void setGlobalJSClientExtensions(UnsafeSupplier<ClientExtension[], Exception> globalJSClientExtensionsUnsafeSupplier) {
        this._globalJSClientExtensionsSupplier = () -> {
            try {
                return (ClientExtension[])globalJSClientExtensionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page specification's JavaScript.")
    public String getJavascript() {
        if (this._javascriptSupplier != null) {
            this.javascript = this._javascriptSupplier.get();
            this._javascriptSupplier = null;
        }
        return this.javascript;
    }

    public void setJavascript(String javascript) {
        this.javascript = javascript;
        this._javascriptSupplier = null;
    }

    @JsonIgnore
    public void setJavascript(UnsafeSupplier<String, Exception> javascriptUnsafeSupplier) {
        this._javascriptSupplier = () -> {
            try {
                return (String)javascriptUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A reference to the page specification's master page. This property is not applied if the page specification belongs to a master page.")
    @Valid
    public ItemExternalReference getMasterPageItemExternalReference() {
        if (this._masterPageItemExternalReferenceSupplier != null) {
            this.masterPageItemExternalReference = this._masterPageItemExternalReferenceSupplier.get();
            this._masterPageItemExternalReferenceSupplier = null;
        }
        return this.masterPageItemExternalReference;
    }

    public void setMasterPageItemExternalReference(ItemExternalReference masterPageItemExternalReference) {
        this.masterPageItemExternalReference = masterPageItemExternalReference;
        this._masterPageItemExternalReferenceSupplier = null;
    }

    @JsonIgnore
    public void setMasterPageItemExternalReference(UnsafeSupplier<ItemExternalReference, Exception> masterPageItemExternalReferenceUnsafeSupplier) {
        this._masterPageItemExternalReferenceSupplier = () -> {
            try {
                return (ItemExternalReference)masterPageItemExternalReferenceUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A reference to the style book that is applied to the page specification.")
    @Valid
    public ItemExternalReference getStyleBookItemExternalReference() {
        if (this._styleBookItemExternalReferenceSupplier != null) {
            this.styleBookItemExternalReference = this._styleBookItemExternalReferenceSupplier.get();
            this._styleBookItemExternalReferenceSupplier = null;
        }
        return this.styleBookItemExternalReference;
    }

    public void setStyleBookItemExternalReference(ItemExternalReference styleBookItemExternalReference) {
        this.styleBookItemExternalReference = styleBookItemExternalReference;
        this._styleBookItemExternalReferenceSupplier = null;
    }

    @JsonIgnore
    public void setStyleBookItemExternalReference(UnsafeSupplier<ItemExternalReference, Exception> styleBookItemExternalReferenceUnsafeSupplier) {
        this._styleBookItemExternalReferenceSupplier = () -> {
            try {
                return (ItemExternalReference)styleBookItemExternalReferenceUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The client extension for the theme CSS of a page specification.")
    @Valid
    public ClientExtension getThemeCSSClientExtension() {
        if (this._themeCSSClientExtensionSupplier != null) {
            this.themeCSSClientExtension = this._themeCSSClientExtensionSupplier.get();
            this._themeCSSClientExtensionSupplier = null;
        }
        return this.themeCSSClientExtension;
    }

    public void setThemeCSSClientExtension(ClientExtension themeCSSClientExtension) {
        this.themeCSSClientExtension = themeCSSClientExtension;
        this._themeCSSClientExtensionSupplier = null;
    }

    @JsonIgnore
    public void setThemeCSSClientExtension(UnsafeSupplier<ClientExtension, Exception> themeCSSClientExtensionUnsafeSupplier) {
        this._themeCSSClientExtensionSupplier = () -> {
            try {
                return (ClientExtension)themeCSSClientExtensionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page specification's theme name.")
    public String getThemeName() {
        if (this._themeNameSupplier != null) {
            this.themeName = this._themeNameSupplier.get();
            this._themeNameSupplier = null;
        }
        return this.themeName;
    }

    public void setThemeName(String themeName) {
        this.themeName = themeName;
        this._themeNameSupplier = null;
    }

    @JsonIgnore
    public void setThemeName(UnsafeSupplier<String, Exception> themeNameUnsafeSupplier) {
        this._themeNameSupplier = () -> {
            try {
                return (String)themeNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page specification's theme settings.")
    @Valid
    public Map<String, String> getThemeSettings() {
        if (this._themeSettingsSupplier != null) {
            this.themeSettings = this._themeSettingsSupplier.get();
            this._themeSettingsSupplier = null;
        }
        return this.themeSettings;
    }

    public void setThemeSettings(Map<String, String> themeSettings) {
        this.themeSettings = themeSettings;
        this._themeSettingsSupplier = null;
    }

    @JsonIgnore
    public void setThemeSettings(UnsafeSupplier<Map<String, String>, Exception> themeSettingsUnsafeSupplier) {
        this._themeSettingsSupplier = () -> {
            try {
                return (Map)themeSettingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The client extension for the theme spritemap of a page specification.")
    @Valid
    public ClientExtension getThemeSpritemapClientExtension() {
        if (this._themeSpritemapClientExtensionSupplier != null) {
            this.themeSpritemapClientExtension = this._themeSpritemapClientExtensionSupplier.get();
            this._themeSpritemapClientExtensionSupplier = null;
        }
        return this.themeSpritemapClientExtension;
    }

    public void setThemeSpritemapClientExtension(ClientExtension themeSpritemapClientExtension) {
        this.themeSpritemapClientExtension = themeSpritemapClientExtension;
        this._themeSpritemapClientExtensionSupplier = null;
    }

    @JsonIgnore
    public void setThemeSpritemapClientExtension(UnsafeSupplier<ClientExtension, Exception> themeSpritemapClientExtensionUnsafeSupplier) {
        this._themeSpritemapClientExtensionSupplier = () -> {
            try {
                return (ClientExtension)themeSpritemapClientExtensionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Settings)) {
            return false;
        }
        Settings settings = (Settings)object;
        return Objects.equals(this.toString(), settings.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        ClientExtension themeSpritemapClientExtension;
        Map<String, String> themeSettings;
        String themeName;
        ClientExtension themeCSSClientExtension;
        ItemExternalReference styleBookItemExternalReference;
        ItemExternalReference masterPageItemExternalReference;
        String javascript;
        ClientExtension[] globalJSClientExtensions;
        ClientExtension[] globalCSSClientExtensions;
        Object favIcon;
        String css;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String colorSchemeName = this.getColorSchemeName();
        if (colorSchemeName != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"colorSchemeName\": ");
            sb.append("\"");
            sb.append(Settings._escape(colorSchemeName));
            sb.append("\"");
        }
        if ((css = this.getCss()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"css\": ");
            sb.append("\"");
            sb.append(Settings._escape(css));
            sb.append("\"");
        }
        if ((favIcon = this.getFavIcon()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"favIcon\": ");
            if (favIcon instanceof Map) {
                sb.append((Object)JSONFactoryUtil.createJSONObject((Map)((Map)favIcon)));
            } else if (favIcon instanceof String) {
                sb.append("\"");
                sb.append(Settings._escape((String)favIcon));
                sb.append("\"");
            } else {
                sb.append(favIcon);
            }
        }
        if ((globalCSSClientExtensions = this.getGlobalCSSClientExtensions()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"globalCSSClientExtensions\": ");
            sb.append("[");
            for (int i = 0; i < globalCSSClientExtensions.length; ++i) {
                sb.append(String.valueOf(globalCSSClientExtensions[i]));
                if (i + 1 >= globalCSSClientExtensions.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((globalJSClientExtensions = this.getGlobalJSClientExtensions()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"globalJSClientExtensions\": ");
            sb.append("[");
            for (int i = 0; i < globalJSClientExtensions.length; ++i) {
                sb.append(String.valueOf(globalJSClientExtensions[i]));
                if (i + 1 >= globalJSClientExtensions.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((javascript = this.getJavascript()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"javascript\": ");
            sb.append("\"");
            sb.append(Settings._escape(javascript));
            sb.append("\"");
        }
        if ((masterPageItemExternalReference = this.getMasterPageItemExternalReference()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"masterPageItemExternalReference\": ");
            sb.append(String.valueOf(masterPageItemExternalReference));
        }
        if ((styleBookItemExternalReference = this.getStyleBookItemExternalReference()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"styleBookItemExternalReference\": ");
            sb.append(String.valueOf(styleBookItemExternalReference));
        }
        if ((themeCSSClientExtension = this.getThemeCSSClientExtension()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"themeCSSClientExtension\": ");
            sb.append(String.valueOf(themeCSSClientExtension));
        }
        if ((themeName = this.getThemeName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"themeName\": ");
            sb.append("\"");
            sb.append(Settings._escape(themeName));
            sb.append("\"");
        }
        if ((themeSettings = this.getThemeSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"themeSettings\": ");
            sb.append(Settings._toJSON(themeSettings));
        }
        if ((themeSpritemapClientExtension = this.getThemeSpritemapClientExtension()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"themeSpritemapClientExtension\": ");
            sb.append(String.valueOf(themeSpritemapClientExtension));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Settings._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Settings._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Settings._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Settings._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Settings._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

