/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.configuration.internal.resource.v1_0;

import com.liferay.configuration.admin.display.ConfigurationScreen;
import com.liferay.configuration.admin.exportimport.ConfigurationExportImportProcessor;
import com.liferay.configuration.admin.util.ConfigurationFilterStringUtil;
import com.liferay.headless.admin.configuration.dto.v1_0.SystemConfiguration;
import com.liferay.headless.admin.configuration.internal.resource.v1_0.BaseSystemConfigurationResourceImpl;
import com.liferay.headless.admin.configuration.internal.util.ConfigurationScreenUtil;
import com.liferay.headless.admin.configuration.internal.util.ConfigurationUtil;
import com.liferay.headless.admin.configuration.resource.v1_0.SystemConfigurationResource;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.pagination.Page;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/system-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={SystemConfigurationResource.class})
public class SystemConfigurationResourceImpl
extends BaseSystemConfigurationResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(SystemConfigurationResourceImpl.class);
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationExportImportProcessor _configurationExportImportProcessor;
    @Reference
    private Portal _portal;
    private ServiceTrackerMap<String, ConfigurationScreen> _serviceTrackerMap;
    @Reference
    private SettingsLocatorHelper _settingsLocatorHelper;

    @Override
    public SystemConfiguration getSystemConfiguration(String systemConfigurationExternalReferenceCode) throws Exception {
        this._checkFeatureFlag();
        this._checkPermission();
        this._validateDefaultCompany();
        ConfigurationScreen configurationScreen = (ConfigurationScreen)this._serviceTrackerMap.getService((Object)systemConfigurationExternalReferenceCode);
        if (configurationScreen != null) {
            return this._getConfigurationScreenSystemConfiguration(configurationScreen);
        }
        return this._getSystemConfiguration(systemConfigurationExternalReferenceCode);
    }

    @Override
    public Page<SystemConfiguration> getSystemConfigurationsPage() throws Exception {
        this._checkFeatureFlag();
        this._checkPermission();
        this._validateDefaultCompany();
        ArrayList<SystemConfiguration> systemConfigurations = new ArrayList<SystemConfiguration>();
        this._addSystemConfigurations(systemConfigurations);
        this._addConfigurationScreenSystemConfigurations(systemConfigurations);
        return Page.of(systemConfigurations);
    }

    @Override
    public SystemConfiguration postSystemConfiguration(SystemConfiguration systemConfiguration) throws Exception {
        return this.putSystemConfiguration(systemConfiguration.getExternalReferenceCode(), systemConfiguration);
    }

    @Override
    public SystemConfiguration putSystemConfiguration(String systemConfigurationExternalReferenceCode, SystemConfiguration systemConfiguration) throws Exception {
        this._checkFeatureFlag();
        this._checkPermission();
        this._validateDefaultCompany();
        ConfigurationScreen configurationScreen = (ConfigurationScreen)this._serviceTrackerMap.getService((Object)systemConfigurationExternalReferenceCode);
        if (configurationScreen != null) {
            return this._putConfigurationScreenSystemConfiguration(configurationScreen, systemConfiguration);
        }
        systemConfiguration.setExternalReferenceCode(() -> systemConfigurationExternalReferenceCode);
        return this._putSystemConfiguration(systemConfiguration);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ConfigurationScreenUtil.createServiceTracker(bundleContext, ExtendedObjectClassDefinition.Scope.SYSTEM);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private void _addConfigurationScreenSystemConfigurations(List<SystemConfiguration> systemConfigurations) {
        for (ConfigurationScreen configurationScreen : this._serviceTrackerMap.values()) {
            try {
                SystemConfiguration systemConfiguration = this._toSystemConfiguration(configurationScreen);
                Map properties = systemConfiguration.getProperties();
                if (properties.isEmpty()) continue;
                systemConfigurations.add(systemConfiguration);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Skipping configuration ", configurationScreen.getKey(), " because it does not have export capability"}), (Throwable)unsupportedOperationException);
            }
        }
    }

    private void _addSystemConfigurations(List<SystemConfiguration> systemConfigurations) throws Exception {
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getSystemScopedFilterString());
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            return;
        }
        for (Object configuration : configurations) {
            SystemConfiguration systemConfiguration = this._toSystemConfiguration((Configuration)configuration);
            if (systemConfiguration == null) continue;
            systemConfigurations.add(systemConfiguration);
        }
    }

    private void _checkFeatureFlag() {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-65399")) {
            throw new UnsupportedOperationException();
        }
    }

    private void _checkPermission() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            throw new NotAuthorizedException((Object)Response.Status.UNAUTHORIZED, new Object[0]);
        }
    }

    private SystemConfiguration _getConfigurationScreenSystemConfiguration(ConfigurationScreen configurationScreen) {
        try {
            SystemConfiguration systemConfiguration = this._toSystemConfiguration(configurationScreen);
            Map properties = systemConfiguration.getProperties();
            if (properties.isEmpty()) {
                throw new NotFoundException(StringBundler.concat((String[])new String[]{"Unable to find entry for system configuration with ", "external reference code: ", configurationScreen.getKey()}));
            }
            return systemConfiguration;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ServerErrorException(unsupportedOperationException.getMessage(), Response.Status.NOT_IMPLEMENTED);
        }
    }

    private SystemConfiguration _getSystemConfiguration(String systemConfigurationExternalReferenceCode) throws Exception {
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getSystemScopedFilterString((String)systemConfigurationExternalReferenceCode));
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            throw new NotFoundException(StringBundler.concat((String[])new String[]{"Unable to find entry for system configuration with ", "external reference code: ", systemConfigurationExternalReferenceCode}));
        }
        if (configurations.length > 1) {
            ArrayList<String> pids = new ArrayList<String>();
            for (Object configuration : configurations) {
                pids.add(configuration.getPid());
            }
            throw new BadRequestException(StringBundler.concat((String[])new String[]{systemConfigurationExternalReferenceCode, " is a factory configuration. Specify one of these PIDs: ", ListUtil.toString(pids, (String)"", (String)","), "."}));
        }
        return this._toSystemConfiguration((Configuration)configurations[0]);
    }

    private SystemConfiguration _putConfigurationScreenSystemConfiguration(ConfigurationScreen configurationScreen, SystemConfiguration systemConfiguration) {
        try {
            ConfigurationScreenUtil.importProperties(this._configurationExportImportProcessor, configurationScreen, (Dictionary<String, Object>)HashMapDictionaryBuilder.putAll((Map)systemConfiguration.getProperties()).build(), ExtendedObjectClassDefinition.Scope.SYSTEM, null);
            return this._toSystemConfiguration(configurationScreen);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ServerErrorException(unsupportedOperationException.getMessage(), Response.Status.NOT_IMPLEMENTED);
        }
        catch (Exception exception) {
            throw new BadRequestException(exception.getMessage());
        }
    }

    private SystemConfiguration _putSystemConfiguration(SystemConfiguration systemConfiguration) throws Exception {
        String filterString = ConfigurationFilterStringUtil.getSystemScopedFilterString((String)systemConfiguration.getExternalReferenceCode());
        try {
            Configuration configuration = ConfigurationUtil.addOrUpdateConfiguration(null, this._configurationAdmin, systemConfiguration.getExternalReferenceCode(), filterString, systemConfiguration.getProperties(), ExtendedObjectClassDefinition.Scope.SYSTEM, this._settingsLocatorHelper);
            if (configuration == null) {
                throw new NotFoundException(StringBundler.concat((String[])new String[]{"Unable to find system configuration with external ", "reference code: ", systemConfiguration.getExternalReferenceCode()}));
            }
            return this._toSystemConfiguration(configuration);
        }
        catch (ValidationException validationException) {
            throw new BadRequestException(validationException.getMessage());
        }
    }

    private SystemConfiguration _toSystemConfiguration(Configuration configuration) throws Exception {
        Map<String, Object> properties = ConfigurationUtil.getProperties(configuration, this._configurationExportImportProcessor, ExtendedObjectClassDefinition.Scope.SYSTEM, this._settingsLocatorHelper);
        if (properties.isEmpty()) {
            return null;
        }
        SystemConfiguration systemConfiguration = new SystemConfiguration();
        systemConfiguration.setExternalReferenceCode(() -> ((Configuration)configuration).getPid());
        systemConfiguration.setProperties(() -> properties);
        return systemConfiguration;
    }

    private SystemConfiguration _toSystemConfiguration(ConfigurationScreen configurationScreen) {
        SystemConfiguration systemConfiguration = new SystemConfiguration();
        systemConfiguration.setExternalReferenceCode(() -> ((ConfigurationScreen)configurationScreen).getKey());
        systemConfiguration.setProperties(() -> ConfigurationScreenUtil.getProperties(this._configurationExportImportProcessor, configurationScreen, ExtendedObjectClassDefinition.Scope.SYSTEM, null));
        return systemConfiguration;
    }

    private void _validateDefaultCompany() {
        if (this.contextCompany.getCompanyId() != this._portal.getDefaultCompanyId()) {
            throw new BadRequestException("You must be authenticated into the default company to manage system configurations");
        }
    }
}

