/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.configuration.internal.resource.v1_0;

import com.liferay.configuration.admin.display.ConfigurationScreen;
import com.liferay.configuration.admin.exportimport.ConfigurationExportImportProcessor;
import com.liferay.configuration.admin.util.ConfigurationFilterStringUtil;
import com.liferay.headless.admin.configuration.dto.v1_0.SiteConfiguration;
import com.liferay.headless.admin.configuration.internal.resource.v1_0.BaseSiteConfigurationResourceImpl;
import com.liferay.headless.admin.configuration.internal.util.ConfigurationScreenUtil;
import com.liferay.headless.admin.configuration.internal.util.ConfigurationUtil;
import com.liferay.headless.admin.configuration.resource.v1_0.SiteConfigurationResource;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.pagination.Page;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/site-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={SiteConfigurationResource.class})
public class SiteConfigurationResourceImpl
extends BaseSiteConfigurationResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(SiteConfigurationResourceImpl.class);
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationExportImportProcessor _configurationExportImportProcessor;
    @Reference
    private GroupLocalService _groupLocalService;
    private ServiceTrackerMap<String, ConfigurationScreen> _serviceTrackerMap;
    @Reference
    private SettingsLocatorHelper _settingsLocatorHelper;

    @Override
    public SiteConfiguration getSiteSiteConfiguration(String siteExternalReferenceCode, String siteConfigurationExternalReferenceCode) throws Exception {
        this._checkFeatureFlag();
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        this._checkPermission(group.getGroupId());
        ConfigurationScreen configurationScreen = (ConfigurationScreen)this._serviceTrackerMap.getService((Object)siteConfigurationExternalReferenceCode);
        if (configurationScreen != null) {
            return this._getConfigurationScreenSiteConfiguration(configurationScreen, group.getGroupId());
        }
        return this._getSiteSiteConfiguration(group.getGroupId(), siteConfigurationExternalReferenceCode, siteExternalReferenceCode);
    }

    @Override
    public Page<SiteConfiguration> getSiteSiteConfigurationsPage(String siteExternalReferenceCode) throws Exception {
        this._checkFeatureFlag();
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        this._checkPermission(group.getGroupId());
        ArrayList<SiteConfiguration> siteConfigurations = new ArrayList<SiteConfiguration>();
        this._addSiteConfigurations(group.getGroupId(), siteConfigurations, siteExternalReferenceCode);
        this._addConfigurationScreenSiteConfigurations(group.getGroupId(), siteConfigurations);
        return Page.of((Map)HashMapBuilder.put((Object)"createBatch", this.addAction("UPDATE", "postSiteSiteConfigurationBatch", Group.class.getName(), group.getGroupId())).build(), siteConfigurations);
    }

    @Override
    public SiteConfiguration postSiteSiteConfiguration(String siteExternalReferenceCode, SiteConfiguration siteConfiguration) throws Exception {
        return this.putSiteSiteConfiguration(siteExternalReferenceCode, siteConfiguration.getExternalReferenceCode(), siteConfiguration);
    }

    @Override
    public SiteConfiguration putSiteSiteConfiguration(String siteExternalReferenceCode, String siteConfigurationExternalReferenceCode, SiteConfiguration siteConfiguration) throws Exception {
        this._checkFeatureFlag();
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        long groupId = group.getGroupId();
        this._checkPermission(groupId);
        ConfigurationScreen configurationScreen = (ConfigurationScreen)this._serviceTrackerMap.getService((Object)siteConfigurationExternalReferenceCode);
        if (configurationScreen != null) {
            return this._putConfigurationScreenSiteConfiguration(siteConfiguration, configurationScreen, groupId);
        }
        siteConfiguration.setExternalReferenceCode(() -> siteConfigurationExternalReferenceCode);
        return this._putSiteConfiguration(groupId, siteConfiguration, siteExternalReferenceCode);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ConfigurationScreenUtil.createServiceTracker(bundleContext, ExtendedObjectClassDefinition.Scope.GROUP);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private void _addConfigurationScreenSiteConfigurations(long groupId, List<SiteConfiguration> siteConfigurations) {
        for (ConfigurationScreen configurationScreen : this._serviceTrackerMap.values()) {
            try {
                SiteConfiguration siteConfiguration = this._toSiteConfiguration(configurationScreen, groupId);
                Map properties = siteConfiguration.getProperties();
                if (properties.isEmpty()) continue;
                siteConfigurations.add(siteConfiguration);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Skipping configuration ", configurationScreen.getKey(), " because it does not have export capability"}), (Throwable)unsupportedOperationException);
            }
        }
    }

    private void _addSiteConfigurations(long groupId, List<SiteConfiguration> siteConfigurations, String siteExternalReferenceCode) throws Exception {
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getGroupScopedFilterString((String)String.valueOf(groupId), (String)siteExternalReferenceCode));
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            return;
        }
        for (Object configuration : configurations) {
            SiteConfiguration siteConfiguration = this._toSiteConfiguration((Configuration)configuration);
            if (siteConfiguration == null) continue;
            siteConfigurations.add(siteConfiguration);
        }
    }

    private void _checkFeatureFlag() {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-65399")) {
            throw new UnsupportedOperationException();
        }
    }

    private void _checkPermission(long groupId) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!(permissionChecker.isCompanyAdmin() || permissionChecker.isGroupAdmin(groupId) || permissionChecker.isOmniadmin())) {
            throw new NotAuthorizedException((Object)Response.Status.UNAUTHORIZED, new Object[0]);
        }
    }

    private SiteConfiguration _getConfigurationScreenSiteConfiguration(ConfigurationScreen configurationScreen, long groupId) {
        try {
            SiteConfiguration siteConfiguration = this._toSiteConfiguration(configurationScreen, groupId);
            Map properties = siteConfiguration.getProperties();
            if (properties.isEmpty()) {
                throw new NotFoundException(StringBundler.concat((String[])new String[]{"Unable to find entry for site configuration with ", "external reference code: ", configurationScreen.getKey()}));
            }
            return siteConfiguration;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ServerErrorException(unsupportedOperationException.getMessage(), Response.Status.NOT_IMPLEMENTED);
        }
    }

    private SiteConfiguration _getSiteSiteConfiguration(long groupId, String siteConfigurationExternalReferenceCode, String siteExternalReferenceCode) throws Exception {
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getGroupScopedFilterString((String)String.valueOf(groupId), (String)siteConfigurationExternalReferenceCode, (String)siteExternalReferenceCode));
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            throw new NotFoundException(StringBundler.concat((String[])new String[]{"Unable to find entry for site configuration with ", "external reference code: ", siteConfigurationExternalReferenceCode}));
        }
        if (configurations.length > 1) {
            ArrayList<String> pids = new ArrayList<String>();
            for (Object configuration : configurations) {
                pids.add(configuration.getPid());
            }
            throw new BadRequestException(StringBundler.concat((String[])new String[]{siteConfigurationExternalReferenceCode, " is a factory configuration. Specify one of these PIDs: ", ListUtil.toString(pids, (String)"", (String)","), "."}));
        }
        return this._toSiteConfiguration((Configuration)configurations[0]);
    }

    private SiteConfiguration _putConfigurationScreenSiteConfiguration(SiteConfiguration siteConfiguration, ConfigurationScreen configurationScreen, long groupId) {
        try {
            ConfigurationScreenUtil.importProperties(this._configurationExportImportProcessor, configurationScreen, (Dictionary<String, Object>)HashMapDictionaryBuilder.putAll((Map)siteConfiguration.getProperties()).build(), ExtendedObjectClassDefinition.Scope.GROUP, Long.valueOf(groupId));
            return this._toSiteConfiguration(configurationScreen, groupId);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ServerErrorException(unsupportedOperationException.getMessage(), Response.Status.NOT_IMPLEMENTED);
        }
        catch (Exception exception) {
            throw new BadRequestException(exception.getMessage());
        }
    }

    private SiteConfiguration _putSiteConfiguration(long groupId, SiteConfiguration siteConfiguration, String siteExternalReferenceCode) throws Exception {
        String filterString = ConfigurationFilterStringUtil.getGroupScopedFilterString((String)String.valueOf(groupId), (String)siteConfiguration.getExternalReferenceCode(), (String)siteExternalReferenceCode);
        try {
            Configuration configuration = ConfigurationUtil.addOrUpdateConfiguration(groupId, this._configurationAdmin, siteConfiguration.getExternalReferenceCode(), filterString, siteConfiguration.getProperties(), ExtendedObjectClassDefinition.Scope.GROUP, this._settingsLocatorHelper);
            if (configuration == null) {
                throw new NotFoundException(StringBundler.concat((String[])new String[]{"Unable to find site configuration with external ", "reference code: ", siteConfiguration.getExternalReferenceCode()}));
            }
            return this._toSiteConfiguration(configuration);
        }
        catch (ValidationException validationException) {
            throw new BadRequestException(validationException.getMessage());
        }
    }

    private SiteConfiguration _toSiteConfiguration(Configuration configuration) throws Exception {
        Map<String, Object> properties = ConfigurationUtil.getProperties(configuration, this._configurationExportImportProcessor, ExtendedObjectClassDefinition.Scope.GROUP, this._settingsLocatorHelper);
        if (properties.isEmpty()) {
            return null;
        }
        SiteConfiguration siteConfiguration = new SiteConfiguration();
        siteConfiguration.setExternalReferenceCode(() -> ((Configuration)configuration).getPid());
        siteConfiguration.setProperties(() -> properties);
        return siteConfiguration;
    }

    private SiteConfiguration _toSiteConfiguration(ConfigurationScreen configurationScreen, long groupId) {
        SiteConfiguration siteConfiguration = new SiteConfiguration();
        siteConfiguration.setExternalReferenceCode(() -> ((ConfigurationScreen)configurationScreen).getKey());
        siteConfiguration.setProperties(() -> ConfigurationScreenUtil.getProperties(this._configurationExportImportProcessor, configurationScreen, ExtendedObjectClassDefinition.Scope.GROUP, Long.valueOf(groupId)));
        return siteConfiguration;
    }
}

