/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.configuration.internal.resource.v1_0;

import com.liferay.configuration.admin.display.ConfigurationScreen;
import com.liferay.configuration.admin.exportimport.ConfigurationExportImportProcessor;
import com.liferay.configuration.admin.util.ConfigurationFilterStringUtil;
import com.liferay.headless.admin.configuration.dto.v1_0.InstanceConfiguration;
import com.liferay.headless.admin.configuration.internal.resource.v1_0.BaseInstanceConfigurationResourceImpl;
import com.liferay.headless.admin.configuration.internal.util.ConfigurationScreenUtil;
import com.liferay.headless.admin.configuration.internal.util.ConfigurationUtil;
import com.liferay.headless.admin.configuration.resource.v1_0.InstanceConfigurationResource;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.pagination.Page;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/instance-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={InstanceConfigurationResource.class})
public class InstanceConfigurationResourceImpl
extends BaseInstanceConfigurationResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(InstanceConfigurationResourceImpl.class);
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationExportImportProcessor _configurationExportImportProcessor;
    private ServiceTrackerMap<String, ConfigurationScreen> _serviceTrackerMap;
    @Reference
    private SettingsLocatorHelper _settingsLocatorHelper;

    @Override
    public InstanceConfiguration getInstanceConfiguration(String instanceConfigurationExternalReferenceCode) throws Exception {
        this._checkFeatureFlag();
        this._checkPermission();
        ConfigurationScreen configurationScreen = (ConfigurationScreen)this._serviceTrackerMap.getService((Object)instanceConfigurationExternalReferenceCode);
        if (configurationScreen != null) {
            return this._getConfigurationScreenInstanceConfiguration(configurationScreen);
        }
        return this._getInstanceConfiguration(instanceConfigurationExternalReferenceCode);
    }

    @Override
    public Page<InstanceConfiguration> getInstanceConfigurationsPage() throws Exception {
        this._checkFeatureFlag();
        this._checkPermission();
        ArrayList<InstanceConfiguration> instanceConfigurations = new ArrayList<InstanceConfiguration>();
        this._addInstanceConfigurations(instanceConfigurations);
        this._addConfigurationScreenInstanceConfigurations(instanceConfigurations);
        return Page.of(instanceConfigurations);
    }

    @Override
    public InstanceConfiguration postInstanceConfiguration(InstanceConfiguration instanceConfiguration) throws Exception {
        return this.putInstanceConfiguration(instanceConfiguration.getExternalReferenceCode(), instanceConfiguration);
    }

    @Override
    public InstanceConfiguration putInstanceConfiguration(String instanceConfigurationExternalReferenceCode, InstanceConfiguration instanceConfiguration) throws Exception {
        this._checkFeatureFlag();
        this._checkPermission();
        ConfigurationScreen configurationScreen = (ConfigurationScreen)this._serviceTrackerMap.getService((Object)instanceConfigurationExternalReferenceCode);
        if (configurationScreen != null) {
            return this._putConfigurationScreenInstanceConfiguration(configurationScreen, instanceConfiguration);
        }
        instanceConfiguration.setExternalReferenceCode(() -> instanceConfigurationExternalReferenceCode);
        return this._putInstanceConfiguration(instanceConfiguration);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ConfigurationScreenUtil.createServiceTracker(bundleContext, ExtendedObjectClassDefinition.Scope.COMPANY);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private void _addConfigurationScreenInstanceConfigurations(List<InstanceConfiguration> instanceConfigurations) {
        for (ConfigurationScreen configurationScreen : this._serviceTrackerMap.values()) {
            try {
                InstanceConfiguration instanceConfiguration = this._toInstanceConfiguration(configurationScreen);
                Map properties = instanceConfiguration.getProperties();
                if (properties.isEmpty()) continue;
                instanceConfigurations.add(instanceConfiguration);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Skipping configuration ", configurationScreen.getKey(), " because it does not have export capability"}), (Throwable)unsupportedOperationException);
            }
        }
    }

    private void _addInstanceConfigurations(List<InstanceConfiguration> instanceConfigurations) throws Exception {
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getCompanyScopedFilterString((String)String.valueOf(this.contextCompany.getCompanyId()), (String)this.contextCompany.getDefaultWebId()));
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            return;
        }
        for (Object configuration : configurations) {
            InstanceConfiguration instanceConfiguration = this._toInstanceConfiguration((Configuration)configuration);
            if (instanceConfiguration == null) continue;
            instanceConfigurations.add(instanceConfiguration);
        }
    }

    private void _checkFeatureFlag() {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-65399")) {
            throw new UnsupportedOperationException();
        }
    }

    private void _checkPermission() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin() && !permissionChecker.isOmniadmin()) {
            throw new NotAuthorizedException((Object)Response.Status.UNAUTHORIZED, new Object[0]);
        }
    }

    private InstanceConfiguration _getConfigurationScreenInstanceConfiguration(ConfigurationScreen configurationScreen) {
        try {
            InstanceConfiguration instanceConfiguration = this._toInstanceConfiguration(configurationScreen);
            Map properties = instanceConfiguration.getProperties();
            if (properties.isEmpty()) {
                throw new NotFoundException(StringBundler.concat((String[])new String[]{"Unable to find entry for instance configuration with ", "external reference code: ", configurationScreen.getKey()}));
            }
            return instanceConfiguration;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ServerErrorException(unsupportedOperationException.getMessage(), Response.Status.NOT_IMPLEMENTED);
        }
    }

    private InstanceConfiguration _getInstanceConfiguration(String instanceConfigurationExternalReferenceCode) throws Exception {
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getCompanyScopedFilterString((String)String.valueOf(this.contextCompany.getCompanyId()), (String)instanceConfigurationExternalReferenceCode, (String)this.contextCompany.getDefaultWebId()));
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            throw new NotFoundException(StringBundler.concat((String[])new String[]{"Unable to find entry for instance configuration with ", "external reference code: ", instanceConfigurationExternalReferenceCode}));
        }
        if (configurations.length > 1) {
            ArrayList<String> pids = new ArrayList<String>();
            for (Object configuration : configurations) {
                pids.add(configuration.getPid());
            }
            throw new BadRequestException(StringBundler.concat((String[])new String[]{instanceConfigurationExternalReferenceCode, " is a factory configuration. Specify one of these PIDs: ", ListUtil.toString(pids, (String)"", (String)","), "."}));
        }
        return this._toInstanceConfiguration((Configuration)configurations[0]);
    }

    private InstanceConfiguration _putConfigurationScreenInstanceConfiguration(ConfigurationScreen configurationScreen, InstanceConfiguration instanceConfiguration) {
        try {
            ConfigurationScreenUtil.importProperties(this._configurationExportImportProcessor, configurationScreen, (Dictionary<String, Object>)HashMapDictionaryBuilder.putAll((Map)instanceConfiguration.getProperties()).build(), ExtendedObjectClassDefinition.Scope.COMPANY, Long.valueOf(this.contextCompany.getCompanyId()));
            return this._toInstanceConfiguration(configurationScreen);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ServerErrorException(unsupportedOperationException.getMessage(), Response.Status.NOT_IMPLEMENTED);
        }
        catch (Exception exception) {
            throw new BadRequestException(exception.getMessage());
        }
    }

    private InstanceConfiguration _putInstanceConfiguration(InstanceConfiguration instanceConfiguration) throws Exception {
        long companyId = this.contextCompany.getCompanyId();
        String filterString = ConfigurationFilterStringUtil.getCompanyScopedFilterString((String)String.valueOf(companyId), (String)instanceConfiguration.getExternalReferenceCode(), (String)this.contextCompany.getDefaultWebId());
        try {
            Configuration configuration = ConfigurationUtil.addOrUpdateConfiguration(companyId, this._configurationAdmin, instanceConfiguration.getExternalReferenceCode(), filterString, instanceConfiguration.getProperties(), ExtendedObjectClassDefinition.Scope.COMPANY, this._settingsLocatorHelper);
            if (configuration == null) {
                throw new NotFoundException(StringBundler.concat((String[])new String[]{"Unable to find instance configuration with external ", "reference code: ", instanceConfiguration.getExternalReferenceCode()}));
            }
            return this._toInstanceConfiguration(configuration);
        }
        catch (ValidationException validationException) {
            throw new BadRequestException(validationException.getMessage());
        }
    }

    private InstanceConfiguration _toInstanceConfiguration(Configuration configuration) throws Exception {
        Map<String, Object> properties = ConfigurationUtil.getProperties(configuration, this._configurationExportImportProcessor, ExtendedObjectClassDefinition.Scope.COMPANY, this._settingsLocatorHelper);
        if (properties.isEmpty()) {
            return null;
        }
        InstanceConfiguration instanceConfiguration = new InstanceConfiguration();
        instanceConfiguration.setExternalReferenceCode(() -> ((Configuration)configuration).getPid());
        instanceConfiguration.setProperties(() -> properties);
        return instanceConfiguration;
    }

    private InstanceConfiguration _toInstanceConfiguration(ConfigurationScreen configurationScreen) {
        InstanceConfiguration instanceConfiguration = new InstanceConfiguration();
        instanceConfiguration.setExternalReferenceCode(() -> ((ConfigurationScreen)configurationScreen).getKey());
        instanceConfiguration.setProperties(() -> ConfigurationScreenUtil.getProperties(this._configurationExportImportProcessor, configurationScreen, ExtendedObjectClassDefinition.Scope.COMPANY, Long.valueOf(this.contextCompany.getCompanyId())));
        return instanceConfiguration;
    }
}

