/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.configuration.internal.resource.v1_0;

import com.liferay.configuration.admin.exportimport.ConfigurationExportImportProcessor;
import com.liferay.configuration.admin.util.ConfigurationFilterStringUtil;
import com.liferay.headless.admin.configuration.dto.v1_0.SystemConfiguration;
import com.liferay.headless.admin.configuration.internal.resource.v1_0.BaseSystemConfigurationResourceImpl;
import com.liferay.headless.admin.configuration.internal.util.ConfigurationUtil;
import com.liferay.headless.admin.configuration.resource.v1_0.SystemConfigurationResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.pagination.Page;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/system-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={SystemConfigurationResource.class})
public class SystemConfigurationResourceImpl
extends BaseSystemConfigurationResourceImpl {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationExportImportProcessor _configurationExportImportProcessor;
    @Reference
    private Portal _portal;
    @Reference
    private SettingsLocatorHelper _settingsLocatorHelper;

    @Override
    public SystemConfiguration getSystemConfiguration(String systemConfigurationExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-65399")) {
            throw new UnsupportedOperationException();
        }
        this._checkPermission();
        this._validateDefaultCompany();
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getSystemScopedFilterString((String)systemConfigurationExternalReferenceCode));
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            throw new NotFoundException("Unable to find system configuration with external reference code " + systemConfigurationExternalReferenceCode);
        }
        if (configurations.length > 1) {
            ArrayList<String> pids = new ArrayList<String>();
            for (Object configuration : configurations) {
                pids.add(configuration.getPid());
            }
            throw new BadRequestException(StringBundler.concat((String[])new String[]{systemConfigurationExternalReferenceCode, " is a factory configuration. Specify one of these PIDs: ", ListUtil.toString(pids, (String)"", (String)","), "."}));
        }
        return this._toSystemConfiguration((Configuration)configurations[0]);
    }

    @Override
    public Page<SystemConfiguration> getSystemConfigurationsPage() throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-65399")) {
            throw new UnsupportedOperationException();
        }
        this._checkPermission();
        this._validateDefaultCompany();
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getSystemScopedFilterString());
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            return Page.of(Collections.emptyList());
        }
        ArrayList<SystemConfiguration> systemConfigurations = new ArrayList<SystemConfiguration>();
        for (Object configuration : configurations) {
            SystemConfiguration systemConfiguration = this._toSystemConfiguration((Configuration)configuration);
            if (systemConfiguration == null) continue;
            systemConfigurations.add(systemConfiguration);
        }
        return Page.of(systemConfigurations);
    }

    private void _checkPermission() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            throw new NotAuthorizedException((Object)Response.Status.UNAUTHORIZED, new Object[0]);
        }
    }

    private SystemConfiguration _toSystemConfiguration(Configuration configuration) throws Exception {
        Map<String, Object> properties = ConfigurationUtil.getProperties(configuration, this._configurationExportImportProcessor, this._settingsLocatorHelper);
        if (properties.isEmpty()) {
            return null;
        }
        SystemConfiguration systemConfiguration = new SystemConfiguration();
        systemConfiguration.setExternalReferenceCode(() -> ((Configuration)configuration).getPid());
        systemConfiguration.setProperties(() -> properties);
        return systemConfiguration;
    }

    private void _validateDefaultCompany() {
        if (this.contextCompany.getCompanyId() != this._portal.getDefaultCompanyId()) {
            throw new BadRequestException("You must be authenticated into the default company to manage system configurations");
        }
    }
}

