/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.util;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;

public class GradleUtil
extends com.liferay.gradle.util.GradleUtil {
    public static final String PORTAL_TOOL_GROUP = "com.liferay";
    public static final String SNAPSHOT_PROPERTY_NAME = "snapshot";
    private static final String _SNAPSHOT_VERSION_SUFFIX = "-SNAPSHOT";
    private static final Properties _portalToolVersions = new Properties();

    public static <T extends Task> T addTask(Project project, String name, Class<T> clazz, boolean overwrite) {
        HashMap<String, Constable> args = new HashMap<String, Constable>();
        args.put("overwrite", Boolean.valueOf(overwrite));
        args.put("type", clazz);
        return (T)project.task(args, name);
    }

    public static String getArchivesBaseName(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        return basePluginConvention.getArchivesBaseName();
    }

    public static String getPortalToolVersion(Project project, String portalToolName) {
        String portalToolVersion = _portalToolVersions.getProperty(portalToolName);
        return GradleUtil.getProperty((ExtensionAware)project, (String)(portalToolName + ".version"), (String)portalToolVersion);
    }

    public static File getRootDir(Project project, String markerFileName) {
        File dir = project.getProjectDir();
        do {
            File markerFile;
            if (!(markerFile = new File(dir, markerFileName)).exists()) continue;
            return dir;
        } while ((dir = dir.getParentFile()) != null);
        return null;
    }

    public static File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    public static Thread[] getThreads() {
        Thread currentThread = Thread.currentThread();
        ThreadGroup threadGroup = currentThread.getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        int threadCountGuess = threadGroup.activeCount();
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = threadGroup.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = threadGroup.enumerate(threads);
        }
        return threads;
    }

    public static boolean hasPlugin(Project project, Class<? extends Plugin<?>> pluginClass) {
        PluginContainer pluginContainer = project.getPlugins();
        return pluginContainer.hasPlugin(pluginClass);
    }

    public static boolean hasPlugin(Project project, String pluginId) {
        PluginContainer pluginContainer = project.getPlugins();
        return pluginContainer.hasPlugin(pluginId);
    }

    public static boolean hasStartParameterTask(Project project, String taskName) {
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        List taskNames = startParameter.getTaskNames();
        return taskNames.contains(taskName);
    }

    public static boolean isFromMavenLocal(Project project, File file) {
        RepositoryHandler repositoryHandler = project.getRepositories();
        ArtifactRepository artifactRepository = (ArtifactRepository)repositoryHandler.findByName("MavenLocal");
        if (!(artifactRepository instanceof MavenArtifactRepository)) {
            return false;
        }
        MavenArtifactRepository mavenArtifactRepository = (MavenArtifactRepository)artifactRepository;
        Path repositoryPath = Paths.get(mavenArtifactRepository.getUrl());
        return FileUtil.isChild((File)file, (File)repositoryPath.toFile());
    }

    public static boolean isRunningInsideDaemon() {
        for (Thread thread : GradleUtil.getThreads()) {
            String name;
            if (thread == null || !(name = thread.getName()).startsWith("Daemon worker")) continue;
            return true;
        }
        return false;
    }

    public static boolean isSnapshot(Project project) {
        String version = String.valueOf(project.getVersion());
        return version.endsWith(_SNAPSHOT_VERSION_SUFFIX);
    }

    public static boolean replaceCopySpecSourcePath(CopySpec copySpec, Object oldSourcePath, Object newSourcePath) {
        DefaultCopySpec defaultCopySpec;
        Set sourcePaths;
        if (copySpec instanceof DefaultCopySpec && (sourcePaths = (defaultCopySpec = (DefaultCopySpec)copySpec).getSourcePaths()).remove(oldSourcePath)) {
            sourcePaths.add(newSourcePath);
            return true;
        }
        if (copySpec instanceof CopySpecInternal) {
            CopySpecInternal copySpecInternal = (CopySpecInternal)copySpec;
            for (CopySpec childCopySpec : copySpecInternal.getChildren()) {
                boolean replaced = GradleUtil.replaceCopySpecSourcePath(childCopySpec, oldSourcePath, newSourcePath);
                if (!replaced) continue;
                return true;
            }
        }
        return false;
    }

    public static void setProjectSnapshotVersion(Project project) {
        boolean snapshot = false;
        if (project.hasProperty(SNAPSHOT_PROPERTY_NAME)) {
            snapshot = GradleUtil.getProperty((ExtensionAware)project, (String)SNAPSHOT_PROPERTY_NAME, (boolean)true);
        }
        String version = String.valueOf(project.getVersion());
        if (snapshot && !version.endsWith(_SNAPSHOT_VERSION_SUFFIX)) {
            project.setVersion((Object)(version + _SNAPSHOT_VERSION_SUFFIX));
        }
    }

    public static Map<String, String> toStringMap(Map<String, ?> map) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = GradleUtil.toString(entry.getValue());
            stringMap.put(key, value);
        }
        return stringMap;
    }

    public static <P extends Plugin<? extends Project>> void withPlugin(Project project, Class<P> pluginClass, Action<P> action) {
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(pluginClass, action);
    }

    static {
        ClassLoader classLoader = BasePortalToolDefaultsPlugin.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("com/liferay/gradle/plugins/dependencies/portal-tools.properties");){
            _portalToolVersions.load(inputStream);
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe);
        }
    }
}

