/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.util;

import com.liferay.gradle.util.ArrayUtil;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashMap;
import org.gradle.api.AntBuilder;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskInputs;

public class FileUtil
extends com.liferay.gradle.util.FileUtil {
    private static final Logger _logger = Logging.getLogger(FileUtil.class);

    public static File[] getDirectories(File dir) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    public static FileTree getJarsFileTree(Project project, File dir, String ... excludes) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", dir);
        if (ArrayUtil.isNotEmpty((Object[])excludes)) {
            args.put("excludes", Arrays.asList(excludes));
        }
        args.put("include", "*.jar");
        return project.fileTree(args);
    }

    public static String getRelativePath(Project project, File file) {
        String relativePath = project.relativePath((Object)file);
        return relativePath.replace('\\', '/');
    }

    public static boolean hasSourceFiles(Task task, Spec<File> spec) {
        TaskInputs taskInputs = task.getInputs();
        FileCollection fileCollection = taskInputs.getSourceFiles();
        return !(fileCollection = fileCollection.filter(spec)).isEmpty();
    }

    public static FileCollection join(FileCollection ... fileCollections) {
        FileCollection joinedFileCollection = null;
        for (FileCollection fileCollection : fileCollections) {
            joinedFileCollection = joinedFileCollection == null ? fileCollection : joinedFileCollection.plus(fileCollection);
        }
        return joinedFileCollection;
    }

    public static void touchFile(File file, long time) {
        boolean success = file.setLastModified(time);
        if (!success) {
            _logger.error("Unable to touch " + file);
        }
    }

    public static void touchFiles(Project project, File dir, long time, String ... includes) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", dir);
        args.put("includes", Arrays.asList(includes));
        ConfigurableFileTree fileTree = project.fileTree(args);
        for (File file : fileTree) {
            FileUtil.touchFile(file, time);
        }
    }

    public static void unzip(Project project, final File file, final File destinationDir) {
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall(AntBuilder antBuilder) {
                FileUtil._invokeAntMethodUnzip(antBuilder, file, destinationDir);
            }
        };
        project.ant((Closure)closure);
    }

    private static void _invokeAntMethodUnzip(AntBuilder antBuilder, File file, File destinationDir) {
        HashMap<String, File> args = new HashMap<String, File>();
        args.put("dest", destinationDir);
        args.put("src", file);
        antBuilder.invokeMethod("unzip", args);
    }
}

