/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.util.GradleUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

public class WritePropertiesTask
extends DefaultTask {
    private Object _outputFile;
    private final Map<String, Object> _properties = new TreeMap<String, Object>();

    @Input
    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    @Input
    @SkipWhenEmpty
    public Map<String, Object> getProperties() {
        return this._properties;
    }

    public WritePropertiesTask properties(Map<String, ?> properties) {
        this._properties.putAll(properties);
        return this;
    }

    public WritePropertiesTask property(String key, Object value) {
        this._properties.put(key, value);
        return this;
    }

    public void setOutputFile(Object outputFile) {
        this._outputFile = outputFile;
    }

    public void setProperties(Map<String, ?> properties) {
        this._properties.clear();
        this.properties(properties);
    }

    @TaskAction
    public void writeProperties() throws IOException {
        File outputFile = this.getOutputFile();
        File outputDir = outputFile.getParentFile();
        outputDir.mkdirs();
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(outputFile.toPath(), StandardCharsets.ISO_8859_1, new OpenOption[0]);){
            Map<String, Object> properties = this.getProperties();
            boolean firstLine = true;
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                String value = GradleUtil.toString((Object)entry.getValue());
                if (firstLine) {
                    firstLine = false;
                } else {
                    bufferedWriter.newLine();
                }
                bufferedWriter.write(key);
                bufferedWriter.write(61);
                bufferedWriter.write(value);
            }
        }
    }
}

