/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.change.log.builder.BuildChangeLogTask;
import com.liferay.gradle.plugins.tasks.BaselineTask;
import com.liferay.gradle.plugins.util.FileUtil;
import com.liferay.gradle.plugins.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GUtil;
import org.gradle.util.VersionNumber;

public class PrintArtifactPublishCommandsTask
extends DefaultTask {
    public static final String IGNORED_MESSAGE_PATTERN = "artifact:ignore";
    private Object _artifactPropertiesFile;
    private boolean _firstOnly;
    private Object _firstPublishExcludedTaskName;
    private boolean _gradleDaemon;
    private Object _gradleDir;
    private Object _lowestPublishedVersion = "1.0.0";
    private final Set<Object> _prepNextFiles = new LinkedHashSet<Object>();

    public PrintArtifactPublishCommandsTask() {
        String firstOnlyString = GradleUtil.getTaskPrefixedProperty((Task)this, (String)"first");
        if (Validator.isNotNull((String)firstOnlyString)) {
            this._firstOnly = Boolean.parseBoolean(firstOnlyString);
        }
        this._gradleDaemon = true;
        String gradleDaemonString = GradleUtil.getTaskPrefixedProperty((Task)this, (String)"daemon");
        if (Validator.isNotNull((String)gradleDaemonString)) {
            this._gradleDaemon = Boolean.parseBoolean(gradleDaemonString);
        }
        Project project = this.getProject();
        this._gradleDir = GradleUtil.getRootDir(project.getRootProject(), "gradlew");
    }

    @Input
    @Optional
    public File getArtifactPropertiesFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._artifactPropertiesFile);
    }

    @Input
    @Optional
    public String getFirstPublishExcludedTaskName() {
        return GradleUtil.toString((Object)this._firstPublishExcludedTaskName);
    }

    @Input
    public File getGradleDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._gradleDir);
    }

    @Input
    public String getLowestPublishedVersion() {
        return GradleUtil.toString((Object)this._lowestPublishedVersion);
    }

    @Input
    public FileCollection getPrepNextFiles() {
        Project project = this.getProject();
        return project.files(new Object[]{this._prepNextFiles});
    }

    public boolean isFirstOnly() {
        return this._firstOnly;
    }

    @Input
    public boolean isGradleDaemon() {
        return this._gradleDaemon;
    }

    public PrintArtifactPublishCommandsTask prepNextFiles(Iterable<?> prepNextFiles) {
        GUtil.addToCollection(this._prepNextFiles, (Iterable[])new Iterable[]{prepNextFiles});
        return this;
    }

    public PrintArtifactPublishCommandsTask prepNextFiles(Object ... prepNextFiles) {
        return this.prepNextFiles(Arrays.asList(prepNextFiles));
    }

    @TaskAction
    public void printArtifactPublishCommands() {
        Task baselineTask;
        BuildChangeLogTask buildChangeLogTask;
        ArrayList<String> commands = new ArrayList<String>();
        Project project = this.getProject();
        commands.add("cd " + FileUtil.getAbsolutePath((File)project.getRootDir()));
        if (!this.isPublished()) {
            this.addPublishCommands(commands, true);
        }
        if ((buildChangeLogTask = (BuildChangeLogTask)this.getTask("buildChangeLog")) != null) {
            commands.add(this.getGradleCommand((Task)buildChangeLogTask, new String[0]));
            commands.add("git add " + this.getRelativePath(buildChangeLogTask.getChangeLogFile()));
            commands.add(this.getGitCommitCommand("change log", false, true, true));
        }
        if ((baselineTask = this.getTask("baseline")) instanceof BaselineTask) {
            commands.add(this.getGradleCommand(baselineTask, new String[0]));
            commands.add("git add --all " + this.getRelativePath(project.getProjectDir()));
            commands.add(this.getGitCommitCommand("packageinfo", false, false, true));
        }
        if (baselineTask != null || buildChangeLogTask != null) {
            this.addPublishCommands(commands, false);
        }
        System.out.println();
        for (String command : commands) {
            System.out.print(" && ");
            System.out.print(command);
        }
        if (this.isFirstOnly()) {
            throw new GradleException();
        }
    }

    public void setArtifactPropertiesFile(Object artifactPropertiesFile) {
        this._artifactPropertiesFile = artifactPropertiesFile;
    }

    public void setFirstOnly(boolean firstOnly) {
        this._firstOnly = firstOnly;
    }

    public void setFirstPublishExcludedTaskName(Object firstPublishExcludedTaskName) {
        this._firstPublishExcludedTaskName = firstPublishExcludedTaskName;
    }

    public void setGradleDaemon(boolean gradleDaemon) {
        this._gradleDaemon = gradleDaemon;
    }

    public void setGradleDir(Object gradleDir) {
        this._gradleDir = gradleDir;
    }

    public void setLowestPublishedVersion(Object lowestPublishedVersion) {
        this._lowestPublishedVersion = lowestPublishedVersion;
    }

    public void setPrepNextFiles(Iterable<?> prepNextFiles) {
        this._prepNextFiles.clear();
        this.prepNextFiles(prepNextFiles);
    }

    public void setPrepNextFiles(Object ... prepNextFiles) {
        this.setPrepNextFiles(Arrays.asList(prepNextFiles));
    }

    protected void addPublishCommands(List<String> commands, boolean firstPublish) {
        File artifactPropertiesFile;
        Task task;
        commands.add(this.getGradleCommand("uploadArchives", "-Psnapshot"));
        String[] arguments = new String[]{};
        if (firstPublish && (task = this.getTask(this.getFirstPublishExcludedTaskName())) != null) {
            arguments = new String[]{"-x", task.getPath()};
        }
        commands.add(this.getGradleCommand("uploadArchives", arguments));
        boolean prepNext = false;
        for (File file : this.getPrepNextFiles()) {
            if (!file.exists()) continue;
            prepNext = true;
            commands.add("git add " + this.getRelativePath(file));
        }
        if (prepNext) {
            commands.add(this.getGitCommitCommand("prep next", false, true, false));
        }
        if ((artifactPropertiesFile = this.getArtifactPropertiesFile()) != null) {
            commands.add("git add " + this.getRelativePath(artifactPropertiesFile));
            commands.add(this.getGitCommitCommand("artifact properties", false, true, false));
        }
        commands.add(this.getGitCommitCommand("apply", true, false, true));
    }

    protected String getGitCommitCommand(String message, boolean all, boolean ignored, boolean quiet) {
        StringBuilder sb = new StringBuilder();
        Project project = this.getProject();
        if (all || quiet) {
            sb.append("(git diff-index --quiet HEAD || ");
        }
        sb.append("git commit ");
        if (all) {
            sb.append("--all ");
        }
        sb.append("--message=\"");
        if (ignored) {
            sb.append(IGNORED_MESSAGE_PATTERN);
            sb.append(' ');
        }
        sb.append(project.getName());
        sb.append(' ');
        sb.append(project.getVersion());
        sb.append(' ');
        sb.append(message);
        sb.append('\"');
        if (all || quiet) {
            sb.append(')');
        }
        return sb.toString();
    }

    protected String getGradleCommand(String taskName, String ... arguments) {
        Task task = GradleUtil.getTask((Project)this.getProject(), (String)taskName);
        return this.getGradleCommand(task, arguments);
    }

    protected String getGradleCommand(Task task, String ... arguments) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGradleRelativePath());
        sb.append(' ');
        sb.append(task.getPath());
        if (this.isGradleDaemon()) {
            sb.append(" --daemon");
        }
        for (String argument : arguments) {
            sb.append(' ');
            sb.append(argument);
        }
        return sb.toString();
    }

    protected File getGradleFile() {
        return new File(this.getGradleDir(), "gradlew");
    }

    protected String getGradleRelativePath() {
        return this.getRelativePath(this.getGradleFile());
    }

    protected String getRelativePath(Object object) {
        Project project = this.getProject();
        File file = project.file(object);
        Project rootProject = project.getRootProject();
        return rootProject.relativePath((Object)file);
    }

    protected Task getTask(String name) {
        if (Validator.isNull((String)name)) {
            return null;
        }
        Project project = this.getProject();
        TaskContainer taskContainer = project.getTasks();
        return (Task)taskContainer.findByName(name);
    }

    protected boolean isPublished() {
        VersionNumber lowestPublishedVersionNumber;
        Project project = this.getProject();
        String version = String.valueOf(project.getVersion());
        VersionNumber versionNumber = VersionNumber.parse((String)version);
        return versionNumber.compareTo(lowestPublishedVersionNumber = VersionNumber.parse((String)this.getLowestPublishedVersion())) > 0;
    }
}

