/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.util.GradleUtil;
import com.liferay.gradle.util.ArrayUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GUtil;

public class CompileThemeTask
extends DefaultTask {
    private static final String[] _PORTAL_THEMES = new String[]{"_styled", "_unstyled", "admin", "classic"};
    private static final String[] _THEME_DIR_NAMES = new String[]{"css", "images", "js", "templates"};
    private Object _diffsDir;
    private FileCollection _frontendThemeFiles;
    private Object _frontendThemesWebDir;
    private final Project _project;
    private Object _themeParent;
    private Project _themeParentProject;
    private Object _themeRootDir;
    private final Set<String> _themeTypes = new HashSet<String>();

    public CompileThemeTask() {
        this._project = this.getProject();
    }

    @TaskAction
    public void compileTheme() throws Exception {
        this.copyThemeParent();
        this.copyDiffs();
    }

    @InputDirectory
    @Optional
    public File getDiffsDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._diffsDir);
    }

    @InputFiles
    @Optional
    public FileCollection getFrontendThemeFiles() {
        return this._frontendThemeFiles;
    }

    @InputDirectory
    @Optional
    public File getFrontendThemesWebDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._frontendThemesWebDir);
    }

    @OutputDirectories
    public FileCollection getThemeDirs() {
        if (this.getDiffsDir() == null) {
            return this._project.files(new Object[0]);
        }
        ArrayList<File> themeDirs = new ArrayList<File>(_THEME_DIR_NAMES.length);
        File themeRootDir = this.getThemeRootDir();
        for (String dirName : _THEME_DIR_NAMES) {
            File dir = new File(themeRootDir, dirName);
            themeDirs.add(dir);
        }
        return this._project.files(new Object[]{themeDirs});
    }

    @Input
    @Optional
    public String getThemeParent() {
        return GradleUtil.toString((Object)this._themeParent);
    }

    public Project getThemeParentProject() {
        String themeParent = this.getThemeParent();
        if (Validator.isNull((String)themeParent) || ArrayUtil.contains((Object[])_PORTAL_THEMES, (Object)themeParent)) {
            return null;
        }
        if (this._themeParentProject == null) {
            File themeParentDir = this._project.file((Object)themeParent);
            this._themeParentProject = GradleUtil.getProject((Project)this._project.getRootProject(), (File)themeParentDir);
        }
        return this._themeParentProject;
    }

    public File getThemeRootDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._themeRootDir);
    }

    @Input
    public Set<String> getThemeTypes() {
        return this._themeTypes;
    }

    public void setDiffsDir(Object diffsDir) {
        this._diffsDir = diffsDir;
    }

    public void setFrontendThemeFiles(FileCollection frontendThemeFiles) {
        this._frontendThemeFiles = frontendThemeFiles;
    }

    public void setFrontendThemesWebDir(Object frontendThemesWebDir) {
        this._frontendThemesWebDir = frontendThemesWebDir;
    }

    public void setThemeParent(Object themeParent) {
        this._themeParent = themeParent;
        this._themeParentProject = null;
    }

    public void setThemeRootDir(Object themeRootDir) {
        this._themeRootDir = themeRootDir;
    }

    public void setThemeTypes(Iterable<String> themeTypes) {
        this._themeTypes.clear();
        this.themeTypes(themeTypes);
    }

    public CompileThemeTask themeTypes(Iterable<String> themeTypes) {
        GUtil.addToCollection(this._themeTypes, (Iterable[])new Iterable[]{themeTypes});
        return this;
    }

    public CompileThemeTask themeTypes(String ... themeTypes) {
        return this.themeTypes(Arrays.asList(themeTypes));
    }

    protected void copyDiffs() {
        final File diffsDir = this.getDiffsDir();
        if (diffsDir == null || !diffsDir.exists()) {
            return;
        }
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall(CopySpec copySpec) {
                copySpec.from(new Object[]{diffsDir});
                copySpec.into((Object)CompileThemeTask.this.getThemeRootDir());
            }
        };
        this._project.copy((Closure)closure);
    }

    protected void copyPortalThemeDir(String theme, String[] excludes, String include) throws Exception {
        this.copyPortalThemeDir(theme, excludes, new String[]{include});
    }

    protected void copyPortalThemeDir(String theme, final String[] excludes, final String[] includes) throws Exception {
        final String prefix = theme + "/";
        final File frontendThemesWebDir = this.getFrontendThemesWebDir();
        if (frontendThemesWebDir != null) {
            Closure<Void> closure = new Closure<Void>(null){

                public void doCall(CopySpec copySpec) {
                    copySpec.from(new Object[]{new File(frontendThemesWebDir, prefix)});
                    if (ArrayUtil.isNotEmpty((Object[])excludes)) {
                        copySpec.exclude(excludes);
                    }
                    copySpec.include(includes);
                    copySpec.into((Object)CompileThemeTask.this.getThemeRootDir());
                }
            };
            this._project.copy((Closure)closure);
        } else {
            String jarPrefix = "META-INF/resources/" + prefix;
            final File frontendThemeFile = this.getFrontendThemeFile(theme);
            final String[] prefixedExcludes = StringUtil.prepend((String[])excludes, (String)jarPrefix);
            final String[] prefixedIncludes = StringUtil.prepend((String[])includes, (String)jarPrefix);
            Closure<Void> closure = new Closure<Void>(null){

                public void doCall(CopySpec copySpec) {
                    copySpec.eachFile((Action)new StripPathSegmentsAction(3));
                    if (ArrayUtil.isNotEmpty((Object[])prefixedExcludes)) {
                        copySpec.exclude(prefixedExcludes);
                    }
                    copySpec.from(new Object[]{CompileThemeTask.this._project.zipTree((Object)frontendThemeFile)});
                    copySpec.include(prefixedIncludes);
                    copySpec.into((Object)CompileThemeTask.this.getThemeRootDir());
                    copySpec.setIncludeEmptyDirs(false);
                }
            };
            this._project.copy((Closure)closure);
        }
    }

    protected void copyThemeParent() throws Exception {
        String themeParent = this.getThemeParent();
        if (Validator.isNull((String)themeParent)) {
            return;
        }
        if (themeParent.equals("_styled") || themeParent.equals("_unstyled")) {
            this.copyThemeParentUnstyled();
        }
        if (themeParent.equals("_styled")) {
            this.copyThemeParentStyled();
        } else if (themeParent.equals("admin") || themeParent.equals("classic")) {
            this.copyThemeParentPortal();
        }
    }

    protected void copyThemeParentPortal() throws Exception {
        String themeParent = this.getThemeParent();
        this.copyPortalThemeDir(themeParent, new String[]{"**/.sass-cache/**", "_diffs/**", "templates/**"}, "**");
        Set<String> themeTypes = this.getThemeTypes();
        String[] includes = StringUtil.prepend((String[])themeTypes.toArray(new String[themeTypes.size()]), (String)"templates/*.");
        this.copyPortalThemeDir(themeParent, null, includes);
    }

    protected void copyThemeParentStyled() throws Exception {
        this.copyPortalThemeDir("_styled", new String[]{"**/*.css", "npm-debug.log", "package.json"}, "**");
    }

    protected void copyThemeParentUnstyled() throws Exception {
        this.copyPortalThemeDir("_unstyled", new String[]{"**/*.css", "npm-debug.log", "package.json", "templates/**"}, "**");
        Set<String> themeTypes = this.getThemeTypes();
        String[] themeTypesArray = themeTypes.toArray(new String[themeTypes.size()]);
        String[] excludes = null;
        if (this.getFrontendThemesWebDir() != null) {
            excludes = StringUtil.prepend((String[])themeTypesArray, (String)"templates/init.");
        }
        String[] includes = StringUtil.prepend((String[])themeTypesArray, (String)"templates/**/*.");
        this.copyPortalThemeDir("_unstyled", excludes, includes);
    }

    protected File getFrontendThemeFile(String theme) throws Exception {
        for (File file : this.getFrontendThemeFiles()) {
            JarFile jarFile = new JarFile(file);
            Throwable throwable = null;
            try {
                JarEntry jarEntry = jarFile.getJarEntry("META-INF/resources/" + theme);
                if (jarEntry == null) continue;
                File file2 = file;
                return file2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jarFile == null) continue;
                if (throwable != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                jarFile.close();
            }
        }
        return null;
    }
}

