/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.cache.CacheExtension;
import com.liferay.gradle.plugins.cache.CachePlugin;
import com.liferay.gradle.plugins.cache.task.TaskCache;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.tasks.ReplaceRegexTask;
import com.liferay.gradle.plugins.util.GradleUtil;
import com.liferay.gradle.plugins.util.IncrementVersionClosure;
import groovy.lang.Closure;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.tasks.Upload;

public class LiferayThemeDefaultsPlugin
implements Plugin<Project> {
    private static final String _GROUP = "com.liferay.plugins";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayThemePlugin.class);
        this.applyPlugins(project);
        this.addTaskInstall(project);
        this.applyConfigScripts(project);
        final ReplaceRegexTask updateVersionTask = this.addTaskUpdateVersion(project);
        this.configureCache(project);
        this.configureDeployDir(project);
        this.configureProject(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                GradleUtil.setProjectSnapshotVersion(project);
                LiferayThemeDefaultsPlugin.this.configureTaskUploadArchives(project, (Task)updateVersionTask);
            }
        });
    }

    protected Upload addTaskInstall(Project project) {
        Upload upload = (Upload)GradleUtil.addTask((Project)project, (String)"install", Upload.class);
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        upload.setConfiguration(configuration);
        upload.setDescription("Installs the '" + configuration.getName() + "' artifacts into the local Maven repository.");
        return upload;
    }

    protected ReplaceRegexTask addTaskUpdateVersion(Project project) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)"updateVersion", ReplaceRegexTask.class);
        replaceRegexTask.match("\\n\\t\"version\": \"(.+)\"", "package.json");
        replaceRegexTask.setDescription("Updates the project version in the package.json file.");
        replaceRegexTask.setReplacement((Object)IncrementVersionClosure.MICRO_INCREMENT);
        return replaceRegexTask;
    }

    protected void applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/dependencies/config-maven.gradle", (Object)project);
    }

    protected void applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, CachePlugin.class);
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
    }

    protected void configureCache(Project project) {
        CacheExtension cacheExtension = (CacheExtension)GradleUtil.getExtension((ExtensionAware)project, CacheExtension.class);
        cacheExtension.task("gulpBuild", (Closure)new Closure<Void>(null){

            public void doCall(TaskCache taskCache) {
                taskCache.setBaseDir((Object)"dist");
                taskCache.setCacheDir((Object)".task-cache");
                taskCache.skipTaskDependency(new Object[]{"downloadNode", "npmInstall"});
                taskCache.testFile(new Object[]{"gulpfile.js", "package.json", "src"});
            }
        });
    }

    protected void configureDeployDir(Project project) {
        final LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        liferayExtension.setDeployDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(liferayExtension.getLiferayHome(), "deploy");
            }
        });
    }

    protected void configureProject(Project project) {
        project.setGroup((Object)_GROUP);
    }

    protected void configureTaskUploadArchives(Project project, Task updateThemeVersionTask) {
        if (GradleUtil.isSnapshot(project)) {
            return;
        }
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        uploadArchivesTask.finalizedBy(new Object[]{updateThemeVersionTask});
    }
}

