/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.AntBuilder;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.BasePluginConvention;

public class LiferayAntPlugin
implements Plugin<Project> {
    private static final String _WAR_TASK_NAME = "war";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        AntBuilder antBuilder = project.getAnt();
        antBuilder.importBuild((Object)"build.xml");
        this.configureArchivesBaseName(project, antBuilder);
        this.configureArtifacts(project, antBuilder);
        this.configureVersion(project, antBuilder);
    }

    protected void configureArchivesBaseName(Project project, AntBuilder antBuilder) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        basePluginConvention.setArchivesBaseName(String.valueOf(antBuilder.getProperty("plugin.name")));
    }

    protected void configureArtifacts(final Project project, AntBuilder antBuilder) {
        ArtifactHandler artifacts = project.getArtifacts();
        File pluginFile = project.file(antBuilder.getProperty("plugin.file"));
        artifacts.add("archives", (Object)pluginFile, (Closure)new Closure<Void>(null){

            public void doCall(ConfigurablePublishArtifact configurablePublishArtifact) {
                Task warTask = GradleUtil.getTask((Project)project, (String)LiferayAntPlugin._WAR_TASK_NAME);
                configurablePublishArtifact.builtBy(new Object[]{warTask});
                configurablePublishArtifact.setName(GradleUtil.getArchivesBaseName(project));
            }
        });
    }

    protected void configureVersion(Project project, AntBuilder antBuilder) {
        project.setVersion(antBuilder.getProperty("plugin.full.version"));
    }
}

